/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.brics;

import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.automatalib.automata.Automaton;
import net.automatalib.automata.fsa.abstractimpl.AbstractFSA;
import net.automatalib.automata.graphs.AbstractAutomatonGraph;
import net.automatalib.brics.BricsDOTHelper;
import net.automatalib.brics.BricsTransitionProperty;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.UniversalGraph;
import net.automatalib.graphs.concepts.NodeIDs;
import net.automatalib.graphs.dot.DOTPlottableGraph;
import net.automatalib.graphs.dot.GraphDOTHelper;

public abstract class AbstractBricsAutomaton
extends AbstractFSA<State, Character>
implements DOTPlottableGraph<State, Transition>,
UniversalGraph<State, Transition, Boolean, BricsTransitionProperty> {
    protected final dk.brics.automaton.Automaton automaton;

    public AbstractBricsAutomaton(dk.brics.automaton.Automaton automaton) {
        this.automaton = automaton;
    }

    public dk.brics.automaton.Automaton getBricsAutomaton() {
        return this.automaton;
    }

    public Collection<State> getNodes() {
        return AbstractAutomatonGraph.getNodes((Automaton)this);
    }

    public NodeIDs<State> nodeIDs() {
        return AbstractAutomatonGraph.nodeIDs((Automaton)this);
    }

    public Collection<Transition> getOutgoingEdges(State node) {
        return node.getTransitions();
    }

    public State getTarget(Transition edge) {
        return edge.getDest();
    }

    public <V> MutableMapping<State, V> createStaticNodeMapping() {
        return AbstractAutomatonGraph.createStaticNodeMapping((Automaton)this);
    }

    public <V> MutableMapping<State, V> createDynamicNodeMapping() {
        return AbstractAutomatonGraph.createDynamicNodeMapping((Automaton)this);
    }

    public boolean isAccepting(State state) {
        return state.isAccept();
    }

    public Collection<State> getTransitions(State state, Character input) {
        List transitions = state.getSortedTransitions(false);
        HashSet<State> result = new HashSet<State>();
        for (Transition t : transitions) {
            char min = t.getMin();
            if (input.charValue() < min) break;
            char max = t.getMax();
            if (input.charValue() > max) continue;
            result.add(t.getDest());
        }
        return result;
    }

    public Set<State> getInitialStates() {
        return Collections.singleton(this.automaton.getInitialState());
    }

    public Collection<State> getStates() {
        return this.automaton.getStates();
    }

    public GraphDOTHelper<State, Transition> getGraphDOTHelper() {
        return new BricsDOTHelper(this);
    }

    public Boolean getNodeProperty(State node) {
        return node.isAccept();
    }

    public BricsTransitionProperty getEdgeProperty(Transition edge) {
        return new BricsTransitionProperty(edge);
    }
}

