/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.words;

import java.util.AbstractList;
import java.util.List;
import net.automatalib.commons.util.array.ResizingObjectArray;
import net.automatalib.words.SharedWord;
import net.automatalib.words.Word;

public final class WordBuilder<I>
extends AbstractList<I> {
    private final ResizingObjectArray storage;
    private Object[] array;
    private int length;
    private boolean lock = false;

    public WordBuilder() {
        this.storage = new ResizingObjectArray();
        this.array = this.storage.array;
    }

    public WordBuilder(int initialCapacity) {
        this.storage = new ResizingObjectArray(initialCapacity);
        this.array = this.storage.array;
    }

    public WordBuilder(I initSym, int count) {
        this.storage = new ResizingObjectArray(count);
        this.array = this.storage.array;
        if (initSym != null) {
            for (int i = 0; i < count; ++i) {
                this.array[i] = initSym;
            }
        }
        this.length = count;
    }

    public WordBuilder(int capacity, I initSym, int count) {
        if (capacity < count) {
            capacity = count;
        }
        this.storage = new ResizingObjectArray(capacity);
        this.array = this.storage.array;
        if (initSym != null) {
            for (int i = 0; i < count; ++i) {
                this.array[i] = initSym;
            }
        }
        this.length = count;
    }

    public WordBuilder(Word<I> init) {
        int wLen = init.length();
        this.storage = new ResizingObjectArray(wLen);
        this.array = this.storage.array;
        init.writeToArray(0, this.array, 0, wLen);
        this.length = wLen;
    }

    public WordBuilder(int capacity, Word<I> init) {
        int wLen = init.length();
        if (capacity < wLen) {
            capacity = wLen;
        }
        this.storage = new ResizingObjectArray(capacity);
        this.array = this.storage.array;
        init.writeToArray(0, this.array, 0, wLen);
        this.length = wLen;
    }

    public WordBuilder<I> append(List<? extends I> symList) {
        int lLen = symList.size();
        this.ensureAdditionalCapacity(lLen);
        for (I sym : symList) {
            this.array[this.length++] = sym;
        }
        return this;
    }

    public WordBuilder<I> append(Word<? extends I> word) {
        int wLen = word.length();
        this.ensureAdditionalCapacity(wLen);
        word.writeToArray(0, this.array, this.length, wLen);
        this.length += wLen;
        return this;
    }

    @SafeVarargs
    public final WordBuilder<I> append(Word<? extends I> ... words) {
        int i;
        if (words.length == 0) {
            return this;
        }
        int allLen = 0;
        for (i = 0; i < words.length; ++i) {
            allLen += words[i].length();
        }
        this.ensureAdditionalCapacity(allLen);
        for (i = 0; i < words.length; ++i) {
            Word<I> word = words[i];
            int wLen = word.length();
            word.writeToArray(0, this.array, this.length, wLen);
            this.length += wLen;
        }
        return this;
    }

    public WordBuilder<I> repeatAppend(int num, Word<I> word) {
        if (num == 0) {
            return this;
        }
        int wLen = word.length();
        int allLen = wLen * num;
        this.ensureAdditionalCapacity(allLen);
        while (num-- > 0) {
            word.writeToArray(0, this.array, this.length, wLen);
            this.length += wLen;
        }
        return this;
    }

    public WordBuilder<I> append(I symbol) {
        this.ensureAdditionalCapacity(1);
        this.array[this.length++] = symbol;
        return this;
    }

    public WordBuilder<I> repeatAppend(int num, I symbol) {
        if (num == 0) {
            return this;
        }
        this.ensureAdditionalCapacity(num);
        if (symbol == null) {
            this.length += num;
        } else {
            while (num-- > 0) {
                this.array[this.length++] = symbol;
            }
        }
        return this;
    }

    @SafeVarargs
    public final WordBuilder<I> append(I ... symbols) {
        if (symbols.length == 0) {
            return this;
        }
        this.ensureAdditionalCapacity(symbols.length);
        System.arraycopy(symbols, 0, this.array, this.length, symbols.length);
        this.length += symbols.length;
        return this;
    }

    public void ensureCapacity(int cap) {
        if (this.storage.ensureCapacity(cap)) {
            this.lock = false;
            this.array = this.storage.array;
        }
    }

    public void ensureAdditionalCapacity(int add) {
        this.ensureCapacity(this.length + add);
    }

    private final void ensureUnlocked() {
        if (this.lock) {
            this.array = (Object[])this.array.clone();
            this.storage.array = this.array;
            this.lock = false;
        }
    }

    public I getSymbol(int index) {
        return (I)this.array[index];
    }

    public WordBuilder<I> setSymbol(int index, I symbol) {
        this.ensureUnlocked();
        this.array[index] = symbol;
        return this;
    }

    public WordBuilder<I> truncate(int truncLen) {
        if (truncLen >= this.length) {
            return this;
        }
        this.ensureUnlocked();
        for (int i = truncLen; i < this.length; ++i) {
            this.array[i] = null;
        }
        this.length = truncLen;
        return this;
    }

    public Word<I> toWord(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.length) {
            throw new IndexOutOfBoundsException();
        }
        int len = toIndex - fromIndex;
        this.lock = true;
        return new SharedWord(this.array, fromIndex, len);
    }

    public Word<I> toWord() {
        this.lock = true;
        return new SharedWord(this.array, 0, this.length);
    }

    @Override
    public boolean add(I e) {
        this.append(e);
        return true;
    }

    @Override
    public I get(int index) {
        return this.getSymbol(index);
    }

    @Override
    public I set(int index, I element) {
        I old = this.getSymbol(index);
        this.setSymbol(index, element);
        return old;
    }

    @Override
    public void clear() {
        this.ensureUnlocked();
        for (int i = 0; i < this.length; ++i) {
            this.array[i] = null;
        }
        this.length = 0;
    }

    @Override
    public int size() {
        return this.length;
    }

    public WordBuilder<I> reverse() {
        this.ensureUnlocked();
        int lowIdx = 0;
        int highIdx = this.length - 1;
        while (lowIdx < highIdx) {
            Object tmp = this.array[lowIdx];
            this.array[lowIdx++] = this.array[highIdx];
            this.array[highIdx--] = tmp;
        }
        return this;
    }
}

