/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.word;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import net.automatalib.common.smartcollection.ArrayUtil;
import net.automatalib.word.SharedWord;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class WordBuilder<I>
extends AbstractList<I> {
    private @Nullable Object[] array;
    private int length;
    private boolean lock;

    public WordBuilder() {
        this.array = new Object[10];
    }

    public WordBuilder(int initialCapacity) {
        this.array = new Object[Math.max(0, initialCapacity)];
    }

    public WordBuilder(I initSym, int count) {
        this.array = new Object[count];
        if (initSym != null) {
            Arrays.fill(this.array, initSym);
        }
        this.length = count;
    }

    public WordBuilder(int capacity, I initSym, int count) {
        this.array = new Object[Math.max(capacity, count)];
        if (initSym != null) {
            Arrays.fill(this.array, 0, count, initSym);
        }
        this.length = count;
    }

    public WordBuilder(Word<I> init) {
        int wLen = init.length();
        this.array = new Object[wLen];
        init.writeToArray(0, this.array, 0, wLen);
        this.length = wLen;
    }

    public WordBuilder(int capacity, Word<I> init) {
        int wLen = init.length();
        this.array = new Object[Math.max(capacity, wLen)];
        init.writeToArray(0, this.array, 0, wLen);
        this.length = wLen;
    }

    public WordBuilder<I> append(I symbol) {
        this.ensureAdditionalCapacity(1);
        this.array[this.length++] = symbol;
        return this;
    }

    public WordBuilder<I> append(List<? extends I> symList) {
        int lLen = symList.size();
        this.ensureAdditionalCapacity(lLen);
        for (I sym : symList) {
            this.array[this.length++] = sym;
        }
        return this;
    }

    public WordBuilder<I> append(Word<? extends I> word) {
        int wLen = word.length();
        this.ensureAdditionalCapacity(wLen);
        word.writeToArray(0, this.array, this.length, wLen);
        this.length += wLen;
        return this;
    }

    @SafeVarargs
    public final WordBuilder<I> append(Word<? extends I> ... words) {
        if (words.length == 0) {
            return this;
        }
        int allLen = 0;
        for (Word<I> word : words) {
            allLen += word.length();
        }
        this.ensureAdditionalCapacity(allLen);
        for (Word<I> word : words) {
            int wLen = word.length();
            word.writeToArray(0, this.array, this.length, wLen);
            this.length += wLen;
        }
        return this;
    }

    @SafeVarargs
    public final WordBuilder<I> append(I ... symbols) {
        if (symbols.length == 0) {
            return this;
        }
        this.ensureAdditionalCapacity(symbols.length);
        System.arraycopy(symbols, 0, this.array, this.length, symbols.length);
        this.length += symbols.length;
        return this;
    }

    public void ensureAdditionalCapacity(int add) {
        this.ensureCapacity(this.length + add);
    }

    public void ensureCapacity(int cap) {
        if (this.array.length < cap) {
            int newCap = ArrayUtil.computeNewCapacity((int)this.array.length, (int)cap);
            this.array = Arrays.copyOf(this.array, newCap);
            this.lock = false;
        }
    }

    public WordBuilder<I> repeatAppend(int num, Word<I> word) {
        if (num == 0) {
            return this;
        }
        int wLen = word.length();
        int allLen = wLen * num;
        this.ensureAdditionalCapacity(allLen);
        for (int i = num; i > 0; --i) {
            word.writeToArray(0, this.array, this.length, wLen);
            this.length += wLen;
        }
        return this;
    }

    public WordBuilder<I> repeatAppend(int num, I symbol) {
        if (num == 0) {
            return this;
        }
        this.ensureAdditionalCapacity(num);
        if (symbol == null) {
            this.length += num;
        } else {
            for (int i = num; i > 0; --i) {
                this.array[this.length++] = symbol;
            }
        }
        return this;
    }

    public WordBuilder<I> truncate(int truncLen) {
        if (truncLen >= this.length) {
            return this;
        }
        this.ensureUnlocked();
        Arrays.fill(this.array, truncLen, this.length, null);
        this.length = truncLen;
        return this;
    }

    private void ensureUnlocked() {
        if (this.lock) {
            this.array = (Object[])this.array.clone();
            this.lock = false;
        }
    }

    public Word<I> toWord(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.length) {
            throw new IndexOutOfBoundsException();
        }
        int len = toIndex - fromIndex;
        this.lock = true;
        return new SharedWord(this.array, fromIndex, len);
    }

    public Word<I> toWord() {
        this.lock = true;
        return new SharedWord(this.array, 0, this.length);
    }

    @Override
    public boolean add(I e) {
        this.append(e);
        return true;
    }

    @Override
    public I get(int index) {
        return this.getSymbol(index);
    }

    public I getSymbol(int index) {
        return (I)this.array[index];
    }

    @Override
    public I set(int index, I element) {
        I old = this.getSymbol(index);
        this.setSymbol(index, element);
        return old;
    }

    public WordBuilder<I> setSymbol(int index, I symbol) {
        this.ensureUnlocked();
        this.array[index] = symbol;
        return this;
    }

    @Override
    public void clear() {
        this.ensureUnlocked();
        Arrays.fill(this.array, 0, this.length, null);
        this.length = 0;
    }

    @Override
    public int size() {
        return this.length;
    }

    public WordBuilder<I> reverse() {
        this.ensureUnlocked();
        int lowIdx = 0;
        int highIdx = this.length - 1;
        while (lowIdx < highIdx) {
            Object tmp = this.array[lowIdx];
            this.array[lowIdx++] = this.array[highIdx];
            this.array[highIdx--] = tmp;
        }
        return this;
    }
}

