/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.word;

import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.word.LetterWord;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

final class EmptyWord
extends Word<Object> {
    public static final EmptyWord INSTANCE = new EmptyWord();

    EmptyWord() {
    }

    @Override
    public int length() {
        return 0;
    }

    @Override
    public Spliterator<Object> spliterator() {
        return Spliterators.emptySpliterator();
    }

    @Override
    public Word<Object> subWordInternal(int fromIndex, int toIndex) {
        return this;
    }

    @Override
    public void writeToArray(int offset, @Nullable Object[] array, int tgtOffset, int length) {
    }

    @Override
    public Object getSymbol(int index) {
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    @Override
    public List<Object> asList() {
        return Collections.emptyList();
    }

    @Override
    public Word<Object> canonicalNext(Alphabet<Object> sigma) {
        return new LetterWord<Object>(sigma.getSymbol(0));
    }

    @Override
    public Object lastSymbol() {
        throw new NoSuchElementException();
    }

    @Override
    public Word<Object> append(Object symbol) {
        return new LetterWord<Object>(symbol);
    }

    @Override
    public Word<Object> prepend(Object symbol) {
        return this.append(symbol);
    }

    @Override
    public boolean isPrefixOf(Word<?> other) {
        return true;
    }

    @Override
    public Word<Object> longestCommonPrefix(Word<?> other) {
        return this;
    }

    @Override
    public boolean isSuffixOf(Word<?> other) {
        return true;
    }

    @Override
    public Word<Object> longestCommonSuffix(Word<?> other) {
        return this;
    }

    @Override
    public Word<Object> flatten() {
        return this;
    }

    @Override
    public Word<Object> trimmed() {
        return this;
    }

    @Override
    public <T> Word<T> transform(Function<? super Object, ? extends T> transformer) {
        return this;
    }
}

