/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.automatalib.common.util.Pair;
import net.automatalib.graph.Graph;
import net.automatalib.graph.ProceduralModalProcessGraph;
import net.automatalib.graph.SimpleGraph;
import net.automatalib.graph.visualization.CFMPSVisualizationHelper;
import net.automatalib.visualization.VisualizationHelper;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CFMPSGraphView<N, L, E, AP>
implements Graph<Pair<L, N>, Pair<L, E>> {
    private final Map<L, ProceduralModalProcessGraph<N, L, E, AP, ?>> pmpgs;

    public CFMPSGraphView(Map<L, ? extends ProceduralModalProcessGraph<? extends N, L, ? extends E, AP, ?>> pmpgs) {
        this.pmpgs = pmpgs;
    }

    @Override
    public Collection<Pair<L, E>> getOutgoingEdges(Pair<L, N> node) {
        Object process = node.getFirst();
        @NonNull ProceduralModalProcessGraph<Object, L, E, AP, ?> pmpg = this.pmpgs.get(process);
        Collection outgoingEdges = pmpg.getOutgoingEdges(node.getSecond());
        ArrayList<Pair<L, Pair>> result = new ArrayList<Pair<L, Pair>>(outgoingEdges.size());
        for (Object e : outgoingEdges) {
            result.add(Pair.of((Object)process, e));
        }
        return result;
    }

    @Override
    public Pair<L, N> getTarget(Pair<L, E> edge) {
        Object process = edge.getFirst();
        @NonNull ProceduralModalProcessGraph<N, L, Object, AP, ?> pmpg = this.pmpgs.get(process);
        return Pair.of((Object)process, pmpg.getTarget(edge.getSecond()));
    }

    @Override
    public Collection<Pair<L, N>> getNodes() {
        int numNodes = this.pmpgs.values().stream().mapToInt(SimpleGraph::size).sum();
        ArrayList<Pair<L, N>> result = new ArrayList<Pair<L, N>>(numNodes);
        for (Map.Entry<L, ProceduralModalProcessGraph<N, L, E, AP, ?>> e : this.pmpgs.entrySet()) {
            L process = e.getKey();
            for (Object n : e.getValue()) {
                result.add(Pair.of(process, n));
            }
        }
        return result;
    }

    @Override
    public VisualizationHelper<Pair<L, N>, Pair<L, E>> getVisualizationHelper() {
        return new CFMPSVisualizationHelper<N, L, E>(this.pmpgs);
    }
}

