/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.visualization;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import net.automatalib.automaton.concept.StateIDs;
import net.automatalib.common.util.Pair;
import net.automatalib.common.util.Triple;
import net.automatalib.visualization.DefaultVisualizationHelper;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ProceduralVisualizationHelper<S, I>
extends DefaultVisualizationHelper<Pair<I, S>, Triple<I, I, S>> {
    private final Map<I, UniversalDeterministicAutomaton<S, I, ?, ?, ?>> subModels;
    private final Map<I, StateIDs<S>> stateIDs;
    private final Alphabet<I> internalAlphabet;

    public ProceduralVisualizationHelper(Alphabet<I> internalAlphabet, Map<I, ? extends UniversalDeterministicAutomaton<? extends S, I, ?, ?, ?>> subModels) {
        this.internalAlphabet = internalAlphabet;
        this.subModels = subModels;
        this.stateIDs = Maps.newHashMapWithExpectedSize((int)subModels.size());
        for (Map.Entry<I, UniversalDeterministicAutomaton<S, I, ?, ?, ?>> e : subModels.entrySet()) {
            this.stateIDs.put(e.getKey(), e.getValue().stateIDs());
        }
    }

    @Override
    protected Collection<Pair<I, S>> initialNodes() {
        ArrayList<Pair<I, S>> initialNodes = new ArrayList<Pair<I, S>>(this.subModels.size());
        for (Map.Entry<I, UniversalDeterministicAutomaton<S, I, ?, ?, ?>> e : this.subModels.entrySet()) {
            Object init = e.getValue().getInitialState();
            assert (init != null);
            initialNodes.add(Pair.of(e.getKey(), init));
        }
        return initialNodes;
    }

    @Override
    public boolean getNodeProperties(Pair<I, S> node, Map<String, String> properties) {
        super.getNodeProperties(node, properties);
        Object identifier = node.getFirst();
        @NonNull UniversalDeterministicAutomaton<Object, I, ?, ?, ?> subModel = this.subModels.get(identifier);
        @NonNull StateIDs<Object> stateID = this.stateIDs.get(identifier);
        if (Boolean.TRUE.equals(subModel.getStateProperty(node.getSecond()))) {
            properties.put("shape", "doublecircle");
        } else {
            properties.put("shape", "circle");
        }
        properties.put("label", node.getFirst() + " " + stateID.getStateId(node.getSecond()));
        return true;
    }

    @Override
    public boolean getEdgeProperties(Pair<I, S> src, Triple<I, I, S> edge, Pair<I, S> tgt, Map<String, String> properties) {
        super.getEdgeProperties(src, edge, tgt, properties);
        Object state = src.getSecond();
        Object identifier = edge.getFirst();
        Object input = edge.getSecond();
        @NonNull UniversalDeterministicAutomaton<Object, Object, ?, ?, ?> subModel = this.subModels.get(identifier);
        Object tp = subModel.getTransitionProperty(state, input);
        if (tp != null) {
            properties.put("label", input + " / " + tp);
        } else {
            properties.put("label", String.valueOf(edge.getSecond()));
        }
        if (!this.internalAlphabet.containsSymbol(edge.getSecond())) {
            properties.put("style", "bold");
        }
        return true;
    }
}

