/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.helper;

import net.automatalib.automaton.concept.StateIDs;
import net.automatalib.common.smartcollection.ResizingArrayStorage;
import net.automatalib.common.util.mapping.MutableMapping;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StateIDGrowingMapping<S, @Nullable V>
implements MutableMapping<S, V> {
    private final StateIDs<S> stateIds;
    private final ResizingArrayStorage<V> storage;

    public StateIDGrowingMapping(StateIDs<S> stateIds, int size) {
        this.stateIds = stateIds;
        this.storage = new ResizingArrayStorage(Object.class, size);
    }

    public V get(S elem) {
        int id = this.stateIds.getStateId(elem);
        if (id >= 0 && id < this.storage.array.length) {
            return (V)this.storage.array[id];
        }
        return null;
    }

    public V put(S key, V value) {
        int id = this.stateIds.getStateId(key);
        if (id >= this.storage.array.length) {
            this.storage.ensureCapacity(id + 1);
        }
        Object old = this.storage.array[id];
        this.storage.array[id] = value;
        return (V)old;
    }
}

