/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.alphabet;

import java.util.List;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.VPAlphabet;
import net.automatalib.common.util.Pair;
import net.automatalib.common.util.mapping.Mapping;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;

public interface ProceduralInputAlphabet<I>
extends VPAlphabet<I> {
    public Alphabet<I> getProceduralAlphabet();

    default public I getReturnSymbol() {
        return this.getReturnSymbol(0);
    }

    default public int findCallIndex(Word<I> input, int idx) {
        return this.findCallIndex(input.asList(), idx);
    }

    default public int findCallIndex(List<I> input, int idx) {
        if (idx > input.size()) {
            return -1;
        }
        int balance = 0;
        for (int i = idx - 1; i >= 0; --i) {
            I sym = input.get(i);
            if (this.isReturnSymbol(sym)) {
                ++balance;
            }
            if (!this.isCallSymbol(sym)) continue;
            if (balance > 0) {
                --balance;
                continue;
            }
            return i;
        }
        return -1;
    }

    default public int findReturnIndex(Word<I> input, int idx) {
        return this.findReturnIndex(input.asList(), idx);
    }

    default public int findReturnIndex(List<I> input, int idx) {
        if (idx < 0) {
            return -1;
        }
        int balance = 0;
        for (int i = idx; i < input.size(); ++i) {
            I sym = input.get(i);
            if (this.isCallSymbol(sym)) {
                ++balance;
            }
            if (!this.isReturnSymbol(sym)) continue;
            if (balance > 0) {
                --balance;
                continue;
            }
            return i;
        }
        return -1;
    }

    default public Word<I> expand(Iterable<I> input, Mapping<I, Word<I>> terminatingSequences) {
        WordBuilder<I> wb = new WordBuilder<I>();
        for (I sym : input) {
            if (this.isCallSymbol(sym)) {
                wb.append(sym);
                wb.append((Word<I>)((Word)terminatingSequences.get(sym)));
                wb.append(this.getReturnSymbol());
                continue;
            }
            wb.append(sym);
        }
        return wb.toWord();
    }

    default public Word<I> project(Word<I> input, int idx) {
        WordBuilder<I> wb = new WordBuilder<I>(input.size());
        for (int i = Math.max(0, idx); i < input.size(); ++i) {
            int returnIdx;
            I sym = input.getSymbol(i);
            wb.append(input.getSymbol(i));
            if (!this.isCallSymbol(sym) || (returnIdx = this.findReturnIndex(input, i + 1)) <= -1) continue;
            i = returnIdx;
        }
        return wb.toWord();
    }

    default public <O> Pair<Word<I>, Word<O>> project(Word<I> input, Word<O> output, int idx) {
        if (!1.$assertionsDisabled && input.size() != output.size()) {
            throw new AssertionError();
        }
        WordBuilder<I> inBuilder = new WordBuilder<I>(input.size() - idx);
        WordBuilder<O> outBuilder = new WordBuilder<O>(input.size() - idx);
        for (int i = Math.max(0, idx); i < input.size(); ++i) {
            int returnIdx;
            I sym = input.getSymbol(i);
            inBuilder.append(input.getSymbol(i));
            outBuilder.append(output.getSymbol(i));
            if (!this.isCallSymbol(sym) || (returnIdx = this.findReturnIndex(input, i + 1)) <= -1) continue;
            i = returnIdx;
        }
        return Pair.of(inBuilder.toWord(), outBuilder.toWord());
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

