/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
public class XmlTreeUtil {
    private String tabSpace = "   ";
    private String lineSpace = "\n";
    private boolean print_document_node = true;

    public void setPrintDocumentNode(boolean b) {
        this.print_document_node = b;
    }

    public void setCollapsed() {
        this.tabSpace = "";
        this.lineSpace = "";
    }

    public String printTree(Document XMLDocument) {
        return new String(this.printTreeBytes(XMLDocument));
    }

    public byte[] printTreeBytes(Document XMLDocument) {
        byte[] xmlData = new byte[]{};
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.printTree(XMLDocument, baos);
            xmlData = baos.toByteArray();
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return xmlData;
    }

    public void printTree(Document XMLDocument, OutputStream os) {
        int nodeLevel = 0;
        try {
            this._printTree(XMLDocument, os, nodeLevel);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void _printTree(Node node, OutputStream os, int nodeLevel) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                if (this.print_document_node) {
                    String data = new String("<?xml version=\"1.0\"?>" + this.lineSpace);
                    os.write(data.getBytes());
                }
                Document doc = (Document)node;
                this._printTree(doc.getDocumentElement(), os, nodeLevel);
                break;
            }
            case 1: {
                String tab = "";
                for (int i = 0; i < nodeLevel; ++i) {
                    tab = tab + this.tabSpace;
                }
                ++nodeLevel;
                String name = node.getNodeName();
                String elmName = tab + "<" + name;
                os.write(elmName.getBytes());
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node current = attributes.item(i);
                    String attrSet = new String(" " + current.getNodeName() + "=\"" + current.getNodeValue() + "\"");
                    os.write(attrSet.getBytes());
                }
                NodeList children = node.getChildNodes();
                if (children != null && children.getLength() > 0) {
                    String endElm = new String(">" + this.lineSpace);
                    os.write(endElm.getBytes());
                    for (int i = 0; i < children.getLength(); ++i) {
                        this._printTree(children.item(i), os, nodeLevel);
                    }
                    String closeElm = new String(tab + "</" + name + ">" + this.lineSpace);
                    os.write(closeElm.getBytes());
                } else {
                    String closeElm = new String(" />" + this.lineSpace);
                    os.write(closeElm.getBytes());
                }
                --nodeLevel;
                break;
            }
            case 3: {
                String value = node.getNodeValue();
                if (value == null) break;
                value = value.trim();
                os.write(value.getBytes());
                break;
            }
            case 4: {
                String dataValue = node.getNodeValue();
                if (dataValue == null || dataValue.length() <= 0) break;
                dataValue = new String("<![CDATA[" + dataValue + "]]>");
                os.write(dataValue.getBytes());
                break;
            }
            case 7: {
                break;
            }
            case 5: {
                break;
            }
        }
    }
}

