/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.reporting;

import java.util.ArrayList;
import net.authorize.AuthNetField;
import net.authorize.ResponseCode;
import net.authorize.ResponseReasonCode;
import net.authorize.data.Order;
import net.authorize.data.OrderItem;
import net.authorize.data.ShippingCharges;
import net.authorize.data.creditcard.AVSCode;
import net.authorize.data.creditcard.CardType;
import net.authorize.data.creditcard.CreditCard;
import net.authorize.data.echeck.ECheckType;
import net.authorize.data.reporting.ReturnedItem;
import net.authorize.data.reporting.Solution;
import net.authorize.data.reporting.Subscription;
import net.authorize.data.xml.Address;
import net.authorize.data.xml.BankAccount;
import net.authorize.data.xml.Customer;
import net.authorize.data.xml.CustomerType;
import net.authorize.data.xml.Payment;
import net.authorize.data.xml.reporting.BatchDetails;
import net.authorize.data.xml.reporting.BatchStatistics;
import net.authorize.data.xml.reporting.CAVVResponseType;
import net.authorize.data.xml.reporting.CardCodeResponseType;
import net.authorize.data.xml.reporting.FDSFilter;
import net.authorize.data.xml.reporting.FDSFilterActionType;
import net.authorize.data.xml.reporting.ReportingDetails;
import net.authorize.data.xml.reporting.ReportingTransactionType;
import net.authorize.data.xml.reporting.SettlementStateType;
import net.authorize.data.xml.reporting.TransactionDetails;
import net.authorize.data.xml.reporting.TransactionStatusType;
import net.authorize.reporting.Transaction;
import net.authorize.util.BasicXmlDocument;
import net.authorize.util.StringUtils;
import net.authorize.xml.Message;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class Result<T>
extends net.authorize.xml.Result<T> {
    private static final long serialVersionUID = 1L;
    protected String refId;
    protected ReportingDetails reportingDetails;

    public static <T> Result<T> createResult(T object, BasicXmlDocument response) {
        Result<T> result = new Result<T>();
        if (object instanceof Transaction) {
            Transaction targetTransaction = Transaction.createTransaction((Transaction)object, response);
            super.importRefId(targetTransaction);
            super.importResponseMessages(targetTransaction);
            switch (targetTransaction.getTransactionType()) {
                case GET_SETTLED_BATCH_LIST: {
                    super.importBatchSettledInformation(targetTransaction);
                    break;
                }
                case GET_TRANSACTION_LIST: {
                    super.importTransactionList(targetTransaction);
                    break;
                }
                case GET_TRANSACTION_DETAILS: {
                    super.importTransactionDetails(targetTransaction);
                    break;
                }
                case GET_BATCH_STATISTICS: {
                    super.importBatchSettledInformation(targetTransaction);
                    break;
                }
                case GET_UNSETTLED_TRANSACTION_LIST: {
                    super.importTransactionList(targetTransaction);
                    break;
                }
            }
            result.target = targetTransaction;
        }
        return result;
    }

    private void importBatchSettledInformation(Transaction txn) {
        this.reportingDetails = txn.getReportingDetails();
        NodeList batchlist_list = txn.getCurrentResponse().getDocument().getElementsByTagName(AuthNetField.ELEMENT_BATCH.getFieldName());
        if (batchlist_list.getLength() != 0) {
            for (int i = 0; i < batchlist_list.getLength(); ++i) {
                Element batch_el = (Element)batchlist_list.item(i);
                BatchDetails batchDetail = BatchDetails.createBatchDetail();
                batchDetail.setBatchId(Result.getElementText(batch_el, AuthNetField.ELEMENT_BATCH_ID.getFieldName()));
                batchDetail.setSettlementTimeLocal(Result.getElementText(batch_el, AuthNetField.ELEMENT_SETTLEMENT_TIME_LOCAL.getFieldName()));
                batchDetail.setSettlementTimeUTC(Result.getElementText(batch_el, AuthNetField.ELEMENT_SETTLEMENT_TIME_UTC.getFieldName()));
                batchDetail.setSettlementState(SettlementStateType.fromValue(Result.getElementText(batch_el, AuthNetField.ELEMENT_SETTLEMENT_STATE.getFieldName())));
                batchDetail.setPaymentMethod(Result.getElementText(batch_el, AuthNetField.ELEMENT_PAYMENT_METHOD.getFieldName()));
                batchDetail.setMarketType(Result.getElementText(batch_el, AuthNetField.ELEMENT_MARKET_TYPE.getFieldName()));
                batchDetail.setProduct(Result.getElementText(batch_el, AuthNetField.ELEMENT_PRODUCT.getFieldName()));
                NodeList statistics_list = batch_el.getElementsByTagName(AuthNetField.ELEMENT_STATISTIC.getFieldName());
                for (int j = 0; j < statistics_list.getLength(); ++j) {
                    BatchStatistics batchStats = BatchStatistics.createBatchStatistics();
                    Element statistic_el = (Element)statistics_list.item(j);
                    batchStats.setAccountType(CardType.findByValue(Result.getElementText(statistic_el, AuthNetField.ELEMENT_ACCOUNT_TYPE.getFieldName())));
                    batchStats.setChargeAmount(Result.getElementText(statistic_el, AuthNetField.ELEMENT_CHARGE_AMOUNT.getFieldName()));
                    batchStats.setChargeCount(Result.getElementText(statistic_el, AuthNetField.ELEMENT_CHARGE_COUNT.getFieldName()));
                    batchStats.setRefundAmount(Result.getElementText(statistic_el, AuthNetField.ELEMENT_REFUND_AMOUNT.getFieldName()));
                    batchStats.setRefundCount(Result.getElementText(statistic_el, AuthNetField.ELEMENT_REFUND_COUNT.getFieldName()));
                    batchStats.setVoidCount(Result.getElementText(statistic_el, AuthNetField.ELEMENT_VOID_COUNT.getFieldName()));
                    batchStats.setDeclineCount(Result.getElementText(statistic_el, AuthNetField.ELEMENT_DECLINE_COUNT.getFieldName()));
                    batchStats.setErrorCount(Result.getElementText(statistic_el, AuthNetField.ELEMENT_ERROR_COUNT.getFieldName()));
                    batchStats.setReturnedItemAmount(Result.getElementText(statistic_el, AuthNetField.ELEMENT_RETURNED_ITEM_AMOUNT.getFieldName()));
                    batchStats.setReturnedItemCount(Result.getElementText(statistic_el, AuthNetField.ELEMENT_RETURNED_ITEM_COUNT.getFieldName()));
                    batchStats.setChargebackAmount(Result.getElementText(statistic_el, AuthNetField.ELEMENT_CHARGEBACK_AMOUNT.getFieldName()));
                    batchStats.setChargebackCount(Result.getElementText(statistic_el, AuthNetField.ELEMENT_CHARGEBACK_COUNT.getFieldName()));
                    batchStats.setCorrectionNoticeCount(Result.getElementText(statistic_el, AuthNetField.ELEMENT_CORRECTION_NOTICE_COUNT.getFieldName()));
                    batchStats.setChargeChargebackAmount(Result.getElementText(statistic_el, AuthNetField.ELEMENT_CHARGE_CHARGEBACK_AMOUNT.getFieldName()));
                    batchStats.setChargeChargebackCount(Result.getElementText(statistic_el, AuthNetField.ELEMENT_CHARGE_CHARGEBACK_COUNT.getFieldName()));
                    batchStats.setRefundChargebackAmount(Result.getElementText(statistic_el, AuthNetField.ELEMENT_REFUND_CHARGEBACK_AMOUNT.getFieldName()));
                    batchStats.setRefundChargebackCount(Result.getElementText(statistic_el, AuthNetField.ELEMENT_REFUND_CHARGEBACK_COUNT.getFieldName()));
                    batchStats.setChargeReturnedItemsAmount(Result.getElementText(statistic_el, AuthNetField.ELEMENT_CHARGE_RETURNED_ITEMS_AMOUNT.getFieldName()));
                    batchStats.setChargeReturnedItemsCount(Result.getElementText(statistic_el, AuthNetField.ELEMENT_CHARGE_RETURNED_ITEMS_COUNT.getFieldName()));
                    batchStats.setRefundReturnedItemsAmount(Result.getElementText(statistic_el, AuthNetField.ELEMENT_REFUND_RETURNED_ITEMS_AMOUNT.getFieldName()));
                    batchStats.setRefundReturnedItemsCount(Result.getElementText(statistic_el, AuthNetField.ELEMENT_REFUND_RETURNED_ITEMS_COUNT.getFieldName()));
                    batchDetail.addBatchStatistics(batchStats);
                }
                this.reportingDetails.getBatchDetailsList().add(batchDetail);
            }
        }
    }

    private void importTransactionList(Transaction txn) {
        this.reportingDetails = txn.getReportingDetails();
        NodeList transactions_list = txn.getCurrentResponse().getDocument().getElementsByTagName(AuthNetField.ELEMENT_TRANSACTION.getFieldName());
        if (transactions_list.getLength() != 0) {
            ArrayList<TransactionDetails> transactionDetailList = new ArrayList<TransactionDetails>();
            for (int i = 0; i < transactions_list.getLength(); ++i) {
                Element transaction_el = (Element)transactions_list.item(i);
                TransactionDetails transactionDetails = TransactionDetails.createTransactionDetails();
                transactionDetails.setTransId(Result.getElementText(transaction_el, AuthNetField.ELEMENT_TRANS_ID.getFieldName()));
                transactionDetails.setSubmitTimeLocal(Result.getElementText(transaction_el, AuthNetField.ELEMENT_SUBMIT_TIME_LOCAL.getFieldName()));
                transactionDetails.setSubmitTimeUTC(Result.getElementText(transaction_el, AuthNetField.ELEMENT_SUBMIT_TIME_UTC.getFieldName()));
                transactionDetails.setTransactionStatus(TransactionStatusType.fromValue(Result.getElementText(transaction_el, AuthNetField.ELEMENT_TRANSACTION_STATUS.getFieldName())));
                transactionDetails.setInvoiceNumber(Result.getElementText(transaction_el, AuthNetField.ELEMENT_INVOICE_NUMBER.getFieldName()));
                transactionDetails.setFirstName(Result.getElementText(transaction_el, AuthNetField.ELEMENT_FIRST_NAME.getFieldName()));
                transactionDetails.setLastName(Result.getElementText(transaction_el, AuthNetField.ELEMENT_LAST_NAME.getFieldName()));
                transactionDetails.setAccountType(CardType.findByValue(Result.getElementText(transaction_el, AuthNetField.ELEMENT_ACCOUNT_TYPE.getFieldName())));
                transactionDetails.setAccountNumber(Result.getElementText(transaction_el, AuthNetField.ELEMENT_ACCOUNT_NUMBER.getFieldName()));
                transactionDetails.setSettleAmount(Result.getElementText(transaction_el, AuthNetField.ELEMENT_SETTLE_AMOUNT.getFieldName()));
                this.importSubscription(transaction_el, transactionDetails);
                transactionDetails.setHasReturnedItems(Result.getElementText(transaction_el, AuthNetField.ELEMENT_HAS_RETURNED_ITEMS.getFieldName()));
                transactionDetailList.add(transactionDetails);
            }
            this.reportingDetails.setTransactionDetailList(transactionDetailList);
        }
    }

    private void importTransactionDetails(Transaction txn) {
        NodeList duty_list;
        NodeList shipping_list;
        this.reportingDetails = txn.getReportingDetails();
        NodeList transactions_list = txn.getCurrentResponse().getDocument().getElementsByTagName(AuthNetField.ELEMENT_TRANSACTION.getFieldName());
        if (transactions_list.getLength() == 0) {
            return;
        }
        Element transaction_el = (Element)transactions_list.item(0);
        TransactionDetails transactionDetails = TransactionDetails.createTransactionDetails();
        transactionDetails.setTransId(Result.getElementText(transaction_el, AuthNetField.ELEMENT_TRANS_ID.getFieldName()));
        transactionDetails.setRefTransId(Result.getElementText(transaction_el, AuthNetField.ELEMENT_REF_TRANS_ID.getFieldName()));
        transactionDetails.setSplitTenderId(Result.getElementText(transaction_el, AuthNetField.ELEMENT_SPLIT_TENDER_ID.getFieldName()));
        transactionDetails.setSubmitTimeLocal(Result.getElementText(transaction_el, AuthNetField.ELEMENT_SUBMIT_TIME_LOCAL.getFieldName()));
        transactionDetails.setSubmitTimeUTC(Result.getElementText(transaction_el, AuthNetField.ELEMENT_SUBMIT_TIME_UTC.getFieldName()));
        transactionDetails.setTransactionType(ReportingTransactionType.fromValue(Result.getElementText(transaction_el, AuthNetField.ELEMENT_TRANSACTION_TYPE.getFieldName())));
        transactionDetails.setTransactionStatus(TransactionStatusType.fromValue(Result.getElementText(transaction_el, AuthNetField.ELEMENT_TRANSACTION_STATUS.getFieldName())));
        transactionDetails.setResponseCode(ResponseCode.findByResponseCode(Result.getElementText(transaction_el, AuthNetField.ELEMENT_RESPONSE_CODE.getFieldName())));
        ResponseReasonCode responseReasonCode = ResponseReasonCode.findByReasonCode(Result.getElementText(transaction_el, AuthNetField.ELEMENT_RESPONSE_REASON_CODE.getFieldName()));
        responseReasonCode.setReasonText(Result.getElementText(transaction_el, AuthNetField.ELEMENT_RESPONSE_REASON_DESCRIPTION.getFieldName()));
        transactionDetails.setResponseReasonCode(responseReasonCode);
        transactionDetails.setAuthCode(Result.getElementText(transaction_el, AuthNetField.ELEMENT_AUTH_CODE.getFieldName()));
        transactionDetails.setAvsResponse(AVSCode.findByValue(Result.getElementText(transaction_el, AuthNetField.ELEMENT__AVS_RESPONSE.getFieldName())));
        transactionDetails.setCardCodeResponse(CardCodeResponseType.findByValue(Result.getElementText(transaction_el, AuthNetField.ELEMENT_CARD_CODE_RESPONSE.getFieldName())));
        transactionDetails.setCAVVResponse(CAVVResponseType.findByValue(Result.getElementText(transaction_el, AuthNetField.ELEMENT__CAVV_RESPONSE.getFieldName())));
        transactionDetails.setFDSFilterAction(FDSFilterActionType.findByValue(Result.getElementText(transaction_el, AuthNetField.ELEMENT__FDS_FILTER_ACTION.getFieldName())));
        NodeList FDSFilters_list = transaction_el.getElementsByTagName(AuthNetField.ELEMENT__FDS_FILTER.getFieldName());
        for (int i = 0; i < FDSFilters_list.getLength(); ++i) {
            Element FDSFilter_el = (Element)FDSFilters_list.item(i);
            FDSFilter fdsFilter = FDSFilter.createFDSFilter();
            fdsFilter.setName(Result.getElementText(FDSFilter_el, AuthNetField.ELEMENT_NAME.getFieldName()));
            fdsFilter.setAction(FDSFilterActionType.findByValue(Result.getElementText(FDSFilter_el, AuthNetField.ELEMENT_ACTION.getFieldName())));
            transactionDetails.getFDSFilterList().add(fdsFilter);
        }
        NodeList batch_list = transaction_el.getElementsByTagName(AuthNetField.ELEMENT_BATCH.getFieldName());
        if (batch_list != null && batch_list.getLength() == 1) {
            Element batch_el = (Element)batch_list.item(0);
            BatchDetails batchDetail = BatchDetails.createBatchDetail();
            batchDetail.setBatchId(Result.getElementText(batch_el, AuthNetField.ELEMENT_BATCH_ID.getFieldName()));
            batchDetail.setSettlementTimeLocal(Result.getElementText(batch_el, AuthNetField.ELEMENT_SETTLEMENT_TIME_LOCAL.getFieldName()));
            batchDetail.setSettlementTimeUTC(Result.getElementText(batch_el, AuthNetField.ELEMENT_SETTLEMENT_TIME_UTC.getFieldName()));
            batchDetail.setSettlementState(SettlementStateType.fromValue(Result.getElementText(batch_el, AuthNetField.ELEMENT_SETTLEMENT_STATE.getFieldName())));
            batchDetail.setMarketType(Result.getElementText(batch_el, AuthNetField.ELEMENT_MARKET_TYPE.getFieldName()));
            batchDetail.setProduct(Result.getElementText(batch_el, AuthNetField.ELEMENT_PRODUCT.getFieldName()));
            transactionDetails.setBatch(batchDetail);
        }
        Order order = Order.createOrder();
        NodeList order_list = transaction_el.getElementsByTagName(AuthNetField.ELEMENT_ORDER.getFieldName());
        if (order_list != null && order_list.getLength() == 1) {
            Element order_el = (Element)order_list.item(0);
            order.setInvoiceNumber(Result.getElementText(order_el, AuthNetField.ELEMENT_INVOICE_NUMBER.getFieldName()));
            transactionDetails.setInvoiceNumber(order.getInvoiceNumber());
            order.setDescription(Result.getElementText(order_el, AuthNetField.ELEMENT_DESCRIPTION.getFieldName()));
            order.setPurchaseOrderNumber(Result.getElementText(order_el, AuthNetField.ELEMENT_PURCHASE_ORDER_NUMBER.getFieldName()));
        }
        transactionDetails.setRequestedAmount(Result.getElementText(transaction_el, AuthNetField.ELEMENT_REQUESTED_AMOUNT.getFieldName()));
        transactionDetails.setAuthAmount(Result.getElementText(transaction_el, AuthNetField.ELEMENT_AUTH_AMOUNT.getFieldName()));
        order.setTotalAmount(transactionDetails.getAuthAmount());
        transactionDetails.setSettleAmount(Result.getElementText(transaction_el, AuthNetField.ELEMENT_SETTLE_AMOUNT.getFieldName()));
        ShippingCharges shippingCharges = ShippingCharges.createShippingCharges();
        NodeList tax_list = transaction_el.getElementsByTagName(AuthNetField.ELEMENT_TAX.getFieldName());
        if (tax_list != null && tax_list.getLength() == 1) {
            Element tax_el = (Element)tax_list.item(0);
            shippingCharges.setTaxAmount(Result.getElementText(tax_el, AuthNetField.ELEMENT_AMOUNT.getFieldName()));
            shippingCharges.setTaxItemName(Result.getElementText(tax_el, AuthNetField.ELEMENT_NAME.getFieldName()));
            shippingCharges.setTaxDescription(Result.getElementText(tax_el, AuthNetField.ELEMENT_DESCRIPTION.getFieldName()));
        }
        if ((shipping_list = transaction_el.getElementsByTagName(AuthNetField.ELEMENT_SHIPPING.getFieldName())) != null && shipping_list.getLength() == 1) {
            Element shipping_el = (Element)shipping_list.item(0);
            shippingCharges.setFreightAmount(Result.getElementText(shipping_el, AuthNetField.ELEMENT_AMOUNT.getFieldName()));
            shippingCharges.setFreightItemName(Result.getElementText(shipping_el, AuthNetField.ELEMENT_NAME.getFieldName()));
            shippingCharges.setFreightDescription(Result.getElementText(shipping_el, AuthNetField.ELEMENT_DESCRIPTION.getFieldName()));
        }
        if ((duty_list = transaction_el.getElementsByTagName(AuthNetField.ELEMENT_DUTY.getFieldName())) != null && duty_list.getLength() == 1) {
            Element duty_el = (Element)duty_list.item(0);
            shippingCharges.setDutyAmount(Result.getElementText(duty_el, AuthNetField.ELEMENT_AMOUNT.getFieldName()));
            shippingCharges.setDutyItemName(Result.getElementText(duty_el, AuthNetField.ELEMENT_NAME.getFieldName()));
            shippingCharges.setDutyItemDescription(Result.getElementText(duty_el, AuthNetField.ELEMENT_DESCRIPTION.getFieldName()));
        }
        order.setShippingCharges(shippingCharges);
        ArrayList<OrderItem> orderItemList = new ArrayList<OrderItem>();
        NodeList orderitem_list = transaction_el.getElementsByTagName(AuthNetField.ELEMENT_LINE_ITEM.getFieldName());
        for (int i = 0; i < orderitem_list.getLength(); ++i) {
            Element orderitem_el = (Element)orderitem_list.item(i);
            OrderItem orderItem = OrderItem.createOrderItem();
            orderItem.setItemId(Result.getElementText(orderitem_el, AuthNetField.ELEMENT_ITEM_ID.getFieldName()));
            orderItem.setItemName(Result.getElementText(orderitem_el, AuthNetField.ELEMENT_NAME.getFieldName()));
            orderItem.setItemDescription(Result.getElementText(orderitem_el, AuthNetField.ELEMENT_DESCRIPTION.getFieldName()));
            orderItem.setItemQuantity(Result.getElementText(orderitem_el, AuthNetField.ELEMENT_QUANTITY.getFieldName()));
            orderItem.setItemPrice(Result.getElementText(orderitem_el, AuthNetField.ELEMENT_UNIT_PRICE.getFieldName()));
            orderItem.setItemTaxable(Result.getElementText(orderitem_el, AuthNetField.ELEMENT_TAXABLE.getFieldName()));
            orderItemList.add(orderItem);
        }
        order.setOrderItems(orderItemList);
        transactionDetails.setOrder(order);
        transactionDetails.setPrepaidBalanceRemaining(Result.getElementText(transaction_el, AuthNetField.ELEMENT_PREPAID_BALANCE_REMAINING.getFieldName()));
        transactionDetails.setItemTaxExempt(Result.getElementText(transaction_el, AuthNetField.ELEMENT_TAX_EXEMPT.getFieldName()));
        NodeList payment_list = transaction_el.getElementsByTagName(AuthNetField.ELEMENT_PAYMENT.getFieldName());
        Payment payment = null;
        if (payment_list != null && payment_list.getLength() == 1) {
            NodeList bank_account_list;
            Element payment_el = (Element)payment_list.item(0);
            NodeList credit_card_list = payment_el.getElementsByTagName(AuthNetField.ELEMENT_CREDIT_CARD.getFieldName());
            if (credit_card_list != null && credit_card_list.getLength() == 1) {
                CreditCard creditCard = CreditCard.createCreditCard();
                Element credit_card_el = (Element)credit_card_list.item(0);
                creditCard.setMaskedCreditCardNumber(Result.getElementText(credit_card_el, AuthNetField.ELEMENT_CARD_NUMBER.getFieldName()));
                String dateStr = Result.getElementText(credit_card_el, AuthNetField.ELEMENT_EXPIRATION_DATE.getFieldName());
                if (StringUtils.isNotEmpty(dateStr) && !"XXXX".equals(dateStr)) {
                    creditCard.setExpirationDate(dateStr);
                }
                if (StringUtils.isNotEmpty(Result.getElementText(credit_card_el, AuthNetField.ELEMENT_ACCOUNT_TYPE.getFieldName()))) {
                    creditCard.setCardType(CardType.findByValue(Result.getElementText(credit_card_el, AuthNetField.ELEMENT_ACCOUNT_TYPE.getFieldName())));
                } else {
                    creditCard.setCardType(CardType.findByValue(Result.getElementText(credit_card_el, AuthNetField.ELEMENT_CARD_TYPE.getFieldName())));
                }
                payment = Payment.createPayment(creditCard);
            }
            if ((bank_account_list = payment_el.getElementsByTagName(AuthNetField.ELEMENT_BANK_ACCOUNT.getFieldName())) != null && bank_account_list.getLength() == 1) {
                BankAccount bankAccount = BankAccount.createBankAccount();
                Element bank_account_el = (Element)bank_account_list.item(0);
                bankAccount.setRoutingNumber(Result.getElementText(bank_account_el, AuthNetField.ELEMENT_ROUTING_NUMBER.getFieldName()));
                bankAccount.setBankAccountNumber(Result.getElementText(bank_account_el, AuthNetField.ELEMENT_ACCOUNT_NUMBER.getFieldName()));
                bankAccount.setBankAccountName(Result.getElementText(bank_account_el, AuthNetField.ELEMENT_NAME_ON_ACCOUNT.getFieldName()));
                bankAccount.setECheckType(ECheckType.findByValue(Result.getElementText(bank_account_el, AuthNetField.ELEMENT_ECHECK_TYPE.getFieldName())));
                payment = Payment.createPayment(bankAccount);
            }
            transactionDetails.setPayment(payment);
        }
        NodeList customer_list = transaction_el.getElementsByTagName(AuthNetField.ELEMENT_CUSTOMER.getFieldName());
        Customer customer = null;
        if (customer_list == null || customer_list.getLength() == 0) {
            customer = Customer.createCustomer();
        } else {
            Element customer_el = (Element)customer_list.item(0);
            customer = Customer.createCustomer();
            customer.setCustomerType(CustomerType.findByName(Result.getElementText(customer_el, AuthNetField.ELEMENT_TYPE.getFieldName())));
            customer.setId(Result.getElementText(customer_el, AuthNetField.ELEMENT_ID.getFieldName()));
            customer.setEmail(Result.getElementText(customer_el, AuthNetField.ELEMENT_EMAIL.getFieldName()));
        }
        Address billToAddress = null;
        NodeList bill_to_list = transaction_el.getElementsByTagName(AuthNetField.ELEMENT_BILL_TO.getFieldName());
        if (bill_to_list != null && bill_to_list.getLength() == 1) {
            Element address_el = (Element)bill_to_list.item(0);
            billToAddress = Address.createAddress();
            billToAddress.setFirstName(Result.getElementText(address_el, AuthNetField.ELEMENT_FIRST_NAME.getFieldName()));
            billToAddress.setLastName(Result.getElementText(address_el, AuthNetField.ELEMENT_LAST_NAME.getFieldName()));
            billToAddress.setCompany(Result.getElementText(address_el, AuthNetField.ELEMENT_COMPANY.getFieldName()));
            billToAddress.setAddress(Result.getElementText(address_el, AuthNetField.ELEMENT_ADDRESS.getFieldName()));
            billToAddress.setCity(Result.getElementText(address_el, AuthNetField.ELEMENT_CITY.getFieldName()));
            billToAddress.setState(Result.getElementText(address_el, AuthNetField.ELEMENT_STATE.getFieldName()));
            billToAddress.setZipPostalCode(Result.getElementText(address_el, AuthNetField.ELEMENT_ZIP.getFieldName()));
            billToAddress.setCountry(Result.getElementText(address_el, AuthNetField.ELEMENT_COUNTRY.getFieldName()));
            billToAddress.setPhoneNumber(Result.getElementText(address_el, AuthNetField.ELEMENT_PHONE_NUMBER.getFieldName()));
            billToAddress.setFaxNumber(Result.getElementText(address_el, AuthNetField.ELEMENT_FAX_NUMBER.getFieldName()));
            customer.setBillTo(billToAddress);
        }
        Address shipToAddress = null;
        NodeList ship_to_list = transaction_el.getElementsByTagName(AuthNetField.ELEMENT_SHIP_TO.getFieldName());
        if (ship_to_list != null && ship_to_list.getLength() == 1) {
            Element address_el = (Element)ship_to_list.item(0);
            shipToAddress = Address.createAddress();
            shipToAddress.setFirstName(Result.getElementText(address_el, AuthNetField.ELEMENT_FIRST_NAME.getFieldName()));
            shipToAddress.setLastName(Result.getElementText(address_el, AuthNetField.ELEMENT_LAST_NAME.getFieldName()));
            shipToAddress.setCompany(Result.getElementText(address_el, AuthNetField.ELEMENT_COMPANY.getFieldName()));
            shipToAddress.setAddress(Result.getElementText(address_el, AuthNetField.ELEMENT_ADDRESS.getFieldName()));
            shipToAddress.setCity(Result.getElementText(address_el, AuthNetField.ELEMENT_CITY.getFieldName()));
            shipToAddress.setState(Result.getElementText(address_el, AuthNetField.ELEMENT_STATE.getFieldName()));
            shipToAddress.setZipPostalCode(Result.getElementText(address_el, AuthNetField.ELEMENT_ZIP.getFieldName()));
            shipToAddress.setCountry(Result.getElementText(address_el, AuthNetField.ELEMENT_COUNTRY.getFieldName()));
            customer.setShipTo(shipToAddress);
        }
        transactionDetails.setCustomer(customer);
        transactionDetails.setRecurringBilling(Result.getElementText(transaction_el, AuthNetField.ELEMENT_RECURRING_BILLING.getFieldName()));
        transactionDetails.setCustomerIP(Result.getElementText(transaction_el, AuthNetField.ELEMENT_CUSTOMER_IP.getFieldName()));
        this.getReportingDetails().getTransactionDetailList().add(transactionDetails);
        this.importSubscription(transaction_el, transactionDetails);
        this.importReturnedItems(transaction_el, transactionDetails);
        this.importSolutionId(transaction_el, transactionDetails);
    }

    private void importSubscription(Element transaction_el, TransactionDetails transactionDetails) {
        NodeList subscription_nl = transaction_el.getElementsByTagName(AuthNetField.ELEMENT_SUBSCRIPTION.getFieldName());
        if (null != subscription_nl && 1 == subscription_nl.getLength()) {
            Element subscription_el = (Element)subscription_nl.item(0);
            Subscription subscription = Subscription.createSubscription();
            subscription.setId(Result.getElementText(subscription_el, AuthNetField.ELEMENT_ID.getFieldName()));
            subscription.setPayNum(Result.getElementText(subscription_el, AuthNetField.ELEMENT_PAYMENT_NUM.getFieldName()));
            transactionDetails.setSubscription(subscription);
        }
    }

    private void importReturnedItems(Element transaction_el, TransactionDetails transactionDetails) {
        ArrayList<ReturnedItem> returnedItems = new ArrayList<ReturnedItem>();
        NodeList returnedItems_list = transaction_el.getElementsByTagName(AuthNetField.ELEMENT_RETURNED_ITEMS.getFieldName());
        for (int j = 0; j < returnedItems_list.getLength(); ++j) {
            Element returnedItem_el = (Element)returnedItems_list.item(j);
            ReturnedItem returnedItem = ReturnedItem.createReturnedItem();
            returnedItem.setId(Result.getElementText(returnedItem_el, AuthNetField.ELEMENT_ID.getFieldName()));
            returnedItem.setDateUTC(Result.getElementText(returnedItem_el, AuthNetField.ELEMENT_RETURNED_ITEMS_DATE_UTC.getFieldName()));
            returnedItem.setDateLocal(Result.getElementText(returnedItem_el, AuthNetField.ELEMENT_RETURNED_ITEMS_DATE_LOCAL.getFieldName()));
            returnedItem.setCode(Result.getElementText(returnedItem_el, AuthNetField.ELEMENT_CODE.getFieldName()));
            returnedItem.setDescription(Result.getElementText(returnedItem_el, AuthNetField.ELEMENT_DESCRIPTION.getFieldName()));
            returnedItems.add(returnedItem);
        }
        if (returnedItems.size() > 0) {
            transactionDetails.setReturnedItems(returnedItems);
        }
    }

    private void importSolutionId(Element transaction_el, TransactionDetails transactionDetails) {
        NodeList solution_nl = transaction_el.getElementsByTagName(AuthNetField.ELEMENT_SOLUTION.getFieldName());
        if (null != solution_nl && 1 == solution_nl.getLength()) {
            Element solution_el = (Element)solution_nl.item(0);
            Solution solution = Solution.createSolution();
            solution.setId(Result.getElementText(solution_el, AuthNetField.ELEMENT_ID.getFieldName()));
            solution.setName(Result.getElementText(solution_el, AuthNetField.ELEMENT_NAME.getFieldName()));
            transactionDetails.setSolution(solution);
        }
    }

    private void importResponseMessages(Transaction txn) {
        NodeList messages_list = txn.getCurrentResponse().getDocument().getElementsByTagName(AuthNetField.ELEMENT_MESSAGES.getFieldName());
        if (messages_list.getLength() == 0) {
            return;
        }
        Element messages_el = (Element)messages_list.item(0);
        this.resultCode = Result.getElementText(messages_el, AuthNetField.ELEMENT_RESULT_CODE.getFieldName());
        NodeList message_list = messages_el.getElementsByTagName(AuthNetField.ELEMENT_MESSAGE.getFieldName());
        for (int i = 0; i < message_list.getLength(); ++i) {
            Element message_el = (Element)message_list.item(i);
            Message new_message = Message.createMessage();
            new_message.setCode(Result.getElementText(message_el, AuthNetField.ELEMENT_CODE.getFieldName()));
            new_message.setText(Result.getElementText(message_el, AuthNetField.ELEMENT_TEXT.getFieldName()));
            this.messages.add(new_message);
        }
    }

    private void importRefId(Transaction txn) {
        this.refId = Result.getElementText(txn.getCurrentResponse().getDocument().getDocumentElement(), AuthNetField.ELEMENT_REFID.getFieldName());
    }

    public String getRefId() {
        return this.refId;
    }

    public ReportingDetails getReportingDetails() {
        return this.reportingDetails;
    }

    @Override
    public void printMessages() {
        System.out.println("Result Code: " + (this.resultCode != null ? this.resultCode : "No result code"));
        for (Message message : this.messages) {
            System.out.println(message.getCode() + " - " + message.getText());
        }
    }
}

