/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.data.creditcard;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;
import net.authorize.data.creditcard.AVSCode;
import net.authorize.data.creditcard.CardType;
import net.authorize.util.DateUtil;
import net.authorize.util.Luhn;

@XmlRootElement
public class CreditCard
implements Serializable {
    public static final String MASKED_EXPIRY_DATE = "XXXX";
    private static final long serialVersionUID = 1L;
    public static String ARB_EXPIRY_DATE_FORMAT = "yyyy-MM";
    private static String EXPIRY_DATE_FORMAT = "MM/yyyy";
    private String creditCardNumber;
    private String expirationMonth;
    private String expirationYear;
    private Date expirationDate;
    private CardType cardType;
    private String cardCode;
    private String cardholderAuthenticationIndicator;
    private String cardholderAuthenticationValue;
    private AVSCode avsCode;
    private String track1;
    private String track2;
    private boolean cardPresent;

    protected CreditCard() {
    }

    public static CreditCard createCreditCard() {
        return new CreditCard();
    }

    public String getCreditCardNumber() {
        return this.creditCardNumber;
    }

    public void setCreditCardNumber(String creditCardNumber) {
        this.cardType = Luhn.getCardType(creditCardNumber);
        this.creditCardNumber = Luhn.stripNonDigits(creditCardNumber);
    }

    public void setMaskedCreditCardNumber(String maskedCreditCardNumber) {
        this.creditCardNumber = maskedCreditCardNumber;
    }

    public String getExpirationMonth() {
        return this.expirationMonth;
    }

    public void setExpirationMonth(String expirationMonth) {
        this.expirationMonth = expirationMonth;
        this.setExpirationDate();
    }

    public String getExpirationYear() {
        return this.expirationYear;
    }

    public void setExpirationYear(String expirationYear) {
        this.expirationYear = expirationYear;
        this.setExpirationDate();
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
        this.extractMonthYearFromExpiration();
    }

    public void setExpirationDate(String expiration_date) {
        this.expirationDate = DateUtil.getDateFromFormattedDate(expiration_date, ARB_EXPIRY_DATE_FORMAT);
        this.extractMonthYearFromExpiration();
    }

    private void setExpirationDate() {
        if (this.expirationMonth != null && this.expirationYear != null) {
            this.expirationDate = DateUtil.getDateFromFormattedDate(this.expirationMonth + "/" + this.expirationYear, EXPIRY_DATE_FORMAT);
        }
    }

    private void extractMonthYearFromExpiration() {
        if (this.expirationDate != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.expirationDate);
            this.expirationMonth = Integer.toString(cal.get(2) + 1);
            this.expirationYear = Integer.toString(cal.get(1));
        }
    }

    public CardType getCardType() {
        return this.cardType;
    }

    public void setCardType(CardType cardType) {
        this.cardType = cardType;
    }

    @Deprecated
    public String getCardCodeVerification() {
        return this.cardCode;
    }

    @Deprecated
    public void setCardCodeVerification(String cardCodeVerification) {
        this.cardCode = cardCodeVerification;
    }

    public String getCardCode() {
        return this.cardCode;
    }

    public void setCardCode(String cardCode) {
        this.cardCode = cardCode;
    }

    public String getCardholderAuthenticationIndicator() {
        return this.cardholderAuthenticationIndicator;
    }

    public void setCardholderAuthenticationIndicator(String cardholderAuthenticationIndicator) {
        this.cardholderAuthenticationIndicator = cardholderAuthenticationIndicator;
    }

    public String getCardholderAuthenticationValue() {
        return this.cardholderAuthenticationValue;
    }

    public void setCardholderAuthenticationValue(String cardholderAuthenticationValue) {
        this.cardholderAuthenticationValue = cardholderAuthenticationValue;
    }

    public AVSCode getAvsCode() {
        return this.avsCode;
    }

    public void setAvsCode(AVSCode avsCode) {
        this.avsCode = avsCode;
    }

    public String getTrack1() {
        return this.track1;
    }

    public void setTrack1(String track1) {
        this.track1 = track1;
        if (this.track1 != null) {
            this.track1 = this.track1.replaceAll("(^[%]|[?]$)", "");
        }
    }

    public String getTrack2() {
        return this.track2;
    }

    public void setTrack2(String track2) {
        this.track2 = track2;
        if (this.track2 != null) {
            this.track2 = this.track2.replaceAll("(^[;]|[?]$)", "");
        }
    }

    public boolean isCardPresent() {
        return this.cardPresent;
    }

    public void setCardPresent(boolean cardPresent) {
        this.cardPresent = cardPresent;
    }
}

