/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.authorize.Environment;
import net.authorize.ResponseField;
import net.authorize.Transaction;
import net.authorize.util.BasicXmlDocument;
import net.authorize.util.LogHelper;
import net.authorize.util.ResponseParser;
import net.authorize.util.XmlUtility;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClient {
    private static Log logger = LogFactory.getLog(HttpClient.class);
    public static final String ENCODING = "UTF-8";
    static boolean proxySet = false;
    static boolean UseProxy = Environment.getBooleanProperty("https.proxyUse");
    static String ProxyHost = Environment.getProperty("https.proxyHost");
    static int ProxyPort = Environment.getIntProperty("https.proxyPort");

    private static HttpPost createHttpPost(Environment env, Transaction transaction) throws Exception {
        HttpPost httpPost = null;
        if (transaction instanceof net.authorize.aim.Transaction || transaction instanceof net.authorize.sim.Transaction) {
            URI postUrl = transaction instanceof net.authorize.aim.Transaction && ((net.authorize.aim.Transaction)transaction).isCardPresent() ? new URI(env.getCardPresentUrl() + "/gateway/transact.dll") : new URI(env.getBaseUrl() + "/gateway/transact.dll");
            httpPost = new HttpPost(postUrl);
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            httpPost.setEntity((HttpEntity)new StringEntity(transaction.toNVPString()));
        } else if (transaction instanceof net.authorize.arb.Transaction || transaction instanceof net.authorize.cim.Transaction || transaction instanceof net.authorize.reporting.Transaction) {
            URI postUrl = new URI(env.getXmlBaseUrl() + "/xml/v1/request.api");
            httpPost = new HttpPost(postUrl);
            httpPost.setHeader("Content-Type", "text/xml; charset=utf-8");
            httpPost.setEntity((HttpEntity)new StringEntity(transaction.toXMLString()));
        }
        return httpPost;
    }

    private static Map<ResponseField, String> createResponseMap(Transaction transaction, String responseString) throws UnsupportedEncodingException {
        Map<ResponseField, String> responseMap = null;
        if (transaction instanceof net.authorize.aim.Transaction || transaction instanceof net.authorize.sim.Transaction) {
            String decodedResponseData = URLDecoder.decode(responseString, ENCODING);
            responseMap = ResponseParser.parseResponseString(decodedResponseData);
        }
        return responseMap;
    }

    public static Map<ResponseField, String> execute(Environment environment, Transaction transaction) {
        Map<ResponseField, String> responseMap = new HashMap<ResponseField, String>();
        if (environment != null && transaction != null) {
            try {
                String rawResponseString;
                DefaultHttpClient httpClient = new DefaultHttpClient();
                HttpClient.setProxyIfRequested(httpClient);
                HttpPost httpPost = HttpClient.createHttpPost(environment, transaction);
                HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
                if (httpResponse != null && httpResponse.getStatusLine().getStatusCode() == 200) {
                    HttpEntity entity = httpResponse.getEntity();
                    InputStream instream = entity.getContent();
                    rawResponseString = HttpClient.convertStreamToString(instream);
                } else {
                    StringBuilder responseBuilder = new StringBuilder();
                    responseBuilder.append(3).append(net.authorize.aim.Transaction.TRANSACTION_FIELD_DELIMITER);
                    responseBuilder.append(3).append(net.authorize.aim.Transaction.TRANSACTION_FIELD_DELIMITER);
                    responseBuilder.append(22).append(net.authorize.aim.Transaction.TRANSACTION_FIELD_DELIMITER);
                    responseBuilder.append(httpResponse != null ? httpResponse.getStatusLine().getReasonPhrase() : " ");
                    rawResponseString = responseBuilder.toString();
                }
                httpClient.getConnectionManager().shutdown();
                String cleanResponseString = XmlUtility.descapeStringForXml(rawResponseString);
                responseMap = HttpClient.createResponseMap(transaction, cleanResponseString);
            }
            catch (Exception e) {
                LogHelper.warn(logger, "Exception getting response: '%s': '%s', '%s'", e.getMessage(), e.getCause(), Arrays.toString(e.getStackTrace()));
            }
        }
        return responseMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String convertStreamToString(InputStream is) {
        StringBuilder sb;
        block23: {
            BufferedReader reader;
            block21: {
                String line;
                reader = new BufferedReader(new InputStreamReader(is));
                sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                if (null == reader) break block21;
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LogHelper.warn(logger, "Exception closing BufferedReader: '%s'", e.getMessage());
                }
            }
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LogHelper.warn(logger, "Exception closing InputStream: '%s'", e.getMessage());
                }
            }
            break block23;
            catch (IOException e) {
                block22: {
                    try {
                        LogHelper.warn(logger, "Exception reading data from Stream: '%s'", e.getMessage());
                        if (null == reader) break block22;
                    }
                    catch (Throwable throwable) {
                        if (null != reader) {
                            try {
                                reader.close();
                            }
                            catch (IOException e2) {
                                LogHelper.warn(logger, "Exception closing BufferedReader: '%s'", e2.getMessage());
                            }
                        }
                        if (null != is) {
                            try {
                                is.close();
                            }
                            catch (IOException e3) {
                                LogHelper.warn(logger, "Exception closing InputStream: '%s'", e3.getMessage());
                            }
                        }
                        throw throwable;
                    }
                    try {
                        reader.close();
                    }
                    catch (IOException e4) {
                        LogHelper.warn(logger, "Exception closing BufferedReader: '%s'", e4.getMessage());
                    }
                }
                if (null != is) {
                    try {
                        is.close();
                    }
                    catch (IOException e5) {
                        LogHelper.warn(logger, "Exception closing InputStream: '%s'", e5.getMessage());
                    }
                }
            }
        }
        return sb.toString();
    }

    public static BasicXmlDocument executeXML(Environment environment, Transaction transaction) {
        BasicXmlDocument response = new BasicXmlDocument();
        if (environment != null && transaction != null) {
            try {
                int mark;
                String rawResponseString;
                DefaultHttpClient httpClient = new DefaultHttpClient();
                HttpClient.setProxyIfRequested(httpClient);
                HttpPost httpPost = HttpClient.createHttpPost(environment, transaction);
                HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
                if (httpResponse != null && httpResponse.getStatusLine().getStatusCode() == 200) {
                    HttpEntity entity = httpResponse.getEntity();
                    InputStream instream = entity.getContent();
                    rawResponseString = HttpClient.convertStreamToString(instream);
                } else {
                    StringBuilder responseBuilder = new StringBuilder();
                    if (transaction instanceof net.authorize.arb.Transaction || transaction instanceof net.authorize.cim.Transaction || transaction instanceof net.authorize.reporting.Transaction) {
                        responseBuilder.append("<?xml version=\"1.0\" ?>");
                        responseBuilder.append("<messages><resultCode>Error</resultCode>");
                        responseBuilder.append("<message><code>E00001</code>");
                        responseBuilder.append("<text>");
                        responseBuilder.append(httpResponse != null ? httpResponse.getStatusLine().getReasonPhrase() : "");
                        responseBuilder.append("</text></message></messages>");
                    } else {
                        responseBuilder.append("<?xml version=\"1.0\" ?>");
                        responseBuilder.append("<response>");
                        responseBuilder.append("<ResponseCode>3</ResponseCode>");
                        responseBuilder.append("<Errors><Error><ErrorCode>22</ErrorCode><ErrorText><![CDATA[");
                        responseBuilder.append(httpResponse != null ? httpResponse.getStatusLine().getReasonPhrase() : "");
                        responseBuilder.append("]]></ErrorText></Error></Errors></response>");
                    }
                    rawResponseString = responseBuilder.toString();
                }
                httpClient.getConnectionManager().shutdown();
                if (rawResponseString == null) {
                    return null;
                }
                if (Environment.SANDBOX.equals((Object)environment) || Environment.SANDBOX_TESTMODE.equals((Object)environment)) {
                    // empty if block
                }
                if ((mark = rawResponseString.indexOf("<?xml")) == -1) {
                    return null;
                }
                response.parseString(rawResponseString.substring(mark, rawResponseString.length()));
                if (!response.IsAccessible()) {
                    return null;
                }
            }
            catch (Exception e) {
                LogHelper.warn(logger, "Exception getting response: '%s': '%s', '%s'", e.getMessage(), e.getCause(), Arrays.toString(e.getStackTrace()));
            }
        }
        return response;
    }

    public static void setProxyIfRequested(DefaultHttpClient httpClient) {
        if (UseProxy) {
            if (!proxySet) {
                LogHelper.info(logger, "Setting up proxy to URL: '%s://%s:%d'", "http", ProxyHost, ProxyPort);
                proxySet = true;
            }
            HttpHost proxyHttpHost = new HttpHost(ProxyHost, ProxyPort, "http");
            httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxyHttpHost);
        }
    }

    static {
        LogHelper.info(logger, "Use Proxy: '%s'", UseProxy);
    }
}

