/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.util;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import net.authorize.util.LogHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlUtility {
    private static Log logger = LogFactory.getLog(XmlUtility.class);
    private static final String XmlHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>";

    private XmlUtility() {
    }

    public static <T extends Serializable> String getXml(T entity) throws IOException, JAXBException {
        StringWriter sw = new StringWriter();
        if (null != entity) {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{entity.getClass()});
            Marshaller m = ctx.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.marshal(entity, (Writer)sw);
        }
        sw.flush();
        sw.close();
        return sw.toString();
    }

    public static <T extends Serializable> T create(String xml, Class<T> classType) throws JAXBException {
        Serializable entity;
        block3: {
            JAXBContext ctx;
            Unmarshaller um;
            Object unmarshaled;
            entity = null;
            if (null != xml && !xml.trim().isEmpty() && null != (unmarshaled = (um = (ctx = JAXBContext.newInstance((Class[])new Class[]{classType})).createUnmarshaller()).unmarshal((Reader)new StringReader(xml)))) {
                try {
                    entity = (Serializable)classType.cast(unmarshaled);
                }
                catch (ClassCastException cce) {
                    JAXBElement element;
                    if (!(unmarshaled instanceof JAXBElement) || null == (element = (JAXBElement)unmarshaled).getValue() || element.getValue().getClass() != classType) break block3;
                    entity = (Serializable)element.getValue();
                }
            }
        }
        return (T)entity;
    }

    public static String escapeStringForXml(String valueToSerialize) {
        String retVal = valueToSerialize;
        if (null != valueToSerialize && valueToSerialize.length() > 0) {
            try {
                XmlString value = new XmlString(valueToSerialize);
                String xmlString = XmlUtility.getXml(value);
                int begin = xmlString.indexOf("<xmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue>") + "<xmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue>".length();
                int end = xmlString.indexOf("</xmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue>");
                if (begin >= 0 && end >= 0) {
                    retVal = xmlString.substring(begin, end);
                }
            }
            catch (Exception e) {
                LogHelper.warn(logger, "Error encoding to XML, value: '%s', ErrorMessage: '%s'", valueToSerialize, e.getMessage());
                retVal = valueToSerialize;
            }
        }
        return retVal;
    }

    public static String descapeStringForXml(String valueToDeserialize) {
        String retVal = valueToDeserialize;
        if (null != valueToDeserialize && valueToDeserialize.length() > 0) {
            try {
                StringBuilder value = new StringBuilder();
                value.append("<xmlString>").append("<xmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue>");
                value.append(valueToDeserialize);
                value.append("</xmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue>").append("</xmlString>");
                XmlString xmlString = XmlUtility.create(value.toString(), XmlString.class);
                if (null != xmlString) {
                    retVal = xmlString.getXmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue();
                }
            }
            catch (Exception e) {
                LogHelper.warn(logger, "Error decoding from XML, value: '%s', ErrorMessage: '%s'", valueToDeserialize, e.getMessage());
                retVal = valueToDeserialize;
            }
        }
        return retVal;
    }

    public static <T extends Serializable> String getRootElementXml(T entity) {
        String rootElementXml;
        try {
            String xml = XmlUtility.getXml(entity);
            rootElementXml = XmlUtility.getRootElementXml(xml);
        }
        catch (Exception e) {
            LogHelper.warn(logger, "Unable to serialize into xml: '%s'", entity);
            rootElementXml = String.format("<%s/>", entity.getClass().getSimpleName());
        }
        return rootElementXml;
    }

    public static String getRootElementXml(String xmlString) {
        return xmlString.replace(XmlHeader, "");
    }

    @XmlRootElement
    static class XmlString
    implements Serializable {
        public static final String VALUE_BEGIN = "<xmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue>";
        public static final String VALUE_END = "</xmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue>";
        public static final String CLASS_BEGIN = "<xmlString>";
        public static final String CLASS_END = "</xmlString>";
        private static final long serialVersionUID = 1L;
        String xmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue = null;

        XmlString() {
        }

        XmlString(String value) {
            this.setXmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue(value);
        }

        public String getXmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue() {
            return this.xmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue;
        }

        public void setXmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue(String value) {
            this.xmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue = value;
        }

        public String toString() {
            return this.xmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue;
        }
    }
}

