/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.data.xml.reporting;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import net.authorize.ResponseCode;
import net.authorize.ResponseReasonCode;
import net.authorize.data.Order;
import net.authorize.data.creditcard.AVSCode;
import net.authorize.data.creditcard.CardType;
import net.authorize.data.reporting.ReturnedItem;
import net.authorize.data.reporting.Solution;
import net.authorize.data.reporting.Subscription;
import net.authorize.data.xml.Customer;
import net.authorize.data.xml.Payment;
import net.authorize.data.xml.reporting.BatchDetails;
import net.authorize.data.xml.reporting.CAVVResponseType;
import net.authorize.data.xml.reporting.CardCodeResponseType;
import net.authorize.data.xml.reporting.FDSFilter;
import net.authorize.data.xml.reporting.FDSFilterActionType;
import net.authorize.data.xml.reporting.ReportingDetails;
import net.authorize.data.xml.reporting.ReportingTransactionType;
import net.authorize.data.xml.reporting.TransactionStatusType;
import net.authorize.util.DateUtil;
import net.authorize.util.LogHelper;
import net.authorize.util.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionDetails {
    private static Log logger = LogFactory.getLog(TransactionDetails.class);
    private String transId;
    private String refTransId;
    private String splitTenderId;
    private Date submitTimeUTC;
    private Date submitTimeLocal;
    private ReportingTransactionType transactionType;
    private TransactionStatusType transactionStatus;
    private ResponseCode responseCode;
    private ResponseReasonCode responseReasonCode;
    private String authCode;
    private AVSCode avsResponse;
    private CardCodeResponseType cardCodeResponse;
    private CAVVResponseType CAVVResponse;
    private FDSFilterActionType FDSFilterAction;
    private ArrayList<FDSFilter> FDSFilterList = new ArrayList();
    private BatchDetails batch;
    private Order order;
    private BigDecimal prepaidBalanceRemaining = null;
    private boolean itemTaxExempt;
    private Subscription subscription = null;
    private BigDecimal requestedAmount;
    private BigDecimal authAmount;
    private BigDecimal settleAmount;
    private Payment payment;
    private Customer customer;
    private boolean recurringBilling;
    private String customerIP;
    private String invoiceNumber;
    private String firstName;
    private String lastName;
    private CardType accountType;
    private String accountNumber;
    private boolean hasReturnedItems;
    private ArrayList<ReturnedItem> returnedItems = null;
    private Solution solution = null;
    private boolean fullTransactionDetails = false;

    private TransactionDetails() {
    }

    public static TransactionDetails createTransactionDetails() {
        return new TransactionDetails();
    }

    public String getTransId() {
        return this.transId;
    }

    public void setTransId(String transId) {
        this.transId = transId;
    }

    public Date getSubmitTimeUTC() {
        return this.submitTimeUTC;
    }

    public void setSubmitTimeUTC(Date submitTimeUTC) {
        this.submitTimeUTC = submitTimeUTC;
    }

    public void setSubmitTimeUTC(String submitTimeUTC) {
        if (StringUtils.isNotEmpty(submitTimeUTC)) {
            this.submitTimeUTC = DateUtil.getDateFromFormattedDate(submitTimeUTC, this.fullTransactionDetails ? ReportingDetails.DATE_FORMAT_FULL : ReportingDetails.DATE_FORMAT);
        }
    }

    public Date getSubmitTimeLocal() {
        return this.submitTimeLocal;
    }

    public void setSubmitTimeLocal(Date submitTimeLocal) {
        this.submitTimeLocal = submitTimeLocal;
    }

    public void setSubmitTimeLocal(String submitTimeLocal) {
        if (StringUtils.isNotEmpty(submitTimeLocal)) {
            this.submitTimeLocal = DateUtil.getDateFromFormattedDate(submitTimeLocal, this.fullTransactionDetails ? ReportingDetails.DATE_FORMAT_FULL : ReportingDetails.DATE_FORMAT);
        }
    }

    public TransactionStatusType getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(TransactionStatusType transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public void setTransactionStatus(String transactionStatus) {
        if (StringUtils.isNotEmpty(transactionStatus)) {
            this.transactionStatus = TransactionStatusType.fromValue(transactionStatus);
        }
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public CardType getAccountType() {
        return this.accountType;
    }

    public void setAccountType(CardType accountType) {
        this.accountType = accountType;
    }

    public void setAccountType(String accountType) {
        if (StringUtils.isNotEmpty(accountType)) {
            this.accountType = CardType.findByValue(accountType);
        }
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    @Deprecated
    public boolean isFullTransactionDetails() {
        return this.fullTransactionDetails;
    }

    public void setFullTransactionDetails(boolean fullTransactionDetails) {
        this.fullTransactionDetails = fullTransactionDetails;
    }

    public String getRefTransId() {
        return this.refTransId;
    }

    public void setRefTransId(String refTransId) {
        this.refTransId = refTransId;
    }

    public String getSplitTenderId() {
        return this.splitTenderId;
    }

    public void setSplitTenderId(String splitTenderId) {
        this.splitTenderId = splitTenderId;
    }

    public ReportingTransactionType getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(ReportingTransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public ResponseCode getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(ResponseCode responseCode) {
        this.responseCode = responseCode;
    }

    public ResponseReasonCode getResponseReasonCode() {
        return this.responseReasonCode;
    }

    public void setResponseReasonCode(ResponseReasonCode responseReasonCode) {
        this.responseReasonCode = responseReasonCode;
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public AVSCode getAvsResponse() {
        return this.avsResponse;
    }

    public void setAvsResponse(AVSCode avsResponse) {
        this.avsResponse = avsResponse;
    }

    public CardCodeResponseType getCardCodeResponse() {
        return this.cardCodeResponse;
    }

    public void setCardCodeResponse(CardCodeResponseType cardCodeResponse) {
        this.cardCodeResponse = cardCodeResponse;
    }

    public CAVVResponseType getCAVVResponse() {
        return this.CAVVResponse;
    }

    public void setCAVVResponse(CAVVResponseType cAVVResponse) {
        this.CAVVResponse = cAVVResponse;
    }

    public FDSFilterActionType getFDSFilterAction() {
        return this.FDSFilterAction;
    }

    public void setFDSFilterAction(FDSFilterActionType fDSFilterAction) {
        this.FDSFilterAction = fDSFilterAction;
    }

    public ArrayList<FDSFilter> getFDSFilterList() {
        return this.FDSFilterList;
    }

    public void setFDSFilterList(ArrayList<FDSFilter> fDSFilterList) {
        this.FDSFilterList = fDSFilterList;
    }

    public BatchDetails getBatch() {
        return this.batch;
    }

    public void setBatch(BatchDetails batch) {
        this.batch = batch;
    }

    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public BigDecimal getRequestedAmount() {
        return this.requestedAmount;
    }

    public void setRequestedAmount(BigDecimal requestedAmount) {
        this.requestedAmount = requestedAmount;
    }

    public void setRequestedAmount(String requestedAmount) {
        if (StringUtils.isNotEmpty(requestedAmount)) {
            this.requestedAmount = new BigDecimal(requestedAmount).setScale(2, 4);
        }
    }

    public BigDecimal getAuthAmount() {
        return this.authAmount;
    }

    public void setAuthAmount(BigDecimal authAmount) {
        this.authAmount = authAmount;
    }

    public void setAuthAmount(String authAmount) {
        if (StringUtils.isNotEmpty(authAmount)) {
            this.authAmount = new BigDecimal(authAmount).setScale(2, 4);
        }
    }

    public BigDecimal getSettleAmount() {
        return this.settleAmount;
    }

    public void setSettleAmount(BigDecimal settleAmount) {
        this.settleAmount = settleAmount;
    }

    public void setSettleAmount(String settleAmount) {
        if (StringUtils.isNotEmpty(settleAmount)) {
            this.settleAmount = new BigDecimal(settleAmount).setScale(2, 4);
        }
    }

    public Payment getPayment() {
        return this.payment;
    }

    public void setPayment(Payment payment) {
        this.payment = payment;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public boolean isRecurringBilling() {
        return this.recurringBilling;
    }

    public void setRecurringBilling(boolean recurringBilling) {
        this.recurringBilling = recurringBilling;
    }

    public void setRecurringBilling(String recurringBilling) {
        if (StringUtils.isNotEmpty(recurringBilling)) {
            this.recurringBilling = Boolean.valueOf(recurringBilling);
        }
    }

    public String getCustomerIP() {
        return this.customerIP;
    }

    public void setCustomerIP(String customerIP) {
        this.customerIP = customerIP;
    }

    public BigDecimal getPrepaidBalanceRemaining() {
        return this.prepaidBalanceRemaining;
    }

    public void setPrepaidBalanceRemaining(BigDecimal prepaidBalanceRemaining) {
        this.prepaidBalanceRemaining = prepaidBalanceRemaining;
    }

    public void setPrepaidBalanceRemaining(String prepaidBalanceRemaining) {
        if (StringUtils.isNotEmpty(prepaidBalanceRemaining)) {
            this.prepaidBalanceRemaining = new BigDecimal(prepaidBalanceRemaining).setScale(2, 4);
        }
    }

    public boolean isItemTaxExempt() {
        return this.itemTaxExempt;
    }

    public void setItemTaxExempt(boolean itemTaxExempt) {
        this.itemTaxExempt = itemTaxExempt;
    }

    public void setItemTaxExempt(String itemTaxExempt) {
        if (StringUtils.isNotEmpty(itemTaxExempt)) {
            this.itemTaxExempt = Boolean.valueOf(itemTaxExempt);
        }
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public void setSubscription(Subscription subscription) {
        this.subscription = subscription;
    }

    public boolean isHasReturnedItems() {
        return this.hasReturnedItems;
    }

    public void setHasReturnedItems(boolean hasReturnedItems) {
        this.hasReturnedItems = hasReturnedItems;
    }

    public void setHasReturnedItems(String hasReturnedItems) {
        if (null != hasReturnedItems) {
            try {
                boolean hasItems = Boolean.parseBoolean(hasReturnedItems.trim());
                this.setHasReturnedItems(hasItems);
            }
            catch (Exception e) {
                LogHelper.warn(logger, "Error parsing to boolean value: '%s'", hasReturnedItems);
            }
        }
    }

    public ArrayList<ReturnedItem> getReturnedItems() {
        return this.returnedItems;
    }

    public void setReturnedItems(ArrayList<ReturnedItem> returnedItems) {
        this.returnedItems = returnedItems;
    }

    public Solution getSolution() {
        return this.solution;
    }

    public void setSolution(Solution solution) {
        this.solution = solution;
    }
}

