/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.data.xml.reporting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CAVVResponseType {
    NOT_VALIDATED("", "CAVV\tnot validated"),
    CAVV_0("0", "CAVV not validated\tbecause erroneous data was submitted"),
    CAVV_1("1", "CAVV failed validation"),
    CAVV_2("2", "CAVV passed validation"),
    CAVV_3("3", "CAVV validation could not be performed; issuer attempt incomplete"),
    CAVV_4("4", "CAVV validation could not be performed; issuer system error"),
    CAVV_5("5", "Reserved for future use"),
    CAVV_6("6", "Reserved for future use"),
    CAVV_7("7", "CAVV attempt \u2014 failed validation \u2014 issuer available (U.S.-issued card/non-U.S. acquirer)"),
    CAVV_8("8", "CAVV attempt \u2014 passed validation \u2014 issuer available (U.S.-issued card/non-U.S. acquirer)"),
    CAVV_9("9", "CAVV attempt \u2014 failed validation \u2014 issuer unavailable (U.S.-issued card/non-U.S. acquirer)"),
    CAVV_A("A", "CAVV attempt \u2014 passed validation \u2014 issuer unavailable (U.S.-issued card/non-U.S. acquirer)"),
    CAVV_B("B", "CAVV passed validation, information only, no liability\tshift");

    private final String value;
    private final String description;

    private CAVVResponseType(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public static CAVVResponseType findByValue(String value) {
        if (value != null) {
            for (CAVVResponseType responseType : CAVVResponseType.values()) {
                if (!responseType.value.equals(value)) continue;
                return responseType;
            }
        }
        return NOT_VALIDATED;
    }

    public String getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }
}

