/*
 * Decompiled with CFR 0.152.
 */
package net.ashwork.upvote.database.util;

import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.ashwork.upvote.database.domain.dao.InsertDao;
import net.ashwork.upvote.database.util.ExceptionHelper;

public final class DatabaseHelper {
    public static <DBO, DAO extends InsertDao<DBO>, RESPONSE> RESPONSE persistToDatabase(DAO dao, DBO dbo, IntFunction<RESPONSE> success, Function<Throwable, RESPONSE> error) {
        return (RESPONSE)ExceptionHelper.getOrDefault(() -> success.apply(dao.insert(dbo)), error);
    }

    public static <DBO, DAO extends InsertDao<DBO>, RESPONSE> RESPONSE persistToDatabase(DAO dao, List<DBO> dbos, Supplier<RESPONSE> success, Function<Throwable, RESPONSE> error) {
        return (RESPONSE)ExceptionHelper.getOrDefault(() -> {
            dao.insertAll(dbos);
            return success.get();
        }, error);
    }
}

