/*
 * Decompiled with CFR 0.152.
 */
package net.ashwork.upvote.database.manager;

import java.util.function.Function;
import java.util.function.IntFunction;
import net.ashwork.upvote.database.domain.dao.InsertDao;
import net.ashwork.upvote.database.util.DatabaseHelper;
import net.ashwork.upvote.manager.AbstractInputManager;

public abstract class AbstractDatabaseManager<ENTRY, DBO, DAO extends InsertDao<DBO>, RESPONSE>
implements AbstractInputManager<ENTRY, RESPONSE> {
    protected final DAO dao;
    protected final Function<ENTRY, DBO> transformer;
    protected final IntFunction<RESPONSE> persistSuccess;
    protected final Function<Throwable, RESPONSE> throwingError;

    protected AbstractDatabaseManager(DAO dao, Function<ENTRY, DBO> transformer, IntFunction<RESPONSE> persistSuccess, Function<Throwable, RESPONSE> throwingError) {
        this.dao = dao;
        this.transformer = transformer;
        this.persistSuccess = persistSuccess;
        this.throwingError = throwingError;
    }

    public RESPONSE putEntry(ENTRY entry) {
        return DatabaseHelper.persistToDatabase(this.dao, this.transformer.apply(entry), this.persistSuccess, this.throwingError);
    }
}

