/*
 * Decompiled with CFR 0.152.
 */
package net.ashwork.upvote.database.domain.algorithm;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.ashwork.upvote.database.domain.dao.GetDao;
import net.ashwork.upvote.database.domain.dao.InsertDao;
import net.ashwork.upvote.database.util.DatabaseHelper;
import net.ashwork.upvote.database.util.ExceptionHelper;
import net.ashwork.upvote.domain.algorithm.WeightedTallyAlgorithm;

public class DatabaseWeightedTallyAlgorithm<ENTRY, WEIGHT, DAO extends InsertDao<WEIGHT> & GetDao<WEIGHT>, RESPONSE>
implements WeightedTallyAlgorithm<ENTRY, WEIGHT, RESPONSE> {
    private final DAO dao;
    private final Supplier<RESPONSE> persistAllSuccess;
    private final Function<Throwable, RESPONSE> throwingError;
    private final WeightedTallyAlgorithm<ENTRY, WEIGHT, List<WEIGHT>> algorithm;

    public DatabaseWeightedTallyAlgorithm(DAO dao, Supplier<RESPONSE> persistAllSuccess, Function<Throwable, RESPONSE> throwingError, WeightedTallyAlgorithm<ENTRY, WEIGHT, List<WEIGHT>> algorithm) {
        this.dao = dao;
        this.persistAllSuccess = persistAllSuccess;
        this.throwingError = throwingError;
        this.algorithm = algorithm;
    }

    public RESPONSE execute(List<ENTRY> entries) {
        return this.execute(entries, ExceptionHelper.getOrDefault(() -> this.dao.getAll(), Collections::emptyList));
    }

    public RESPONSE execute(List<ENTRY> entries, List<WEIGHT> weights) {
        return DatabaseHelper.persistToDatabase(this.dao, (List)this.algorithm.execute(entries, weights), this.persistAllSuccess, this.throwingError);
    }
}

