/*
 * Decompiled with CFR 0.152.
 */
package net.ashwork.functionality;

import net.ashwork.functionality.Function1;
import net.ashwork.functionality.partial.Arity;
import net.ashwork.functionality.partial.ResultChainableResult;

@FunctionalInterface
public interface FunctionN<R>
extends ResultChainableResult<R>,
Arity {
    public R applyAllUnchecked(Object ... var1);

    @Override
    default public int arity() {
        return -1;
    }

    default public R sizedApplyAllUnchecked(Object ... args) {
        return this.applyAllUnchecked(FunctionN.checkSize(this.arity(), args));
    }

    @Override
    default public <V> FunctionN<V> andThen(Function1<? super R, ? extends V> after) {
        return (FunctionN)ResultChainableResult.super.andThen((Function1)after);
    }

    @Override
    default public <V> FunctionN<V> andThenUnchecked(Function1<? super R, ? extends V> after) {
        return args -> after.apply((R)this.applyAllUnchecked(args));
    }

    public static <T> T[] checkSize(int size, T[] array) {
        return FunctionN.checkSize(size, array, "Function Arity " + size + " does not match the current argument size: " + array.length);
    }

    public static <T> T[] checkSize(int size, T[] array, String message) {
        if (size != array.length) {
            throw new FunctionSizeException(message);
        }
        return array;
    }

    public static class FunctionSizeException
    extends RuntimeException {
        public FunctionSizeException(String message) {
            super(message);
        }
    }

    public static class Instance<R>
    implements FunctionN<R> {
        private final int arity;
        private final Function1<Object[], R> function;

        public Instance(int arity, Function1<Object[], R> function) {
            this.arity = arity;
            this.function = function;
        }

        @Override
        public int arity() {
            return this.arity;
        }

        @Override
        public R applyAllUnchecked(Object ... args) {
            return this.function.apply(args);
        }

        @Override
        public <V> Instance<V> andThen(Function1<? super R, ? extends V> after) {
            return (Instance)FunctionN.super.andThen((Function1)after);
        }

        @Override
        public <V> Instance<V> andThenUnchecked(Function1<? super R, ? extends V> after) {
            return new Instance<Object>(this.arity(), args -> after.apply((R)this.function.apply((Object[])args)));
        }
    }
}

