/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.codegen.ibatis2.dao.elements;

import java.util.Set;
import java.util.TreeSet;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.codegen.ibatis2.dao.elements.AbstractDAOElementGenerator;

public class CountByExampleMethodGenerator
extends AbstractDAOElementGenerator {
    private boolean generateForJava5;

    public CountByExampleMethodGenerator(boolean generateForJava5) {
        this.generateForJava5 = generateForJava5;
    }

    @Override
    public void addImplementationElements(TopLevelClass topLevelClass) {
        TreeSet<FullyQualifiedJavaType> importedTypes = new TreeSet<FullyQualifiedJavaType>();
        Method method = this.getMethodShell(importedTypes);
        StringBuilder sb = new StringBuilder();
        sb.append("Integer count = (Integer)  ");
        sb.append(this.daoTemplate.getQueryForObjectMethod(this.introspectedTable.getIbatis2SqlMapNamespace(), this.introspectedTable.getCountByExampleStatementId(), "example"));
        method.addBodyLine(sb.toString());
        if (this.generateForJava5) {
            method.addBodyLine("return count;");
        } else {
            method.addBodyLine("return count.intValue();");
        }
        if (this.context.getPlugins().clientCountByExampleMethodGenerated(method, topLevelClass, this.introspectedTable)) {
            topLevelClass.addImportedTypes(importedTypes);
            topLevelClass.addMethod(method);
        }
    }

    @Override
    public void addInterfaceElements(Interface interfaze) {
        if (this.getExampleMethodVisibility() == JavaVisibility.PUBLIC) {
            TreeSet<FullyQualifiedJavaType> importedTypes = new TreeSet<FullyQualifiedJavaType>();
            Method method = this.getMethodShell(importedTypes);
            if (this.context.getPlugins().clientCountByExampleMethodGenerated(method, interfaze, this.introspectedTable)) {
                interfaze.addImportedTypes(importedTypes);
                interfaze.addMethod(method);
            }
        }
    }

    private Method getMethodShell(Set<FullyQualifiedJavaType> importedTypes) {
        FullyQualifiedJavaType type = new FullyQualifiedJavaType(this.introspectedTable.getExampleType());
        importedTypes.add(type);
        Method method = new Method();
        method.setVisibility(this.getExampleMethodVisibility());
        method.setReturnType(FullyQualifiedJavaType.getIntInstance());
        method.setName(this.getDAOMethodNameCalculator().getCountByExampleMethodName(this.introspectedTable));
        method.addParameter(new Parameter(type, "example"));
        for (FullyQualifiedJavaType fqjt : this.daoTemplate.getCheckedExceptions()) {
            method.addException(fqjt);
            importedTypes.add(fqjt);
        }
        this.context.getCommentGenerator().addGeneralMethodComment(method, this.introspectedTable);
        return method;
    }
}

