/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.internal;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.InnerEnum;
import org.mybatis.generator.api.dom.java.JavaElement;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.internal.util.StringUtility;

public class DefaultCommentGenerator
implements CommentGenerator {
    private Properties properties = new Properties();
    private boolean suppressDate = false;
    private boolean suppressAllComments = false;
    private boolean addRemarkComments = false;

    @Override
    public void addJavaFileComment(CompilationUnit compilationUnit) {
    }

    @Override
    public void addComment(XmlElement xmlElement) {
        if (this.suppressAllComments) {
            return;
        }
        xmlElement.addElement(new TextElement("<!--"));
        StringBuilder sb = new StringBuilder();
        sb.append("  WARNING - ");
        sb.append("@mbggenerated");
        xmlElement.addElement(new TextElement(sb.toString()));
        xmlElement.addElement(new TextElement("  This element is automatically generated by MyBatis Generator, do not modify."));
        String s = this.getDateString();
        if (s != null) {
            sb.setLength(0);
            sb.append("  This element was generated on ");
            sb.append(s);
            sb.append('.');
            xmlElement.addElement(new TextElement(sb.toString()));
        }
        xmlElement.addElement(new TextElement("-->"));
    }

    @Override
    public void addRootComment(XmlElement rootElement) {
    }

    @Override
    public void addConfigurationProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        this.suppressDate = StringUtility.isTrue(properties.getProperty("suppressDate"));
        this.suppressAllComments = StringUtility.isTrue(properties.getProperty("suppressAllComments"));
        this.addRemarkComments = StringUtility.isTrue(properties.getProperty("addRemarkComments"));
    }

    protected void addJavadocTag(JavaElement javaElement, boolean markAsDoNotDelete) {
        String s;
        javaElement.addJavaDocLine(" *");
        StringBuilder sb = new StringBuilder();
        sb.append(" * ");
        sb.append("@mbggenerated");
        if (markAsDoNotDelete) {
            sb.append(" do_not_delete_during_merge");
        }
        if ((s = this.getDateString()) != null) {
            sb.append(' ');
            sb.append(s);
        }
        javaElement.addJavaDocLine(sb.toString());
    }

    protected String getDateString() {
        if (this.suppressDate) {
            return null;
        }
        return new Date().toString();
    }

    @Override
    public void addClassComment(InnerClass innerClass, IntrospectedTable introspectedTable) {
        if (this.suppressAllComments) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        System.out.println("innerClass.getClass().getName() = " + innerClass.getType());
        String shortName = innerClass.getType().getShortName();
        innerClass.addJavaDocLine("/**");
        if ("GeneratedCriteria".equals(shortName)) {
            sb.append(" * \u57fa\u672c\u52a8\u6001SQL\u5bf9\u8c61,");
        } else if ("Criterion".equals(shortName)) {
            sb.append(" * \u52a8\u6001SQL\u5bf9\u8c61,");
        }
        sb.append(introspectedTable.getFullyQualifiedTable());
        innerClass.addJavaDocLine(sb.toString());
        innerClass.addJavaDocLine(" */");
    }

    @Override
    public void addModelClassComment(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        if (this.suppressAllComments || !this.addRemarkComments) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        topLevelClass.addJavaDocLine("/**");
        String remarks = introspectedTable.getRemarks();
        if (this.addRemarkComments && StringUtility.stringHasValue(remarks)) {
            String[] remarkLines;
            topLevelClass.addJavaDocLine(" * Database Table Remarks:");
            for (String remarkLine : remarkLines = remarks.split(System.getProperty("line.separator"))) {
                topLevelClass.addJavaDocLine(" *   " + remarkLine);
            }
        }
        topLevelClass.addJavaDocLine(" *");
        topLevelClass.addJavaDocLine(" * This class was generated by MyBatis Generator.");
        sb.append(" * This class corresponds to the database table ");
        sb.append(introspectedTable.getFullyQualifiedTable());
        topLevelClass.addJavaDocLine(sb.toString());
        this.addJavadocTag(topLevelClass, true);
        topLevelClass.addJavaDocLine(" */");
    }

    @Override
    public void addEnumComment(InnerEnum innerEnum, IntrospectedTable introspectedTable) {
        if (this.suppressAllComments) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        innerEnum.addJavaDocLine("/**");
        sb.append(" * This enum corresponds to the database table ");
        sb.append(introspectedTable.getFullyQualifiedTable());
        innerEnum.addJavaDocLine(sb.toString());
        innerEnum.addJavaDocLine(" */");
    }

    @Override
    public void addFieldComment(Field field, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        if (this.suppressAllComments) {
            return;
        }
        field.addJavaDocLine("/**");
        StringBuilder sb = new StringBuilder();
        sb.append(" * ");
        sb.append(introspectedColumn.getRemarks());
        sb.append(",\u6240\u5c5e\u8868\u5b57\u6bb5\u4e3a");
        sb.append(introspectedTable.getFullyQualifiedTable());
        sb.append('.');
        sb.append(introspectedColumn.getActualColumnName());
        field.addJavaDocLine(sb.toString());
        field.addJavaDocLine(" */");
    }

    @Override
    public void addFieldComment(Field field, IntrospectedTable introspectedTable) {
        if (this.suppressAllComments) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        field.addJavaDocLine("/**");
        String field_name = field.getName();
        sb.append(" * ");
        if ("orderByClause".equals(field_name)) {
            sb.append("\u6392\u5e8f\u5b57\u6bb5");
        } else if ("distinct".equals(field_name)) {
            sb.append("\u662f\u5426\u8fc7\u6ee4\u91cd\u590d\u6570\u636e");
        } else if (field_name.endsWith(introspectedTable.getExampleType())) {
            sb.append("\u5f53\u524d\u6392\u5e8f\u6761\u4ef6\u5b9e\u4f8b");
        } else if ("serialVersionUID".equals(field_name)) {
            sb.append("\u5e8f\u5217\u5316ID");
        }
        sb.append(",");
        sb.append(introspectedTable.getFullyQualifiedTable());
        field.addJavaDocLine(sb.toString());
        field.addJavaDocLine(" */");
    }

    @Override
    public void addGeneralMethodComment(Method method, IntrospectedTable introspectedTable) {
        String method_name;
        if (this.suppressAllComments) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        method.addJavaDocLine("/**");
        sb.append(" * ");
        if (method.isConstructor()) {
            sb.append(" \u6784\u9020\u67e5\u8be2\u6761\u4ef6");
        }
        if ("setOrderByClause".equals(method_name = method.getName())) {
            sb.append(" \u8bbe\u7f6e\u6392\u5e8f\u5b57\u6bb5");
        } else if ("setDistinct".equals(method_name)) {
            sb.append(" \u8bbe\u7f6e\u8fc7\u6ee4\u91cd\u590d\u6570\u636e");
        } else if ("getOredCriteria".equals(method_name)) {
            sb.append(" \u83b7\u53d6\u5f53\u524d\u7684\u67e5\u8be2\u6761\u4ef6\u5b9e\u4f8b");
        } else if ("isDistinct".equals(method_name)) {
            sb.append(" \u662f\u5426\u8fc7\u6ee4\u91cd\u590d\u6570\u636e");
        } else if ("getOrderByClause".equals(method_name)) {
            sb.append(" \u83b7\u53d6\u6392\u5e8f\u5b57\u6bb5");
        } else if ("createCriteria".equals(method_name)) {
            sb.append(" \u521b\u5efa\u4e00\u4e2a\u67e5\u8be2\u6761\u4ef6");
        } else if ("createCriteriaInternal".equals(method_name)) {
            sb.append(" \u5185\u90e8\u6784\u5efa\u67e5\u8be2\u6761\u4ef6\u5bf9\u8c61");
        } else if ("clear".equals(method_name)) {
            sb.append(" \u6e05\u9664\u67e5\u8be2\u6761\u4ef6");
        } else if ("countByExample".equals(method_name)) {
            sb.append(" \u6839\u636e\u6307\u5b9a\u7684\u6761\u4ef6\u83b7\u53d6\u6570\u636e\u5e93\u8bb0\u5f55\u6570");
        } else if ("deleteByExample".equals(method_name)) {
            sb.append(" \u6839\u636e\u6307\u5b9a\u7684\u6761\u4ef6\u5220\u9664\u6570\u636e\u5e93\u7b26\u5408\u6761\u4ef6\u7684\u8bb0\u5f55");
        } else if ("deleteByPrimaryKey".equals(method_name)) {
            sb.append(" \u6839\u636e\u4e3b\u952e\u5220\u9664\u6570\u636e\u5e93\u7684\u8bb0\u5f55");
        } else if ("insert".equals(method_name)) {
            sb.append(" \u65b0\u5199\u5165\u6570\u636e\u5e93\u8bb0\u5f55");
        } else if ("insertSelective".equals(method_name)) {
            sb.append(" \u52a8\u6001\u5b57\u6bb5,\u5199\u5165\u6570\u636e\u5e93\u8bb0\u5f55");
        } else if ("selectByExample".equals(method_name)) {
            sb.append(" \u6839\u636e\u6307\u5b9a\u7684\u6761\u4ef6\u67e5\u8be2\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u5e93\u8bb0\u5f55");
        } else if ("selectByPrimaryKey".equals(method_name)) {
            sb.append(" \u6839\u636e\u6307\u5b9a\u4e3b\u952e\u83b7\u53d6\u4e00\u6761\u6570\u636e\u5e93\u8bb0\u5f55");
        } else if ("updateByExampleSelective".equals(method_name)) {
            sb.append(" \u52a8\u6001\u6839\u636e\u6307\u5b9a\u7684\u6761\u4ef6\u6765\u66f4\u65b0\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u5e93\u8bb0\u5f55");
        } else if ("updateByExample".equals(method_name)) {
            sb.append(" \u6839\u636e\u6307\u5b9a\u7684\u6761\u4ef6\u6765\u66f4\u65b0\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u5e93\u8bb0\u5f55");
        } else if ("updateByPrimaryKeySelective".equals(method_name)) {
            sb.append(" \u52a8\u6001\u5b57\u6bb5,\u6839\u636e\u4e3b\u952e\u6765\u66f4\u65b0\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u5e93\u8bb0\u5f55");
        } else if ("updateByPrimaryKey".equals(method_name)) {
            sb.append(" \u6839\u636e\u4e3b\u952e\u6765\u66f4\u65b0\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u5e93\u8bb0\u5f55");
        }
        sb.append(",");
        sb.append(introspectedTable.getFullyQualifiedTable());
        method.addJavaDocLine(sb.toString());
        List<Parameter> parameterList = method.getParameters();
        if (!parameterList.isEmpty()) {
            method.addJavaDocLine(" *");
            if ("or".equals(method_name)) {
                sb.append(" \u589e\u52a0\u6216\u8005\u7684\u67e5\u8be2\u6761\u4ef6,\u7528\u4e8e\u6784\u5efa\u6216\u8005\u67e5\u8be2");
            }
        } else if ("or".equals(method_name)) {
            sb.append(" \u521b\u5efa\u4e00\u4e2a\u65b0\u7684\u6216\u8005\u67e5\u8be2\u6761\u4ef6");
        }
        for (Parameter parameter : parameterList) {
            sb.setLength(0);
            sb.append(" * @param ");
            String paramterName = parameter.getName();
            sb.append(paramterName);
            if ("orderByClause".equals(paramterName)) {
                sb.append(" \u6392\u5e8f\u5b57\u6bb5");
            } else if ("distinct".equals(paramterName)) {
                sb.append(" \u662f\u5426\u8fc7\u6ee4\u91cd\u590d\u6570\u636e");
            } else if ("criteria".equals(paramterName)) {
                sb.append(" \u8fc7\u6ee4\u6761\u4ef6\u5b9e\u4f8b");
            }
            method.addJavaDocLine(sb.toString());
        }
        method.addJavaDocLine(" */");
    }

    @Override
    public void addGetterComment(Method method, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        if (this.suppressAllComments) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        method.addJavaDocLine("/**");
        sb.append(" * \u83b7\u53d6 ");
        sb.append(introspectedColumn.getRemarks()).append(" \u5b57\u6bb5:");
        sb.append(introspectedTable.getFullyQualifiedTable());
        sb.append('.');
        sb.append(introspectedColumn.getActualColumnName());
        method.addJavaDocLine(sb.toString());
        method.addJavaDocLine(" *");
        sb.setLength(0);
        sb.append(" * @return ");
        sb.append(introspectedTable.getFullyQualifiedTable());
        sb.append('.');
        sb.append(introspectedColumn.getActualColumnName());
        sb.append(", ");
        sb.append(introspectedColumn.getRemarks());
        method.addJavaDocLine(sb.toString());
        method.addJavaDocLine(" */");
    }

    @Override
    public void addSetterComment(Method method, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        if (this.suppressAllComments) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        method.addJavaDocLine("/**");
        sb.append(" * \u8bbe\u7f6e ");
        sb.append(introspectedColumn.getRemarks()).append(" \u5b57\u6bb5:");
        sb.append(introspectedTable.getFullyQualifiedTable());
        sb.append('.');
        sb.append(introspectedColumn.getActualColumnName());
        method.addJavaDocLine(sb.toString());
        method.addJavaDocLine(" *");
        Parameter parm = method.getParameters().get(0);
        sb.setLength(0);
        sb.append(" * @param ");
        sb.append(parm.getName());
        sb.append(" ");
        sb.append(introspectedTable.getFullyQualifiedTable());
        sb.append('.');
        sb.append(introspectedColumn.getActualColumnName());
        sb.append(", ");
        sb.append(introspectedColumn.getRemarks());
        method.addJavaDocLine(sb.toString());
        method.addJavaDocLine(" */");
    }

    @Override
    public void addClassComment(InnerClass innerClass, IntrospectedTable introspectedTable, boolean markAsDoNotDelete) {
        if (this.suppressAllComments) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        innerClass.addJavaDocLine("/**");
        System.out.println("innerClass.getType().getShortName() = " + innerClass.getType().getShortName());
        sb.append(" * \u6570\u636e\u5e93\u8868 ");
        sb.append(introspectedTable.getFullyQualifiedTable());
        sb.append("\u6620\u5c04\u5b9e\u4f53");
        innerClass.addJavaDocLine(sb.toString());
        innerClass.addJavaDocLine(" */");
    }
}

