/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.extensions.diskspacemonitoring;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.moskito.core.predefined.MemoryStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.util.BuiltinUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscSpaceProducer
implements IStatsProducer {
    private static Logger log = LoggerFactory.getLogger(DiscSpaceProducer.class);
    private String path;
    private String producerId;
    private MemoryStats stats;
    private List<IStats> statsList;
    private static final String ID = "DiscSpaceUsable. path - ";
    private FileStore root;

    public DiscSpaceProducer(Path rootPath) {
        this.path = rootPath.toString();
        this.producerId = ID + this.path;
        this.statsList = new CopyOnWriteArrayList<IStats>();
        this.stats = new MemoryStats(this.producerId);
        this.statsList.add((IStats)this.stats);
        try {
            this.root = Files.getFileStore(rootPath);
        }
        catch (IOException e) {
            log.error("Querying space. Init error: " + e.toString());
            return;
        }
        BuiltinUpdater.addTask((TimerTask)new TimerTask(){

            @Override
            public void run() {
                DiscSpaceProducer.this.readMemory();
            }
        });
    }

    public String getCategory() {
        return "memory";
    }

    public String getProducerId() {
        return this.producerId;
    }

    public List<IStats> getStats() {
        return this.statsList;
    }

    public String getSubsystem() {
        return "plugins";
    }

    private void readMemory() {
        long space;
        try {
            space = this.root.getUsableSpace();
        }
        catch (IOException e) {
            log.error("Querying space. Querying error: " + e.toString());
            return;
        }
        this.stats.updateMemoryValue(space);
    }

    public String toString() {
        return super.toString() + ' ' + this.getClass().getSimpleName();
    }
}

