/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.extensions;

import java.nio.file.FileSystems;
import java.nio.file.Path;
import net.anotheria.moskito.core.plugins.AbstractMoskitoPlugin;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.extensions.diskspacemonitoring.DiscSpaceMonitoringConfig;
import net.anotheria.moskito.extensions.diskspacemonitoring.DiscSpaceProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskSpaceMonitoringPlugin
extends AbstractMoskitoPlugin {
    private static Logger log = LoggerFactory.getLogger(DiskSpaceMonitoringPlugin.class);

    public void initialize() {
        DiscSpaceMonitoringConfig config = DiscSpaceMonitoringConfig.getInstance();
        String[] disks = config.getDisks();
        if (disks == null || disks.length == 0) {
            return;
        }
        for (Path root : FileSystems.getDefault().getRootDirectories()) {
            for (String disk : disks) {
                if (disk.equals(root.toString())) {
                    log.info(": ");
                    ProducerRegistryFactory.getProducerRegistryInstance().registerProducer((IStatsProducer)new DiscSpaceProducer(root));
                    continue;
                }
                log.info("Found unknown disk in config: " + disk);
            }
        }
    }

    public void deInitialize() {
        super.deInitialize();
    }
}

