/*
 * Decompiled with CFR 0.152.
 */
package de.irisnet.java.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Describes the current balance of the given license key. A key has a certain amount of credits that can be used for any kind of AI recognition. The license key is invalid, when all of the credits have been used.")
public class LicenseInfo {
    public static final String SERIALIZED_NAME_CREDITS_USED = "creditsUsed";
    @SerializedName(value="creditsUsed")
    private Integer creditsUsed;
    public static final String SERIALIZED_NAME_CREDITS_REMAINING = "creditsRemaining";
    @SerializedName(value="creditsRemaining")
    private Integer creditsRemaining;
    public static final String SERIALIZED_NAME_TOTAL_CREDITS = "totalCredits";
    @SerializedName(value="totalCredits")
    private Integer totalCredits;

    public LicenseInfo creditsUsed(Integer creditsUsed) {
        this.creditsUsed = creditsUsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="14", value="Credits used for the license key.")
    public Integer getCreditsUsed() {
        return this.creditsUsed;
    }

    public void setCreditsUsed(Integer creditsUsed) {
        this.creditsUsed = creditsUsed;
    }

    public LicenseInfo creditsRemaining(Integer creditsRemaining) {
        this.creditsRemaining = creditsRemaining;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="86", value="Credits remaining for the license key.")
    public Integer getCreditsRemaining() {
        return this.creditsRemaining;
    }

    public void setCreditsRemaining(Integer creditsRemaining) {
        this.creditsRemaining = creditsRemaining;
    }

    public LicenseInfo totalCredits(Integer totalCredits) {
        this.totalCredits = totalCredits;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="100", value="Total credits contained within the license.")
    public Integer getTotalCredits() {
        return this.totalCredits;
    }

    public void setTotalCredits(Integer totalCredits) {
        this.totalCredits = totalCredits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LicenseInfo licenseInfo = (LicenseInfo)o;
        return Objects.equals(this.creditsUsed, licenseInfo.creditsUsed) && Objects.equals(this.creditsRemaining, licenseInfo.creditsRemaining) && Objects.equals(this.totalCredits, licenseInfo.totalCredits);
    }

    public int hashCode() {
        return Objects.hash(this.creditsUsed, this.creditsRemaining, this.totalCredits);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LicenseInfo {\n");
        sb.append("    creditsUsed: ").append(this.toIndentedString(this.creditsUsed)).append("\n");
        sb.append("    creditsRemaining: ").append(this.toIndentedString(this.creditsRemaining)).append("\n");
        sb.append("    totalCredits: ").append(this.toIndentedString(this.totalCredits)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

