/*
 * Decompiled with CFR 0.152.
 */
package de.irisnet.java.client.model;

import com.google.gson.annotations.SerializedName;
import de.irisnet.java.client.model.INObject;
import de.irisnet.java.client.model.INRule;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Contains information on the AI result from the source media check.")
public class IrisNet {
    public static final String SERIALIZED_NAME_RULES_BROKEN = "rulesBroken";
    @SerializedName(value="rulesBroken")
    private Integer rulesBroken;
    public static final String SERIALIZED_NAME_HELP_SUGGESTED = "helpSuggested";
    @SerializedName(value="helpSuggested")
    private Integer helpSuggested;
    public static final String SERIALIZED_NAME_SEVERITY = "severity";
    @SerializedName(value="severity")
    private Integer severity;
    public static final String SERIALIZED_NAME_GETN_CLASSES = "getnClasses";
    @SerializedName(value="getnClasses")
    private Integer getnClasses;
    public static final String SERIALIZED_NAME_GETN_OBJECTS = "getnObjects";
    @SerializedName(value="getnObjects")
    private Integer getnObjects;
    public static final String SERIALIZED_NAME_IN_RULE = "inRule";
    @SerializedName(value="inRule")
    private List<INRule> inRule = null;
    public static final String SERIALIZED_NAME_IN_OBJECT = "inObject";
    @SerializedName(value="inObject")
    private List<INObject> inObject = null;

    public IrisNet rulesBroken(Integer rulesBroken) {
        this.rulesBroken = rulesBroken;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0", value="The amount of broken rules that are contained in the source media.")
    public Integer getRulesBroken() {
        return this.rulesBroken;
    }

    public void setRulesBroken(Integer rulesBroken) {
        this.rulesBroken = rulesBroken;
    }

    public IrisNet helpSuggested(Integer helpSuggested) {
        this.helpSuggested = helpSuggested;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0", value="In cases where the AI is uncertain, this attribute is set (1), indication that it could be useful to double check the source media by a human.")
    public Integer getHelpSuggested() {
        return this.helpSuggested;
    }

    public void setHelpSuggested(Integer helpSuggested) {
        this.helpSuggested = helpSuggested;
    }

    public IrisNet severity(Integer severity) {
        this.severity = severity;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="100", value="The highest severity value found amongst the broken rules.")
    public Integer getSeverity() {
        return this.severity;
    }

    public void setSeverity(Integer severity) {
        this.severity = severity;
    }

    public IrisNet getnClasses(Integer getnClasses) {
        this.getnClasses = getnClasses;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8", value="The amount of classification objects that were checked against on the source media. This does not mean that all of the classifications were found.")
    public Integer getGetnClasses() {
        return this.getnClasses;
    }

    public void setGetnClasses(Integer getnClasses) {
        this.getnClasses = getnClasses;
    }

    public IrisNet getnObjects(Integer getnObjects) {
        this.getnObjects = getnObjects;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="The amount of objects that were recognized on the source image.")
    public Integer getGetnObjects() {
        return this.getnObjects;
    }

    public void setGetnObjects(Integer getnObjects) {
        this.getnObjects = getnObjects;
    }

    public IrisNet inRule(List<INRule> inRule) {
        this.inRule = inRule;
        return this;
    }

    public IrisNet addInRuleItem(INRule inRuleItem) {
        if (this.inRule == null) {
            this.inRule = new ArrayList<INRule>();
        }
        this.inRule.add(inRuleItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This list contains one rule per classification. Rules for classification objects that were not found, are omitted.")
    public List<INRule> getInRule() {
        return this.inRule;
    }

    public void setInRule(List<INRule> inRule) {
        this.inRule = inRule;
    }

    public IrisNet inObject(List<INObject> inObject) {
        this.inObject = inObject;
        return this;
    }

    public IrisNet addInObjectItem(INObject inObjectItem) {
        if (this.inObject == null) {
            this.inObject = new ArrayList<INObject>();
        }
        this.inObject.add(inObjectItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of all instances of the classification objects found on the source image.")
    public List<INObject> getInObject() {
        return this.inObject;
    }

    public void setInObject(List<INObject> inObject) {
        this.inObject = inObject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IrisNet irisNet = (IrisNet)o;
        return Objects.equals(this.rulesBroken, irisNet.rulesBroken) && Objects.equals(this.helpSuggested, irisNet.helpSuggested) && Objects.equals(this.severity, irisNet.severity) && Objects.equals(this.getnClasses, irisNet.getnClasses) && Objects.equals(this.getnObjects, irisNet.getnObjects) && Objects.equals(this.inRule, irisNet.inRule) && Objects.equals(this.inObject, irisNet.inObject);
    }

    public int hashCode() {
        return Objects.hash(this.rulesBroken, this.helpSuggested, this.severity, this.getnClasses, this.getnObjects, this.inRule, this.inObject);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IrisNet {\n");
        sb.append("    rulesBroken: ").append(this.toIndentedString(this.rulesBroken)).append("\n");
        sb.append("    helpSuggested: ").append(this.toIndentedString(this.helpSuggested)).append("\n");
        sb.append("    severity: ").append(this.toIndentedString(this.severity)).append("\n");
        sb.append("    getnClasses: ").append(this.toIndentedString(this.getnClasses)).append("\n");
        sb.append("    getnObjects: ").append(this.toIndentedString(this.getnObjects)).append("\n");
        sb.append("    inRule: ").append(this.toIndentedString(this.inRule)).append("\n");
        sb.append("    inObject: ").append(this.toIndentedString(this.inObject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

