/*
 * Decompiled with CFR 0.152.
 */
package de.irisnet.java.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Describes the rules applied and the count of objects found for the given classification.")
public class INRule {
    public static final String SERIALIZED_NAME_IN_CLASS = "inClass";
    @SerializedName(value="inClass")
    private String inClass;
    public static final String SERIALIZED_NAME_IN_GROUP = "inGroup";
    @SerializedName(value="inGroup")
    private String inGroup;
    public static final String SERIALIZED_NAME_FOUND = "found";
    @SerializedName(value="found")
    private Integer found;
    public static final String SERIALIZED_NAME_MIN = "min";
    @SerializedName(value="min")
    private Integer min;
    public static final String SERIALIZED_NAME_MAX = "max";
    @SerializedName(value="max")
    private Integer max;
    public static final String SERIALIZED_NAME_SEVERITY = "severity";
    @SerializedName(value="severity")
    private Integer severity;

    public INRule inClass(String inClass) {
        this.inClass = inClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="face", value="The classification of the recognized object.")
    public String getInClass() {
        return this.inClass;
    }

    public void setInClass(String inClass) {
        this.inClass = inClass;
    }

    public INRule inGroup(String inGroup) {
        this.inGroup = inGroup;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="human", value="The group of the classification.")
    public String getInGroup() {
        return this.inGroup;
    }

    public void setInGroup(String inGroup) {
        this.inGroup = inGroup;
    }

    public INRule found(Integer found) {
        this.found = found;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="The count of how many instances of the classification object were found.")
    public Integer getFound() {
        return this.found;
    }

    public void setFound(Integer found) {
        this.found = found;
    }

    public INRule min(Integer min) {
        this.min = min;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="The minimum allowed instances of the classification object.")
    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    public INRule max(Integer max) {
        this.max = max;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="The maximum allowed instances of the classification object.")
    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public INRule severity(Integer severity) {
        this.severity = severity;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="100", value="The severity of the classification object set while configuring the AI.")
    public Integer getSeverity() {
        return this.severity;
    }

    public void setSeverity(Integer severity) {
        this.severity = severity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        INRule inRule = (INRule)o;
        return Objects.equals(this.inClass, inRule.inClass) && Objects.equals(this.inGroup, inRule.inGroup) && Objects.equals(this.found, inRule.found) && Objects.equals(this.min, inRule.min) && Objects.equals(this.max, inRule.max) && Objects.equals(this.severity, inRule.severity);
    }

    public int hashCode() {
        return Objects.hash(this.inClass, this.inGroup, this.found, this.min, this.max, this.severity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class INRule {\n");
        sb.append("    inClass: ").append(this.toIndentedString(this.inClass)).append("\n");
        sb.append("    inGroup: ").append(this.toIndentedString(this.inGroup)).append("\n");
        sb.append("    found: ").append(this.toIndentedString(this.found)).append("\n");
        sb.append("    min: ").append(this.toIndentedString(this.min)).append("\n");
        sb.append("    max: ").append(this.toIndentedString(this.max)).append("\n");
        sb.append("    severity: ").append(this.toIndentedString(this.severity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

