/*
 * Decompiled with CFR 0.152.
 */
package de.irisnet.java.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A single parameter set for one object, for example face, describing the behaviour of the AI. Each object has default parameters that are set if these are empty.")
public class INParam {
    public static final String SERIALIZED_NAME_IN_CLASS = "inClass";
    @SerializedName(value="inClass")
    private InClassEnum inClass;
    public static final String SERIALIZED_NAME_MIN = "min";
    @SerializedName(value="min")
    private Integer min;
    public static final String SERIALIZED_NAME_MAX = "max";
    @SerializedName(value="max")
    private Integer max;
    public static final String SERIALIZED_NAME_SEVERITY = "severity";
    @SerializedName(value="severity")
    private Integer severity = 100;
    public static final String SERIALIZED_NAME_DRAW_MODE = "drawMode";
    @SerializedName(value="drawMode")
    private Integer drawMode;
    public static final String SERIALIZED_NAME_GREY = "grey";
    @SerializedName(value="grey")
    private Integer grey = 127;
    public static final String SERIALIZED_NAME_SCALE = "scale";
    @SerializedName(value="scale")
    private Float scale = Float.valueOf(1.0f);

    public INParam inClass(InClassEnum inClass) {
        this.inClass = inClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="face", value="The classification of the object, that the element refers to. Default parameter values are defined per classification object. The following list contains the default values for 'min', 'max' and 'drawMode' in order.  * _face_ _(1, 3, 0)_ - Classification for human faces. * _child (*)_ _(0, 0, 6)_ - Recognizes children's faces. * _adult (*)_ _(0, -1, 0)_ - Recognizes faces of adults that are not considered seniors. * _senior (*)_ _(0, -1, 0)_ - Recognizes faces of seniors. * _pose_ _(0, 0, 0)_ - The age can not be estimated, due to a pose that hides facial features. * _female (*)_ _(0, -1, 0)_ - Recognizes female faces.  * _male (*)_ _(0, -1, 0)_ - Recognizes male faces.  * _hand_ _(0, -1, 0)_ - Classification for recognizing hands. * _foot_ _(0, -1, 0)_ - Classification for recognizing feet. * _footwear_ _(0, -1, 0)_ - Classification for recognizing footwear. * _hair_ _(0, -1, 0)_ - Classification for recognizing hair.  * _hairless_ _(0, -1, 0)_ - Classification for recognizing no hair.  * _beard_ _(0, -1, 0)_ - Classification for recognizing beards.  * _moustache_ _(0, -1, 0)_ - Classification for recognizing moustaches.  * _headpiece_ _(0, -1, 0)_ - Classification for recognizing headpieces.  * _glasses_ _(0, -1, 0)_ - Classification for recognizing glasses.  * _sunglasses_ _(0, -1, 0)_ - Classification for recognizing sunglasses.  * _mask_ _(0, -1, 0)_ - Classification for recognizing medical masks.  * _breast_ _(0, 0, 2)_ - Object that recognizes female breasts. * _vulva_ _(0, 0, 2)_ - Object that recognizes vulvae. * _penis_ _(0, 0, 2)_ - Object that recognizes penises. * _vagina_ _(0, 0, 2)_ - Object that recognizes vaginae. * _buttocks_ _(0, 0, 2)_ - Object that recognizes buttocks. * _anus_ _(0, 0, 2)_ - Object that recognizes ani. * _toy_ _(0, -1, 0)_ - Object that recognizes sex toys. * _oral_ _(0, 0, 2)_ - Object that recognizes oral sex. * _penetration_ _(0, 0, 2)_ - Object that recognizes a sexual penetration penetration. * _illegalSymbols_ _(0, 0, 1)_ - Classification for symbols that are not permitted in Germany.  * _textRecognition_ _(0, 6, 6)_ - Classification for recognizing text occurrences.  _Classification objects that are marked with (*) are sub-classifications of face. Both face and the marked classification are affected by the given parameter values._  _Please be aware that the default values can be subject to change. This is due to the difficulty of recognizing certain objects e.g. objects that are classified as toy._")
    public InClassEnum getInClass() {
        return this.inClass;
    }

    public void setInClass(InClassEnum inClass) {
        this.inClass = inClass;
    }

    public INParam min(Integer min) {
        this.min = min;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The minimum amount of objects allowed on the source media. Setting the value to -1 will cause the AI to ignore this rule.")
    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    public INParam max(Integer max) {
        this.max = max;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum amount of objects allowed on the source media. Setting the value to -1 will cause the AI to ignore this rule.")
    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public INParam severity(Integer severity) {
        this.severity = severity;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="100", value="Set a value to define the severity of a broken rule of the given classification object.")
    public Integer getSeverity() {
        return this.severity;
    }

    public void setSeverity(Integer severity) {
        this.severity = severity;
    }

    public INParam drawMode(Integer drawMode) {
        this.drawMode = drawMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The draw mode that will be used for the creating the media.  * _0_ - will draw nothing, * _1_ - will draw a frame with class name surrounding the object, * _2_ - will draw a filled rectangle that will mask the object, * _3_ - is a combination between _1_ and _2_ (frame/name + mask), * _6_ - will blur the object and * _7_ - is a combination between _1_ and _6_ (frame/name + blur).")
    public Integer getDrawMode() {
        return this.drawMode;
    }

    public void setDrawMode(Integer drawMode) {
        this.drawMode = drawMode;
    }

    public INParam grey(Integer grey) {
        this.grey = grey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A grey scale color to use for masking. '0' will represent black, while the maximum '255' will be white.")
    public Integer getGrey() {
        return this.grey;
    }

    public void setGrey(Integer grey) {
        this.grey = grey;
    }

    public INParam scale(Float scale) {
        this.scale = scale;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Scale of the draw rectangle around the classification object. Specify a value to increase or decrease the size of the border.")
    public Float getScale() {
        return this.scale;
    }

    public void setScale(Float scale) {
        this.scale = scale;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        INParam inParam = (INParam)o;
        return Objects.equals((Object)this.inClass, (Object)inParam.inClass) && Objects.equals(this.min, inParam.min) && Objects.equals(this.max, inParam.max) && Objects.equals(this.severity, inParam.severity) && Objects.equals(this.drawMode, inParam.drawMode) && Objects.equals(this.grey, inParam.grey) && Objects.equals(this.scale, inParam.scale);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.inClass, this.min, this.max, this.severity, this.drawMode, this.grey, this.scale});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class INParam {\n");
        sb.append("    inClass: ").append(this.toIndentedString((Object)this.inClass)).append("\n");
        sb.append("    min: ").append(this.toIndentedString(this.min)).append("\n");
        sb.append("    max: ").append(this.toIndentedString(this.max)).append("\n");
        sb.append("    severity: ").append(this.toIndentedString(this.severity)).append("\n");
        sb.append("    drawMode: ").append(this.toIndentedString(this.drawMode)).append("\n");
        sb.append("    grey: ").append(this.toIndentedString(this.grey)).append("\n");
        sb.append("    scale: ").append(this.toIndentedString(this.scale)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum InClassEnum {
        FACE("face"),
        HAND("hand"),
        FOOT("foot"),
        FOOTWEAR("footwear"),
        BREAST("breast"),
        VULVA("vulva"),
        PENIS("penis"),
        VAGINA("vagina"),
        BUTTOCKS("buttocks"),
        ANUS("anus"),
        ORAL("oral"),
        PENETRATION("penetration"),
        TOY("toy"),
        CHILD("child"),
        ADULT("adult"),
        SENIOR("senior"),
        POSE("pose"),
        FEMALE("female"),
        MALE("male"),
        HAIR("hair"),
        HAIRLESS("hairless"),
        BEARD("beard"),
        MOUSTACHE("moustache"),
        HEADPIECE("headpiece"),
        GLASSES("glasses"),
        SUNGLASSES("sunglasses"),
        MASK("mask"),
        NUDITYCHECK("nudityCheck"),
        AGEVERIFICATION("ageVerification"),
        AGEESTIMATION("ageEstimation"),
        ILLEGALSYMBOLS("illegalSymbols"),
        TEXTRECOGNITION("textRecognition"),
        ATTRIBUTESCHECK("attributesCheck");

        private String value;

        private InClassEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static InClassEnum fromValue(String value) {
            for (InClassEnum b : InClassEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<InClassEnum> {
            public void write(JsonWriter jsonWriter, InClassEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public InClassEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return InClassEnum.fromValue(value);
            }
        }
    }
}

