/*
 * Decompiled with CFR 0.152.
 */
package de.irisnet.java.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Describes a rectangle that stretches around the recognized object. This is useful when redacting or blurring certain recognized objects. Each object contains the name of the classification and coordinates for a rectangle around the recognized object. The origin point (y = 0.0, x = 0.0) of the coordinate system is on the top left of the of the source material. The bottom right of the source is always y = 1 and x = 1.")
public class INObject {
    public static final String SERIALIZED_NAME_IN_CLASS = "inClass";
    @SerializedName(value="inClass")
    private String inClass;
    public static final String SERIALIZED_NAME_IN_GROUP = "inGroup";
    @SerializedName(value="inGroup")
    private String inGroup;
    public static final String SERIALIZED_NAME_IN_ID = "inId";
    @SerializedName(value="inId")
    private String inId;
    public static final String SERIALIZED_NAME_COLOR = "color";
    @SerializedName(value="color")
    private ColorEnum color;
    public static final String SERIALIZED_NAME_STYLE = "style";
    @SerializedName(value="style")
    private StyleEnum style;
    public static final String SERIALIZED_NAME_X0 = "x0";
    @SerializedName(value="x0")
    private Float x0;
    public static final String SERIALIZED_NAME_Y0 = "y0";
    @SerializedName(value="y0")
    private Float y0;
    public static final String SERIALIZED_NAME_WIDTH = "width";
    @SerializedName(value="width")
    private Float width;
    public static final String SERIALIZED_NAME_HEIGHT = "height";
    @SerializedName(value="height")
    private Float height;
    public static final String SERIALIZED_NAME_PROBABILITY = "probability";
    @SerializedName(value="probability")
    private Integer probability;

    public INObject inClass(String inClass) {
        this.inClass = inClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="face", value="The classification of the recognized object.")
    public String getInClass() {
        return this.inClass;
    }

    public void setInClass(String inClass) {
        this.inClass = inClass;
    }

    public INObject inGroup(String inGroup) {
        this.inGroup = inGroup;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="human", value="The group of the classification.")
    public String getInGroup() {
        return this.inGroup;
    }

    public void setInGroup(String inGroup) {
        this.inGroup = inGroup;
    }

    public INObject inId(String inId) {
        this.inId = inId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="human", value="The group of the classification.")
    public String getInId() {
        return this.inId;
    }

    public void setInId(String inId) {
        this.inId = inId;
    }

    public INObject color(ColorEnum color) {
        this.color = color;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="black", value="The color of the object, e.g. the color of the hair. Is only available for certain classification objects. See list below:  * _hair_ - black, brown, blonde, grey, red, other")
    public ColorEnum getColor() {
        return this.color;
    }

    public void setColor(ColorEnum color) {
        this.color = color;
    }

    public INObject style(StyleEnum style) {
        this.style = style;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="longHaired", value="The style attribute of the object, e.g. the style of the hair. Is only available for certain classification objects. See list below:  * _hair_ - longHaired, shortHaired")
    public StyleEnum getStyle() {
        return this.style;
    }

    public void setStyle(StyleEnum style) {
        this.style = style;
    }

    public INObject x0(Float x0) {
        this.x0 = x0;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.1", value="The center of the rectangle in the horizontal (x) direction.")
    public Float getX0() {
        return this.x0;
    }

    public void setX0(Float x0) {
        this.x0 = x0;
    }

    public INObject y0(Float y0) {
        this.y0 = y0;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.1", value="The center of the rectangle in the vertical (y) direction.")
    public Float getY0() {
        return this.y0;
    }

    public void setY0(Float y0) {
        this.y0 = y0;
    }

    public INObject width(Float width) {
        this.width = width;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.1", value="The total width of the rectangle in the horizontal (x) direction. Use _x0 - width / 2_ and _x0 + width / 2_ to get the left and right edges of the rectangle.")
    public Float getWidth() {
        return this.width;
    }

    public void setWidth(Float width) {
        this.width = width;
    }

    public INObject height(Float height) {
        this.height = height;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.1", value="The total height of the rectangle in the vertical (y) direction. Use _y0 - height / 2_ and _y0 + height / 2_ to get the top and bottom edges of the rectangle.")
    public Float getHeight() {
        return this.height;
    }

    public void setHeight(Float height) {
        this.height = height;
    }

    public INObject probability(Integer probability) {
        this.probability = probability;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="94", value="The probability that the object found matches the classification.")
    public Integer getProbability() {
        return this.probability;
    }

    public void setProbability(Integer probability) {
        this.probability = probability;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        INObject inObject = (INObject)o;
        return Objects.equals(this.inClass, inObject.inClass) && Objects.equals(this.inGroup, inObject.inGroup) && Objects.equals(this.inId, inObject.inId) && Objects.equals((Object)this.color, (Object)inObject.color) && Objects.equals((Object)this.style, (Object)inObject.style) && Objects.equals(this.x0, inObject.x0) && Objects.equals(this.y0, inObject.y0) && Objects.equals(this.width, inObject.width) && Objects.equals(this.height, inObject.height) && Objects.equals(this.probability, inObject.probability);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.inClass, this.inGroup, this.inId, this.color, this.style, this.x0, this.y0, this.width, this.height, this.probability});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class INObject {\n");
        sb.append("    inClass: ").append(this.toIndentedString(this.inClass)).append("\n");
        sb.append("    inGroup: ").append(this.toIndentedString(this.inGroup)).append("\n");
        sb.append("    inId: ").append(this.toIndentedString(this.inId)).append("\n");
        sb.append("    color: ").append(this.toIndentedString((Object)this.color)).append("\n");
        sb.append("    style: ").append(this.toIndentedString((Object)this.style)).append("\n");
        sb.append("    x0: ").append(this.toIndentedString(this.x0)).append("\n");
        sb.append("    y0: ").append(this.toIndentedString(this.y0)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    probability: ").append(this.toIndentedString(this.probability)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StyleEnum {
        LONGHAIRED("longHaired"),
        SHORTHAIRED("shortHaired");

        private String value;

        private StyleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StyleEnum fromValue(String value) {
            for (StyleEnum b : StyleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StyleEnum> {
            public void write(JsonWriter jsonWriter, StyleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StyleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StyleEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ColorEnum {
        BLACK("black"),
        BROWN("brown"),
        BLONDE("blonde"),
        GREY("grey"),
        RED("red"),
        OTHER("other");

        private String value;

        private ColorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ColorEnum fromValue(String value) {
            for (ColorEnum b : ColorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ColorEnum> {
            public void write(JsonWriter jsonWriter, ColorEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ColorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ColorEnum.fromValue(value);
            }
        }
    }
}

