/*
 * Decompiled with CFR 0.152.
 */
package de.irisnet.java.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Configures your detection. As there are literally hundreds of parameters, INDefine uses prototypes to get usefull behaviour. This includes a default setting for parameters and rules that should be applied to images. You can combine multiple detections by using more than 1 prototype")
public class INImage {
    public static final String SERIALIZED_NAME_PROTO = "proto";
    @SerializedName(value="proto")
    private ProtoEnum proto;

    public INImage proto(ProtoEnum proto) {
        this.proto = proto;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of commonly used rule sets (prototypes). That can be used to speed up the setup process. * _nudityCheck_ - Commonly used prototype to check for nudity. * _ageVerification_ - Deprecated see 'ageEstimation'. * _ageEstimation_ - Checks if there are children, adults or seniors recognizable. This is intended to be a suggestion to help you implement further steps. * _illegalSymbols_ - Checks for symbols that are not permitted in Germany. * _textRecognition_ - Checks for text occurrences. * _attributesCheck_ - Checks for attributes of a person (e.g. female, male, glasses, hair, etc). ")
    public ProtoEnum getProto() {
        return this.proto;
    }

    public void setProto(ProtoEnum proto) {
        this.proto = proto;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        INImage inImage = (INImage)o;
        return Objects.equals((Object)this.proto, (Object)inImage.proto);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.proto});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class INImage {\n");
        sb.append("    proto: ").append(this.toIndentedString((Object)this.proto)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ProtoEnum {
        NUDITYCHECK("nudityCheck"),
        AGEVERIFICATION("ageVerification"),
        AGEESTIMATION("ageEstimation"),
        ILLEGALSYMBOLS("illegalSymbols"),
        TEXTRECOGNITION("textRecognition"),
        ATTRIBUTESCHECK("attributesCheck");

        private String value;

        private ProtoEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ProtoEnum fromValue(String value) {
            for (ProtoEnum b : ProtoEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ProtoEnum> {
            public void write(JsonWriter jsonWriter, ProtoEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ProtoEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ProtoEnum.fromValue(value);
            }
        }
    }
}

