/*
 * Decompiled with CFR 0.152.
 */
package de.irisnet.java.client;

import com.google.gson.reflect.TypeToken;
import de.irisnet.java.ApiCallback;
import de.irisnet.java.ApiClient;
import de.irisnet.java.ApiException;
import de.irisnet.java.ApiResponse;
import de.irisnet.java.Configuration;
import de.irisnet.java.Pair;
import de.irisnet.java.client.model.LicenseInfo;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class MiscellaneousOperationsApi {
    private ApiClient localVarApiClient;

    public MiscellaneousOperationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MiscellaneousOperationsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call downloadProcessedCall(String filename, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/download/{filename}".replaceAll("\\{filename\\}", this.localVarApiClient.escapeString(filename.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call downloadProcessedValidateBeforeCall(String filename, ApiCallback _callback) throws ApiException {
        if (filename == null) {
            throw new ApiException("Missing the required parameter 'filename' when calling downloadProcessed(Async)");
        }
        Call localVarCall = this.downloadProcessedCall(filename, _callback);
        return localVarCall;
    }

    public File downloadProcessed(String filename) throws ApiException {
        ApiResponse<File> localVarResp = this.downloadProcessedWithHttpInfo(filename);
        return localVarResp.getData();
    }

    public ApiResponse<File> downloadProcessedWithHttpInfo(String filename) throws ApiException {
        Call localVarCall = this.downloadProcessedValidateBeforeCall(filename, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call downloadProcessedAsync(String filename, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.downloadProcessedValidateBeforeCall(filename, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAICostCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/cost";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAICostValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAICostCall(_callback);
        return localVarCall;
    }

    public Long getAICost() throws ApiException {
        ApiResponse<Long> localVarResp = this.getAICostWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<Long> getAICostWithHttpInfo() throws ApiException {
        Call localVarCall = this.getAICostValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<Long>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAICostAsync(ApiCallback<Long> _callback) throws ApiException {
        Call localVarCall = this.getAICostValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<Long>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getLicenseInfoCall(String licenseKey, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/info/{licenseKey}".replaceAll("\\{licenseKey\\}", this.localVarApiClient.escapeString(licenseKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/xml", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getLicenseInfoValidateBeforeCall(String licenseKey, ApiCallback _callback) throws ApiException {
        if (licenseKey == null) {
            throw new ApiException("Missing the required parameter 'licenseKey' when calling getLicenseInfo(Async)");
        }
        Call localVarCall = this.getLicenseInfoCall(licenseKey, _callback);
        return localVarCall;
    }

    public LicenseInfo getLicenseInfo(String licenseKey) throws ApiException {
        ApiResponse<LicenseInfo> localVarResp = this.getLicenseInfoWithHttpInfo(licenseKey);
        return localVarResp.getData();
    }

    public ApiResponse<LicenseInfo> getLicenseInfoWithHttpInfo(String licenseKey) throws ApiException {
        Call localVarCall = this.getLicenseInfoValidateBeforeCall(licenseKey, null);
        Type localVarReturnType = new TypeToken<LicenseInfo>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getLicenseInfoAsync(String licenseKey, ApiCallback<LicenseInfo> _callback) throws ApiException {
        Call localVarCall = this.getLicenseInfoValidateBeforeCall(licenseKey, _callback);
        Type localVarReturnType = new TypeToken<LicenseInfo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

