/*
 * Decompiled with CFR 0.152.
 */
package net.andrewcpu.elevenlabs.model.voice;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.andrewcpu.elevenlabs.ElevenLabs;
import net.andrewcpu.elevenlabs.model.response.CreateVoiceResponse;
import net.andrewcpu.elevenlabs.model.voice.Voice;

public class VoiceBuilder {
    private Voice voice;
    private String name;
    private String description;
    private Map<String, String> labels = new HashMap<String, String>();
    private List<File> files = new ArrayList<File>();

    public static VoiceBuilder fromVoice(Voice voice) {
        VoiceBuilder voiceBuilder = new VoiceBuilder(voice);
        return voiceBuilder;
    }

    public VoiceBuilder() {
    }

    public VoiceBuilder(Voice voice) {
        this();
        this.voice = voice;
        this.name = voice.getName();
        this.description = voice.getDescription();
        this.labels = voice.getLabels();
    }

    public String getName() {
        return this.name;
    }

    public VoiceBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public VoiceBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public VoiceBuilder withLabels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public VoiceBuilder withLabel(String key, String value) {
        this.labels.put(key, value);
        return this;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public VoiceBuilder withFile(File file) {
        this.files.add(file);
        return this;
    }

    public VoiceBuilder withFiles(List<File> files) {
        this.files = files;
        return this;
    }

    public Voice create() {
        CreateVoiceResponse createVoiceResponse = ElevenLabs.createVoice(this.name, (File[])this.files.toArray(File[]::new), this.description, this.labels);
        return Voice.getVoice(createVoiceResponse.getVoiceId(), true);
    }

    public Voice edit() {
        ElevenLabs.editVoice(this.voice.getVoiceId(), this.name, (File[])this.files.toArray(File[]::new), this.description, this.labels);
        this.voice = this.voice.refresh();
        return this.voice;
    }
}

