/*
 * Decompiled with CFR 0.152.
 */
package net.andrewcpu.elevenlabs.model.voice;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.andrewcpu.elevenlabs.ElevenLabs;
import net.andrewcpu.elevenlabs.model.ElevenModel;
import net.andrewcpu.elevenlabs.model.tuning.FineTuning;
import net.andrewcpu.elevenlabs.model.voice.Sample;
import net.andrewcpu.elevenlabs.model.voice.Sharing;
import net.andrewcpu.elevenlabs.model.voice.VoiceSettings;

public class Voice
extends ElevenModel {
    @JsonProperty(value="voice_id")
    private String voiceId;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="samples")
    private List<Sample> samples;
    @JsonProperty(value="category")
    private String category;
    @JsonProperty(value="fine_tuning")
    private FineTuning fineTuning;
    @JsonProperty(value="labels")
    private Map<String, String> labels;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="preview_url")
    private String previewUrl;
    @JsonProperty(value="available_for_tiers")
    private List<String> availableForTiers;
    @JsonProperty(value="settings")
    private VoiceSettings settings;
    @JsonProperty(value="sharing")
    private Sharing sharing;

    public static List<Voice> getVoices() {
        return ElevenLabs.getVoices();
    }

    public static Voice getVoice(String voiceId) {
        return ElevenLabs.getVoice(voiceId);
    }

    public static Voice getVoice(String voiceId, boolean withSettings) {
        return ElevenLabs.getVoice(voiceId, withSettings);
    }

    @JsonIgnore
    public String getVoiceId() {
        return this.voiceId;
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public List<Sample> getSamples() {
        return this.samples.stream().peek(s -> {
            s.voice = this;
        }).collect(Collectors.toList());
    }

    @JsonIgnore
    public String getCategory() {
        return this.category;
    }

    @JsonIgnore
    public FineTuning getFineTuning() {
        return this.fineTuning;
    }

    @JsonIgnore
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @JsonIgnore
    public String getDescription() {
        return this.description;
    }

    @JsonIgnore
    public String getPreviewUrl() {
        return this.previewUrl;
    }

    @JsonIgnore
    public List<String> getAvailableForTiers() {
        return this.availableForTiers;
    }

    @JsonIgnore
    public VoiceSettings getSettings() {
        return this.settings;
    }

    @JsonIgnore
    public Sharing getSharing() {
        return this.sharing;
    }

    public String delete() {
        return ElevenLabs.deleteVoice(this.voiceId);
    }

    public VoiceSettings fetchSettings() {
        this.settings = ElevenLabs.getVoiceSettings(this.voiceId);
        return this.settings;
    }

    public VoiceSettings updateVoiceSettings(VoiceSettings voiceSettings) {
        ElevenLabs.editVoiceSettings(this.voiceId, voiceSettings);
        this.settings = voiceSettings;
        return this.settings;
    }

    public Voice refresh() {
        Voice refreshedData = Voice.getVoice(this.voiceId, true);
        this.name = refreshedData.name;
        this.settings = refreshedData.settings;
        this.voiceId = refreshedData.voiceId;
        this.labels = refreshedData.labels;
        this.description = refreshedData.description;
        this.samples = refreshedData.samples;
        this.fineTuning = refreshedData.fineTuning;
        this.availableForTiers = refreshedData.availableForTiers;
        this.sharing = refreshedData.sharing;
        this.previewUrl = refreshedData.previewUrl;
        this.category = refreshedData.category;
        return this;
    }

    public File generate(String text, String model) {
        return ElevenLabs.generateTextToSpeech(this.voiceId, text, model, this.settings);
    }

    public File generate(String text, String model, VoiceSettings settings) {
        return ElevenLabs.generateTextToSpeech(this.voiceId, text, model, settings);
    }

    public File generate(String text, VoiceSettings settings) {
        return ElevenLabs.generateTextToSpeech(this.voiceId, text, "eleven_monolingual_v1", settings);
    }

    public File generate(String text) {
        return ElevenLabs.generateTextToSpeech(this.voiceId, text, "eleven_monolingual_v1", this.settings);
    }

    public InputStream generateStream(String text, String model) {
        return ElevenLabs.generateTextToSpeechStreamed(this.voiceId, text, model, this.settings);
    }

    public InputStream generateStream(String text, String model, VoiceSettings settings) {
        return ElevenLabs.generateTextToSpeechStreamed(this.voiceId, text, model, settings);
    }

    public InputStream generateStream(String text, VoiceSettings settings) {
        return ElevenLabs.generateTextToSpeechStreamed(this.voiceId, text, "eleven_monolingual_v1", settings);
    }

    public InputStream generateStream(String text) {
        return ElevenLabs.generateTextToSpeechStreamed(this.voiceId, text, "eleven_monolingual_v1", this.settings);
    }

    @JsonIgnore
    public String toString() {
        return "Voice{voiceId='" + this.voiceId + "', name='" + this.name + "', samples=" + this.samples + ", category='" + this.category + "', fineTuning=" + this.fineTuning + ", labels=" + this.labels + ", description='" + this.description + "', previewUrl='" + this.previewUrl + "', availableForTiers=" + this.availableForTiers + ", settings=" + this.settings + ", sharing=" + this.sharing + "}";
    }
}

