/*
 * Decompiled with CFR 0.152.
 */
package net.andrewcpu.elevenlabs.model.history;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.util.Map;
import net.andrewcpu.elevenlabs.ElevenLabs;
import net.andrewcpu.elevenlabs.model.ElevenModel;
import net.andrewcpu.elevenlabs.model.history.Feedback;

public class HistoryItem
extends ElevenModel {
    @JsonProperty(value="history_item_id")
    private String historyItemId;
    @JsonProperty(value="request_id")
    private String requestId;
    @JsonProperty(value="voice_id")
    private String voiceId;
    @JsonProperty(value="voice_name")
    private String voiceName;
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="date_unix")
    private long dateUnix;
    @JsonProperty(value="character_count_change_from")
    private int characterCountChangeFrom;
    @JsonProperty(value="character_count_change_to")
    private int characterCountChangeTo;
    @JsonProperty(value="content_type")
    private String contentType;
    @JsonProperty(value="state")
    private String state;
    @JsonProperty(value="settings")
    private Map<String, Object> settings;
    @JsonProperty(value="feedback")
    private Feedback feedback;

    public HistoryItem(String historyItemId, String requestId, String voiceId, String voiceName, String text, long dateUnix, int characterCountChangeFrom, int characterCountChangeTo, String contentType, String state, Map<String, Object> settings, Feedback feedback) {
        this.historyItemId = historyItemId;
        this.requestId = requestId;
        this.voiceId = voiceId;
        this.voiceName = voiceName;
        this.text = text;
        this.dateUnix = dateUnix;
        this.characterCountChangeFrom = characterCountChangeFrom;
        this.characterCountChangeTo = characterCountChangeTo;
        this.contentType = contentType;
        this.state = state;
        this.settings = settings;
        this.feedback = feedback;
    }

    public HistoryItem() {
    }

    @JsonIgnore
    public String getHistoryItemId() {
        return this.historyItemId;
    }

    @JsonIgnore
    public String getRequestId() {
        return this.requestId;
    }

    @JsonIgnore
    public String getVoiceId() {
        return this.voiceId;
    }

    @JsonIgnore
    public String getVoiceName() {
        return this.voiceName;
    }

    @JsonIgnore
    public String getText() {
        return this.text;
    }

    @JsonIgnore
    public long getDateUnix() {
        return this.dateUnix;
    }

    @JsonIgnore
    public int getCharacterCountChangeFrom() {
        return this.characterCountChangeFrom;
    }

    @JsonIgnore
    public int getCharacterCountChangeTo() {
        return this.characterCountChangeTo;
    }

    @JsonIgnore
    public String getContentType() {
        return this.contentType;
    }

    @JsonIgnore
    public String getState() {
        return this.state;
    }

    @JsonIgnore
    public Map<String, Object> getSettings() {
        return this.settings;
    }

    @JsonIgnore
    public Feedback getFeedback() {
        return this.feedback;
    }

    public String delete() {
        return ElevenLabs.deleteHistoryItem(this.historyItemId);
    }

    public File downloadAudio() {
        return ElevenLabs.getHistoryItemAudio(this.historyItemId);
    }

    @JsonIgnore
    public String toString() {
        return "HistoryItem{historyItemId='" + this.historyItemId + "', requestId='" + this.requestId + "', voiceId='" + this.voiceId + "', voiceName='" + this.voiceName + "', text='" + this.text + "', dateUnix=" + this.dateUnix + ", characterCountChangeFrom=" + this.characterCountChangeFrom + ", characterCountChangeTo=" + this.characterCountChangeTo + ", contentType='" + this.contentType + "', state='" + this.state + "', settings=" + this.settings + ", feedback=" + this.feedback + "}";
    }
}

