/*
 * Decompiled with CFR 0.152.
 */
package net.andrewcpu.elevenlabs.model.history;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import net.andrewcpu.elevenlabs.ElevenLabs;
import net.andrewcpu.elevenlabs.model.ElevenModel;
import net.andrewcpu.elevenlabs.model.history.HistoryItem;

public class History
extends ElevenModel {
    @JsonProperty(value="history")
    private List<HistoryItem> historyItems;
    @JsonProperty(value="last_history_item_id")
    private String lastHistoryItemId;
    @JsonProperty(value="has_more")
    private boolean hasMore;

    public static History get() {
        return ElevenLabs.getHistory();
    }

    public History(List<HistoryItem> historyItems) {
        this.historyItems = historyItems;
    }

    public History() {
    }

    @JsonIgnore
    public HistoryItem getHistoryItem(String id) {
        for (HistoryItem item : this.historyItems) {
            if (!item.getHistoryItemId().equals(id)) continue;
            return item;
        }
        return null;
    }

    @JsonIgnore
    public List<HistoryItem> getHistoryItems() {
        return this.historyItems;
    }

    @JsonIgnore
    public String getLastHistoryItemId() {
        return this.lastHistoryItemId;
    }

    @JsonIgnore
    public boolean isHasMore() {
        return this.hasMore;
    }

    public File downloadHistory(String ... historyIds) {
        return ElevenLabs.getHistoryItemAudio(historyIds);
    }

    public File downloadHistory(HistoryItem ... items) {
        return ElevenLabs.getHistoryItemAudio((String[])Arrays.stream(items).map(HistoryItem::getHistoryItemId).toArray(String[]::new));
    }

    @JsonIgnore
    public String toString() {
        return "History{historyItems=" + this.historyItems + ", lastHistoryItemId='" + this.lastHistoryItemId + "', hasMore=" + this.hasMore + "}";
    }
}

