/*
 * Decompiled with CFR 0.152.
 */
package net.andrewcpu.elevenlabs;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import net.andrewcpu.elevenlabs.model.history.History;
import net.andrewcpu.elevenlabs.model.history.HistoryItem;
import net.andrewcpu.elevenlabs.model.request.TextToSpeechRequest;
import net.andrewcpu.elevenlabs.model.response.CreateVoiceResponse;
import net.andrewcpu.elevenlabs.model.response.GenerationTypeModel;
import net.andrewcpu.elevenlabs.model.user.Subscription;
import net.andrewcpu.elevenlabs.model.user.User;
import net.andrewcpu.elevenlabs.model.voice.Voice;
import net.andrewcpu.elevenlabs.model.voice.VoiceSettings;
import net.andrewcpu.elevenlabs.requests.ElevenLabsRequest;
import net.andrewcpu.elevenlabs.requests.history.DeleteHistoryItemRequest;
import net.andrewcpu.elevenlabs.requests.history.GetHistoryItemAudioRequest;
import net.andrewcpu.elevenlabs.requests.history.GetHistoryItemByIdRequest;
import net.andrewcpu.elevenlabs.requests.history.GetHistoryRequest;
import net.andrewcpu.elevenlabs.requests.history.PostDownloadHistoryItemsRequest;
import net.andrewcpu.elevenlabs.requests.models.GetModelsRequest;
import net.andrewcpu.elevenlabs.requests.samples.DeleteSampleRequest;
import net.andrewcpu.elevenlabs.requests.samples.GetSampleRequest;
import net.andrewcpu.elevenlabs.requests.tts.PostTextToSpeechRequest;
import net.andrewcpu.elevenlabs.requests.tts.PostTextToSpeechStreamedRequest;
import net.andrewcpu.elevenlabs.requests.user.GetSubscriptionRequest;
import net.andrewcpu.elevenlabs.requests.user.GetUserRequest;
import net.andrewcpu.elevenlabs.requests.voices.DeleteVoiceRequest;
import net.andrewcpu.elevenlabs.requests.voices.GetDefaultVoiceSettingsRequest;
import net.andrewcpu.elevenlabs.requests.voices.GetVoiceRequest;
import net.andrewcpu.elevenlabs.requests.voices.GetVoiceSettingsRequest;
import net.andrewcpu.elevenlabs.requests.voices.GetVoicesRequest;
import net.andrewcpu.elevenlabs.requests.voices.PostAddVoiceRequest;
import net.andrewcpu.elevenlabs.requests.voices.PostEditVoiceRequest;
import net.andrewcpu.elevenlabs.requests.voices.PostEditVoiceSettingsRequest;
import net.andrewcpu.elevenlabs.util.ElevenNetworkUtil;

public class ElevenLabs {
    private static String API_KEY = null;

    public static String getApiKey() {
        return API_KEY;
    }

    public static void setApiKey(String apiKey) {
        API_KEY = apiKey;
    }

    private static <T> T sendRequest(ElevenLabsRequest<T> request) {
        return ElevenNetworkUtil.sendRequest(request.getType(), request.getEndpoint(), request.getPayload(), request.getResponseClass());
    }

    public static History getHistory() {
        return ElevenLabs.sendRequest(new GetHistoryRequest());
    }

    public static User getUser() {
        return ElevenLabs.sendRequest(new GetUserRequest());
    }

    public static Subscription getSubscription() {
        return ElevenLabs.sendRequest(new GetSubscriptionRequest());
    }

    public static HistoryItem getHistoryItem(String historyItemId) {
        return ElevenLabs.sendRequest(new GetHistoryItemByIdRequest(historyItemId));
    }

    public static String deleteHistoryItem(String historyItemId) {
        return ElevenLabs.sendRequest(new DeleteHistoryItemRequest(historyItemId));
    }

    public static File getHistoryItemAudio(String historyItemId) {
        return ElevenLabs.sendRequest(new GetHistoryItemAudioRequest(historyItemId));
    }

    public static File getHistoryItemAudio(String ... historyItemIds) {
        return ElevenLabs.sendRequest(new PostDownloadHistoryItemsRequest(historyItemIds));
    }

    public static String deleteSample(String voiceId, String sampleId) {
        return ElevenLabs.sendRequest(new DeleteSampleRequest(voiceId, sampleId));
    }

    public static File getAudioSample(String voiceId, String sampleId) {
        return ElevenLabs.sendRequest(new GetSampleRequest(voiceId, sampleId));
    }

    public static List<Voice> getVoices() {
        return ElevenLabs.sendRequest(new GetVoicesRequest()).getVoices();
    }

    public static VoiceSettings getDefaultVoiceSettings() {
        return ElevenLabs.sendRequest(new GetDefaultVoiceSettingsRequest());
    }

    public static VoiceSettings getVoiceSettings(String voiceId) {
        return ElevenLabs.sendRequest(new GetVoiceSettingsRequest(voiceId));
    }

    public static Voice getVoice(String voiceId) {
        return ElevenLabs.sendRequest(new GetVoiceRequest(voiceId));
    }

    public static Voice getVoice(String voiceId, boolean withSettings) {
        return ElevenLabs.sendRequest(new GetVoiceRequest(voiceId, withSettings));
    }

    public static String deleteVoice(String voiceId) {
        return ElevenLabs.sendRequest(new DeleteVoiceRequest(voiceId));
    }

    public static String editVoiceSettings(String voiceId, VoiceSettings settings) {
        return ElevenLabs.sendRequest(new PostEditVoiceSettingsRequest(voiceId, settings));
    }

    public static CreateVoiceResponse createVoice(String name, File[] files, String description, Map<String, String> labels) {
        return ElevenLabs.sendRequest(new PostAddVoiceRequest(name, files, description, labels));
    }

    public static String editVoice(String voiceId, String name, File[] files, String description, Map<String, String> labels) {
        return ElevenLabs.sendRequest(new PostEditVoiceRequest(voiceId, name, files, description, labels));
    }

    public static GenerationTypeModel[] getAvailableModels() {
        return ElevenLabs.sendRequest(new GetModelsRequest());
    }

    public static File generateTextToSpeech(String voiceId, String text, String modelId, VoiceSettings voiceSettings) {
        return ElevenLabs.sendRequest(new PostTextToSpeechRequest(voiceId, new TextToSpeechRequest(text, modelId, voiceSettings)));
    }

    public static InputStream generateTextToSpeechStreamed(String voiceId, String text, String modelId, VoiceSettings voiceSettings) {
        return ElevenLabs.sendRequest(new PostTextToSpeechStreamedRequest(voiceId, new TextToSpeechRequest(text, modelId, voiceSettings)));
    }
}

