/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.chars;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.amygdalum.stringsearchalgorithms.search.AbstractStringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.chars.MultiStringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.chars.SupportsCharClasses;
import net.amygdalum.util.io.CharProvider;
import net.amygdalum.util.text.CharAutomaton;
import net.amygdalum.util.text.CharConnectionAdaptor;
import net.amygdalum.util.text.CharMapping;
import net.amygdalum.util.text.CharNode;
import net.amygdalum.util.text.CharTask;
import net.amygdalum.util.text.CharUtils;
import net.amygdalum.util.text.CharWordGraphCompiler;
import net.amygdalum.util.text.CharWordSet;
import net.amygdalum.util.text.CharWordSetBuilder;
import net.amygdalum.util.text.JoinStrategy;
import net.amygdalum.util.text.StringUtils;
import net.amygdalum.util.text.linkeddawg.LinkedCharDawgCompiler;

public class SetBackwardOracleMatching
implements StringSearchAlgorithm {
    private CharMapping mapping;
    private CharWordSet<char[][]> trie;
    private int minLength;

    public SetBackwardOracleMatching(Collection<String> patterns) {
        this(patterns, CharMapping.IDENTITY);
    }

    public SetBackwardOracleMatching(Collection<String> patterns, CharMapping mapping) {
        List charpatterns = StringUtils.toCharArray(patterns);
        this.mapping = mapping;
        this.minLength = CharUtils.minLength((List)charpatterns);
        this.trie = SetBackwardOracleMatching.computeTrie(this.normalized(mapping, charpatterns), this.minLength, mapping);
    }

    private char[][] normalized(CharMapping mapping, List<char[]> charpatterns) {
        ArrayList<char[]> normalized = new ArrayList<char[]>(charpatterns.size());
        for (char[] cs : charpatterns) {
            normalized.add(mapping.normalized(cs));
        }
        return (char[][])normalized.toArray((T[])new char[0][]);
    }

    private static CharWordSet<char[][]> computeTrie(char[][] charpatterns, int length, CharMapping mapping) {
        CharWordSetBuilder builder = new CharWordSetBuilder((CharWordGraphCompiler)new LinkedCharDawgCompiler(), (JoinStrategy)new MergePatterns());
        for (char[] pattern : charpatterns) {
            char[] prefix = Arrays.copyOfRange(pattern, 0, length);
            char[] reversePrefix = CharUtils.revert((char[])prefix);
            char[] suffix = Arrays.copyOfRange(pattern, length, pattern.length);
            builder.extend(reversePrefix, (Object)new char[][]{prefix, suffix});
        }
        builder.work((CharTask)new BuildOracle());
        builder.work((CharTask)new UseCharClasses(mapping));
        return (CharWordSet)builder.build();
    }

    @Override
    public StringFinder createFinder(CharProvider chars, StringFinderOption ... options) {
        return new Finder(this.trie, this.minLength, this.mapping, chars, options);
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements MultiStringSearchAlgorithmFactory,
    SupportsCharClasses {
        private CharMapping mapping;

        @Override
        public void enableCharClasses(CharMapping mapping) {
            this.mapping = mapping;
        }

        @Override
        public StringSearchAlgorithm of(Collection<String> patterns) {
            if (this.mapping == null) {
                return new SetBackwardOracleMatching(patterns);
            }
            return new SetBackwardOracleMatching(patterns, this.mapping);
        }
    }

    private static class Finder
    extends AbstractStringFinder {
        private final int minLength;
        private final int lookahead;
        private final CharMapping mapping;
        private CharProvider chars;
        private CharAutomaton<char[][]> cursor;
        private Queue<StringMatch> buffer;

        public Finder(CharWordSet<char[][]> trie, int minLength, CharMapping mapping, CharProvider chars, StringFinderOption ... options) {
            super(options);
            this.minLength = minLength;
            this.lookahead = minLength - 1;
            this.mapping = mapping;
            this.chars = chars;
            this.cursor = trie.cursor();
            this.buffer = new LinkedList<StringMatch>();
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.chars.current()) {
                this.chars.move(pos);
            }
            this.buffer.clear();
        }

        @Override
        public StringMatch findNext() {
            if (!this.buffer.isEmpty()) {
                return this.buffer.remove();
            }
            while (!this.chars.finished(this.lookahead)) {
                char[][] patterns;
                char[] prefix;
                int j;
                this.cursor.reset();
                boolean success = true;
                for (j = this.lookahead; j >= 0 && success; --j) {
                    success = this.cursor.accept(this.chars.lookahead(j));
                }
                long currentWindowStart = this.chars.current();
                long currentPos = currentWindowStart + (long)j + 1L;
                long currentWindowEnd = currentWindowStart + (long)this.minLength;
                char[] matchedPrefix = this.chars.between(currentPos, currentWindowEnd);
                if (success && j < 0 && Arrays.equals(prefix = (patterns = (char[][])this.cursor.iterator().next())[0], this.mapping.normalized(matchedPrefix))) {
                    for (int i = 1; i < patterns.length; ++i) {
                        char[] matchedSuffix;
                        char[] suffix = patterns[i];
                        long currentWordEnd = currentWindowEnd + (long)suffix.length;
                        if (this.chars.finished((int)(currentWordEnd - currentWindowStart - 1L)) || !Arrays.equals(suffix, this.mapping.normalized(matchedSuffix = this.chars.between(currentWindowEnd, currentWordEnd)))) continue;
                        this.buffer.add(this.createMatch(currentWindowStart, currentWordEnd));
                    }
                    this.chars.next();
                    if (this.buffer.isEmpty()) continue;
                    return this.buffer.remove();
                }
                if (j <= 0) {
                    this.chars.next();
                    continue;
                }
                this.chars.forward(j + 2);
            }
            return null;
        }

        private StringMatch createMatch(long start, long end) {
            String s = this.chars.slice(start, end);
            return new StringMatch(start, end, s);
        }
    }

    public static class UseCharClasses
    implements CharTask<char[][]> {
        private CharMapping mapping;
        private Set<CharNode<char[][]>> done;

        public UseCharClasses(CharMapping mapping) {
            this.mapping = mapping;
            this.done = new HashSet<CharNode<char[][]>>();
        }

        public List<CharNode<char[][]>> init(CharNode<char[][]> root) {
            if (this.mapping == CharMapping.IDENTITY) {
                return Collections.emptyList();
            }
            return Arrays.asList(root);
        }

        public List<CharNode<char[][]>> process(CharNode<char[][]> node) {
            ArrayList<CharNode<char[][]>> nexts = new ArrayList<CharNode<char[][]>>();
            for (char c : node.getAlternatives()) {
                CharNode next = node.nextNode(c);
                for (char cc : this.mapping.map(c)) {
                    this.addNextNode(node, cc, (CharNode<char[][]>)next);
                }
                if (!this.done.add((CharNode<char[][]>)next)) continue;
                nexts.add((CharNode<char[][]>)next);
            }
            return nexts;
        }

        private void addNextNode(CharNode<char[][]> node, char c, CharNode<char[][]> next) {
            ((CharConnectionAdaptor)node).addNextNode(c, next);
        }
    }

    public static class BuildOracle
    implements CharTask<char[][]> {
        private Map<CharNode<char[][]>, CharNode<char[][]>> oracle = new IdentityHashMap<CharNode<char[][]>, CharNode<char[][]>>();
        private CharNode<char[][]> init;

        public List<CharNode<char[][]>> init(CharNode<char[][]> root) {
            this.init = root;
            return Arrays.asList(root);
        }

        public List<CharNode<char[][]>> process(CharNode<char[][]> node) {
            ArrayList<CharNode<char[][]>> nexts = new ArrayList<CharNode<char[][]>>();
            for (char c : node.getAlternatives()) {
                CharNode current = node.nextNode(c);
                CharNode<char[][]> down = this.oracle.get(node);
                while (down != null) {
                    CharNode next = down.nextNode(c);
                    if (next != null) {
                        this.oracle.put((CharNode<char[][]>)current, (CharNode<char[][]>)next);
                        break;
                    }
                    this.addNextNode(down, c, (CharNode<char[][]>)current);
                    down = this.oracle.get(down);
                }
                if (down == null) {
                    this.oracle.put((CharNode<char[][]>)current, this.init);
                }
                nexts.add((CharNode<char[][]>)current);
            }
            return nexts;
        }

        private void addNextNode(CharNode<char[][]> node, char c, CharNode<char[][]> next) {
            ((CharConnectionAdaptor)node).addNextNode(c, next);
        }
    }

    public static class MergePatterns
    implements JoinStrategy<char[][]> {
        public char[][] join(char[][] existing, char[][] next) {
            int i;
            if (existing == null) {
                return next;
            }
            char[][] result = new char[existing.length + 1][];
            char[] insert = next[1];
            for (i = 1; i < existing.length && existing[i].length > insert.length; ++i) {
            }
            System.arraycopy(existing, 0, result, 0, i);
            result[i] = insert;
            if (i < existing.length) {
                System.arraycopy(existing, i, result, i + 1, existing.length - i);
            }
            return result;
        }
    }
}

