/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.chars;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.amygdalum.stringsearchalgorithms.search.BufferedStringFinder;
import net.amygdalum.stringsearchalgorithms.search.MatchOption;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.chars.MultiStringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithm;
import net.amygdalum.util.io.CharProvider;
import net.amygdalum.util.text.AttachmentAdaptor;
import net.amygdalum.util.text.CharAutomaton;
import net.amygdalum.util.text.CharFallbackAdaptor;
import net.amygdalum.util.text.CharNode;
import net.amygdalum.util.text.CharTask;
import net.amygdalum.util.text.CharUtils;
import net.amygdalum.util.text.CharWordGraphCompiler;
import net.amygdalum.util.text.CharWordSet;
import net.amygdalum.util.text.CharWordSetBuilder;
import net.amygdalum.util.text.StringUtils;
import net.amygdalum.util.text.doublearraytrie.DoubleArrayCharFallbackTrieCompiler;

public class AhoCorasick
implements StringSearchAlgorithm {
    private CharWordSet<String> trie;
    private int minLength;

    public AhoCorasick(Collection<String> patterns) {
        List charpatterns = StringUtils.toCharArray(patterns);
        this.trie = AhoCorasick.computeTrie(charpatterns);
        this.minLength = CharUtils.minLength((List)charpatterns);
    }

    private static CharWordSet<String> computeTrie(List<char[]> charpatterns) {
        CharWordSetBuilder builder = new CharWordSetBuilder((CharWordGraphCompiler)new DoubleArrayCharFallbackTrieCompiler());
        for (char[] pattern : charpatterns) {
            builder.extend(pattern, (Object)new String(pattern));
        }
        return (CharWordSet)builder.work((CharTask)new FallbackLinks()).build();
    }

    @Override
    public StringFinder createFinder(CharProvider chars, StringFinderOption ... options) {
        if (MatchOption.LONGEST_MATCH.in(options)) {
            return new LongestMatchFinder(this.trie, chars, options);
        }
        return new NextMatchFinder(this.trie, chars, options);
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements MultiStringSearchAlgorithmFactory {
        @Override
        public StringSearchAlgorithm of(Collection<String> patterns) {
            return new AhoCorasick(patterns);
        }
    }

    private static class LongestMatchFinder
    extends Finder {
        public LongestMatchFinder(CharWordSet<String> trie, CharProvider chars, StringFinderOption ... options) {
            super(trie, chars, options);
        }

        @Override
        public StringMatch findNext() {
            while (!this.chars.finished()) {
                char c = this.chars.next();
                boolean success = this.cursor.lookahead(c);
                if (!success && !this.isBufferEmpty()) {
                    this.chars.prev();
                    break;
                }
                success = this.cursor.accept(c);
                if (!success) {
                    this.cursor.reset();
                }
                if (!this.cursor.hasAttachments()) continue;
                this.push(this.createMatches(this.chars.current()));
            }
            return this.longestLeftMost();
        }
    }

    private static class NextMatchFinder
    extends Finder {
        public NextMatchFinder(CharWordSet<String> trie, CharProvider chars, StringFinderOption ... options) {
            super(trie, chars, options);
        }

        @Override
        public StringMatch findNext() {
            if (!this.isBufferEmpty()) {
                return this.leftMost();
            }
            while (!this.chars.finished()) {
                char c = this.chars.next();
                boolean success = this.cursor.accept(c);
                if (!success) {
                    this.cursor.reset();
                }
                if (!this.cursor.hasAttachments()) continue;
                this.push(this.createMatches(this.chars.current()));
                return this.leftMost();
            }
            return null;
        }
    }

    private static abstract class Finder
    extends BufferedStringFinder {
        protected CharProvider chars;
        protected CharAutomaton<String> cursor;

        public Finder(CharWordSet<String> trie, CharProvider chars, StringFinderOption ... options) {
            super(options);
            this.chars = chars;
            this.cursor = trie.cursor();
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.chars.current()) {
                this.chars.move(pos);
            }
            this.cursor.reset();
            this.clear();
        }

        protected List<StringMatch> createMatches(long end) {
            ArrayList<StringMatch> matches = new ArrayList<StringMatch>();
            for (String currentMatch : this.cursor) {
                long start = end - (long)currentMatch.length();
                StringMatch nextMatch = this.createMatch(start, end);
                if (matches.contains(nextMatch)) continue;
                matches.add(nextMatch);
            }
            return matches;
        }

        private StringMatch createMatch(long start, long end) {
            String s = this.chars.slice(start, end);
            return new StringMatch(start, end, s);
        }
    }

    private static class FallbackLinks
    implements CharTask<String> {
        private CharNode<String> root;

        private FallbackLinks() {
        }

        public List<CharNode<String>> init(CharNode<String> root) {
            this.root = root;
            CharFallbackAdaptor.setFallback(root, null);
            return Arrays.asList(root);
        }

        public List<CharNode<String>> process(CharNode<String> node) {
            ArrayList<CharNode<String>> nexts = new ArrayList<CharNode<String>>();
            for (char c : node.getAlternatives()) {
                CharNode next = node.nextNode(c);
                CharNode down = CharFallbackAdaptor.getFallback(node);
                while (down != null) {
                    CharNode nextNode = down.nextNode(c);
                    if (nextNode != null) {
                        String attachment;
                        CharFallbackAdaptor.setFallback((Object)next, (CharNode)nextNode);
                        if (next.getAttached() != null || (attachment = (String)nextNode.getAttached()) == null) break;
                        AttachmentAdaptor.attach((Object)next, (Object)attachment);
                        break;
                    }
                    down = CharFallbackAdaptor.getFallback((Object)down);
                }
                if (down == null) {
                    CharFallbackAdaptor.setFallback((Object)next, this.root);
                }
                nexts.add((CharNode<String>)next);
            }
            return nexts;
        }
    }
}

