/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.bytes;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.amygdalum.stringsearchalgorithms.search.AbstractStringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.bytes.MultiStringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.bytes.StringSearchAlgorithm;
import net.amygdalum.util.io.ByteProvider;
import net.amygdalum.util.text.ByteAutomaton;
import net.amygdalum.util.text.ByteConnectionAdaptor;
import net.amygdalum.util.text.ByteNode;
import net.amygdalum.util.text.ByteString;
import net.amygdalum.util.text.ByteTask;
import net.amygdalum.util.text.ByteUtils;
import net.amygdalum.util.text.ByteWordGraphCompiler;
import net.amygdalum.util.text.ByteWordSet;
import net.amygdalum.util.text.ByteWordSetBuilder;
import net.amygdalum.util.text.JoinStrategy;
import net.amygdalum.util.text.StringUtils;
import net.amygdalum.util.text.linkeddawg.LinkedByteDawgCompiler;

public class SetBackwardOracleMatching
implements StringSearchAlgorithm {
    private ByteWordSet<byte[][]> trie;
    private int minLength;

    public SetBackwardOracleMatching(Collection<String> patterns, Charset charset) {
        byte[][] bytepatterns = (byte[][])StringUtils.toByteArray(patterns, (Charset)charset).toArray((T[])new byte[0][]);
        this.minLength = ByteUtils.minLength((byte[][])bytepatterns);
        this.trie = SetBackwardOracleMatching.computeTrie(bytepatterns, this.minLength);
    }

    private static ByteWordSet<byte[][]> computeTrie(byte[][] bytepatterns, int length) {
        ByteWordSetBuilder builder = new ByteWordSetBuilder((ByteWordGraphCompiler)new LinkedByteDawgCompiler(), (JoinStrategy)new MergePatterns());
        for (byte[] pattern : bytepatterns) {
            byte[] prefix = Arrays.copyOfRange(pattern, 0, length);
            byte[] reversePrefix = ByteUtils.revert((byte[])prefix);
            byte[] suffix = Arrays.copyOfRange(pattern, length, pattern.length);
            builder.extend(reversePrefix, (Object)new byte[][]{prefix, suffix});
        }
        builder.work((ByteTask)new BuildOracle());
        return (ByteWordSet)builder.build();
    }

    @Override
    public StringFinder createFinder(ByteProvider bytes, StringFinderOption ... options) {
        return new Finder(this.trie, this.minLength, bytes, options);
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements MultiStringSearchAlgorithmFactory {
        private Charset charset;

        public Factory() {
            this(StandardCharsets.UTF_16LE);
        }

        public Factory(Charset charset) {
            this.charset = charset;
        }

        @Override
        public StringSearchAlgorithm of(Collection<String> patterns) {
            return new SetBackwardOracleMatching(patterns, this.charset);
        }
    }

    private static class Finder
    extends AbstractStringFinder {
        private final int minLength;
        private final int lookahead;
        private ByteProvider bytes;
        private ByteAutomaton<byte[][]> cursor;
        private Queue<StringMatch> buffer;

        public Finder(ByteWordSet<byte[][]> trie, int minLength, ByteProvider bytes, StringFinderOption ... options) {
            super(options);
            this.minLength = minLength;
            this.lookahead = minLength - 1;
            this.bytes = bytes;
            this.cursor = trie.cursor();
            this.buffer = new LinkedList<StringMatch>();
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.bytes.current()) {
                this.bytes.move(pos);
            }
            this.buffer.clear();
        }

        @Override
        public StringMatch findNext() {
            if (!this.buffer.isEmpty()) {
                return this.buffer.remove();
            }
            while (!this.bytes.finished(this.lookahead)) {
                byte[][] patterns;
                byte[] prefix;
                int j;
                this.cursor.reset();
                boolean success = true;
                for (j = this.lookahead; j >= 0 && success; --j) {
                    success = this.cursor.accept(this.bytes.lookahead(j));
                }
                long currentWindowStart = this.bytes.current();
                long currentPos = currentWindowStart + (long)j + 1L;
                long currentWindowEnd = currentWindowStart + (long)this.minLength;
                byte[] matchedPrefix = this.bytes.between(currentPos, currentWindowEnd);
                if (success && j < 0 && Arrays.equals(prefix = (patterns = (byte[][])this.cursor.iterator().next())[0], matchedPrefix)) {
                    for (int i = 1; i < patterns.length; ++i) {
                        byte[] matchedSuffix;
                        byte[] suffix = patterns[i];
                        long currentWordEnd = currentWindowEnd + (long)suffix.length;
                        if (this.bytes.finished((int)(currentWordEnd - currentWindowStart - 1L)) || !Arrays.equals(suffix, matchedSuffix = this.bytes.between(currentWindowEnd, currentWordEnd))) continue;
                        this.buffer.add(this.createMatch(currentWindowStart, currentWordEnd));
                    }
                    this.bytes.next();
                    if (this.buffer.isEmpty()) continue;
                    return this.buffer.remove();
                }
                if (j <= 0) {
                    this.bytes.next();
                    continue;
                }
                this.bytes.forward(j + 1);
            }
            return null;
        }

        private StringMatch createMatch(long start, long end) {
            ByteString s = this.bytes.slice(start, end);
            return new StringMatch(start, end, s.getString());
        }
    }

    public static class BuildOracle
    implements ByteTask<byte[][]> {
        private Map<ByteNode<byte[][]>, ByteNode<byte[][]>> oracle = new IdentityHashMap<ByteNode<byte[][]>, ByteNode<byte[][]>>();
        private ByteNode<byte[][]> init;

        public List<ByteNode<byte[][]>> init(ByteNode<byte[][]> root) {
            this.init = root;
            return Arrays.asList(root);
        }

        public List<ByteNode<byte[][]>> process(ByteNode<byte[][]> node) {
            ArrayList<ByteNode<byte[][]>> nexts = new ArrayList<ByteNode<byte[][]>>();
            for (byte b : node.getAlternatives()) {
                ByteNode current = node.nextNode(b);
                ByteNode<byte[][]> down = this.oracle.get(node);
                while (down != null) {
                    ByteNode next = down.nextNode(b);
                    if (next != null) {
                        this.oracle.put((ByteNode<byte[][]>)current, (ByteNode<byte[][]>)next);
                        break;
                    }
                    this.addNextNode(down, b, (ByteNode<byte[][]>)current);
                    down = this.oracle.get(down);
                }
                if (down == null) {
                    this.oracle.put((ByteNode<byte[][]>)current, this.init);
                }
                nexts.add((ByteNode<byte[][]>)current);
            }
            return nexts;
        }

        private void addNextNode(ByteNode<byte[][]> node, byte b, ByteNode<byte[][]> next) {
            ((ByteConnectionAdaptor)node).addNextNode(b, next);
        }
    }

    public static class MergePatterns
    implements JoinStrategy<byte[][]> {
        public byte[][] join(byte[][] existing, byte[][] next) {
            int i;
            if (existing == null) {
                return next;
            }
            byte[][] result = new byte[existing.length + 1][];
            byte[] insert = next[1];
            for (i = 1; i < existing.length && existing[i].length > insert.length; ++i) {
            }
            System.arraycopy(existing, 0, result, 0, i);
            result[i] = insert;
            if (i < existing.length) {
                System.arraycopy(existing, i, result, i + 1, existing.length - i);
            }
            return result;
        }
    }
}

