/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.bytes;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.amygdalum.stringsearchalgorithms.search.AbstractStringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.bytes.ByteShift;
import net.amygdalum.stringsearchalgorithms.search.bytes.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.bytes.StringSearchAlgorithmFactory;
import net.amygdalum.util.io.ByteProvider;
import net.amygdalum.util.text.ByteEncoding;
import net.amygdalum.util.text.ByteString;

public class Horspool
implements StringSearchAlgorithm {
    private byte[] pattern;
    private int patternLength;
    private ByteShift byteShift;

    public Horspool(String pattern, Charset charset) {
        this.pattern = ByteEncoding.encode((String)pattern, (Charset)charset);
        this.patternLength = this.pattern.length;
        this.byteShift = Horspool.computeShift(this.pattern);
    }

    private static ByteShift computeShift(byte[] pattern) {
        return new QuickShift(pattern);
    }

    @Override
    public int getPatternLength() {
        return this.patternLength;
    }

    @Override
    public StringFinder createFinder(ByteProvider bytes, StringFinderOption ... options) {
        return new Finder(bytes, options);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static class QuickShift
    implements ByteShift {
        private int[] byteShift;

        public QuickShift(byte[] pattern) {
            this.byteShift = QuickShift.computeByteShift(pattern);
        }

        private static int[] computeByteShift(byte[] pattern) {
            int i;
            int[] bytes = new int[256];
            for (i = 0; i < bytes.length; ++i) {
                bytes[i] = pattern.length;
            }
            for (i = 0; i < pattern.length - 1; ++i) {
                bytes[pattern[i] & 0xFF] = pattern.length - i - 1;
            }
            return bytes;
        }

        @Override
        public int getShift(byte b) {
            return this.byteShift[b & 0xFF];
        }
    }

    public static class Factory
    implements StringSearchAlgorithmFactory {
        private Charset charset;

        public Factory() {
            this(StandardCharsets.UTF_16LE);
        }

        public Factory(Charset charset) {
            this.charset = charset;
        }

        @Override
        public StringSearchAlgorithm of(String pattern) {
            return new Horspool(pattern, this.charset);
        }
    }

    private class Finder
    extends AbstractStringFinder {
        private ByteProvider bytes;

        public Finder(ByteProvider bytes, StringFinderOption ... options) {
            super(options);
            this.bytes = bytes;
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.bytes.current()) {
                this.bytes.move(pos);
            }
        }

        @Override
        public StringMatch findNext() {
            int lookahead = Horspool.this.patternLength - 1;
            block0: while (!this.bytes.finished(lookahead)) {
                int patternPointer = lookahead;
                byte nextByte = this.bytes.lookahead(patternPointer);
                if (Horspool.this.pattern[patternPointer] == nextByte) {
                    while (patternPointer > 0) {
                        if (Horspool.this.pattern[--patternPointer] == this.bytes.lookahead(patternPointer)) continue;
                        this.bytes.forward(Horspool.this.byteShift.getShift(nextByte));
                        continue block0;
                    }
                    if (patternPointer != 0) continue;
                    StringMatch match = this.createMatch();
                    this.bytes.forward(Horspool.this.byteShift.getShift(nextByte));
                    return match;
                }
                this.bytes.forward(Horspool.this.byteShift.getShift(nextByte));
            }
            return null;
        }

        private StringMatch createMatch() {
            long start = this.bytes.current();
            long end = start + (long)Horspool.this.patternLength;
            ByteString s = this.bytes.slice(start, end);
            return new StringMatch(start, end, s.getString());
        }
    }
}

