/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.patternsearch.chars;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.amygdalum.regexparser.AlternativesNode;
import net.amygdalum.regexparser.AnyCharNode;
import net.amygdalum.regexparser.BoundedLoopNode;
import net.amygdalum.regexparser.CharClassNode;
import net.amygdalum.regexparser.CompClassNode;
import net.amygdalum.regexparser.ConcatNode;
import net.amygdalum.regexparser.EmptyNode;
import net.amygdalum.regexparser.GroupNode;
import net.amygdalum.regexparser.OptionalNode;
import net.amygdalum.regexparser.RangeCharNode;
import net.amygdalum.regexparser.RegexNode;
import net.amygdalum.regexparser.RegexNodeVisitor;
import net.amygdalum.regexparser.SingleCharNode;
import net.amygdalum.regexparser.SpecialCharClassNode;
import net.amygdalum.regexparser.StringNode;
import net.amygdalum.regexparser.UnboundedLoopNode;

public class GlushkovNormalizer
implements RegexNodeVisitor<RegexNode> {
    public RegexNode visitAlternatives(AlternativesNode node) {
        List subNodes = node.getSubNodes();
        List<RegexNode> newNodes = this.accept(subNodes);
        if (newNodes.equals(subNodes)) {
            return node;
        }
        return AlternativesNode.anyOf((RegexNode[])newNodes.toArray(new RegexNode[0]));
    }

    public RegexNode visitAnyChar(AnyCharNode node) {
        return AlternativesNode.anyOf((List)node.toCharNodes());
    }

    public RegexNode visitCharClass(CharClassNode node) {
        return AlternativesNode.anyOf((List)node.toCharNodes());
    }

    public RegexNode visitCompClass(CompClassNode node) {
        return AlternativesNode.anyOf((List)node.toCharNodes());
    }

    public RegexNode visitConcat(ConcatNode node) {
        List subNodes = node.getSubNodes();
        List<RegexNode> newNodes = this.accept(subNodes);
        if (newNodes.equals(subNodes)) {
            return node;
        }
        return ConcatNode.inSequence((RegexNode[])newNodes.toArray(new RegexNode[0]));
    }

    public RegexNode visitEmpty(EmptyNode node) {
        return node;
    }

    public RegexNode visitGroup(GroupNode node) {
        RegexNode subNode = node.getSubNode();
        RegexNode newNode = (RegexNode)subNode.accept((RegexNodeVisitor)this);
        if (newNode == subNode) {
            return node;
        }
        return new GroupNode(newNode);
    }

    public RegexNode visitBoundedLoop(BoundedLoopNode node) {
        int i;
        RegexNode subNode = node.getSubNode();
        RegexNode newNode = (RegexNode)subNode.accept((RegexNodeVisitor)this);
        LinkedList<Object> nodes = new LinkedList<Object>();
        if (node.getFrom() > 0) {
            nodes.add(newNode);
            for (i = 1; i < node.getFrom(); ++i) {
                nodes.add(newNode.clone());
            }
        }
        for (i = node.getFrom(); i < node.getTo(); ++i) {
            nodes.add(OptionalNode.optional((RegexNode)newNode.clone()));
        }
        if (nodes.isEmpty()) {
            return new EmptyNode();
        }
        if (nodes.size() == 1) {
            if (nodes.get(0) == subNode) {
                return node;
            }
            return ConcatNode.inSequence((RegexNode[])new RegexNode[]{ConcatNode.inSequence((RegexNode[])nodes.toArray(new RegexNode[0]))});
        }
        return ConcatNode.inSequence((RegexNode[])new RegexNode[]{ConcatNode.inSequence((RegexNode[])nodes.toArray(new RegexNode[0]))});
    }

    public RegexNode visitUnboundedLoop(UnboundedLoopNode node) {
        RegexNode subNode = node.getSubNode();
        RegexNode newNode = (RegexNode)subNode.accept((RegexNodeVisitor)this);
        LinkedList<RegexNode> prefix = new LinkedList<RegexNode>();
        if (node.getFrom() > 0) {
            for (int i = 0; i < node.getFrom(); ++i) {
                prefix.add(newNode.clone());
            }
        }
        if (prefix.isEmpty()) {
            if (newNode == subNode) {
                return node;
            }
            return UnboundedLoopNode.star((RegexNode)newNode);
        }
        return ConcatNode.inSequence((RegexNode[])new RegexNode[]{ConcatNode.inSequence((RegexNode[])prefix.toArray(new RegexNode[0])), UnboundedLoopNode.star((RegexNode)newNode)});
    }

    public RegexNode visitOptional(OptionalNode node) {
        RegexNode subNode = node.getSubNode();
        RegexNode newNode = (RegexNode)subNode.accept((RegexNodeVisitor)this);
        if (newNode == subNode) {
            return node;
        }
        return OptionalNode.optional((RegexNode)newNode);
    }

    public RegexNode visitRangeChar(RangeCharNode node) {
        return node;
    }

    public RegexNode visitSingleChar(SingleCharNode node) {
        return node;
    }

    public RegexNode visitSpecialCharClass(SpecialCharClassNode node) {
        return node;
    }

    public RegexNode visitString(StringNode node) {
        char[] chars = node.getValue().toCharArray();
        RegexNode[] nodes = new RegexNode[chars.length];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = new SingleCharNode(chars[i]);
        }
        return ConcatNode.inSequence((RegexNode[])nodes);
    }

    private List<RegexNode> accept(List<RegexNode> subNodes) {
        ArrayList<RegexNode> newNodes = new ArrayList<RegexNode>(subNodes.size());
        for (RegexNode subNode : subNodes) {
            RegexNode newNode = (RegexNode)subNode.accept((RegexNodeVisitor)this);
            newNodes.add(newNode);
        }
        return newNodes;
    }
}

