/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.chars;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.amygdalum.stringsearchalgorithms.search.AbstractStringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.chars.MultiStringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.chars.SupportsCharClasses;
import net.amygdalum.util.io.CharProvider;
import net.amygdalum.util.text.CharAutomaton;
import net.amygdalum.util.text.CharConnectionAdaptor;
import net.amygdalum.util.text.CharMapping;
import net.amygdalum.util.text.CharNode;
import net.amygdalum.util.text.CharTask;
import net.amygdalum.util.text.CharUtils;
import net.amygdalum.util.text.CharWordGraphCompiler;
import net.amygdalum.util.text.CharWordSet;
import net.amygdalum.util.text.CharWordSetBuilder;
import net.amygdalum.util.text.JoinStrategy;
import net.amygdalum.util.text.StringUtils;
import net.amygdalum.util.text.linkeddawg.LinkedCharDawgCompiler;

public class SetBackwardOracleMatching
implements StringSearchAlgorithm {
    private CharMapping mapping;
    private CharWordSet<List<char[]>> trie;
    private int minLength;

    public SetBackwardOracleMatching(Collection<String> patterns) {
        this(patterns, CharMapping.IDENTITY);
    }

    public SetBackwardOracleMatching(Collection<String> patterns, CharMapping mapping) {
        List charpatterns = StringUtils.toCharArray(patterns);
        this.mapping = mapping;
        this.minLength = CharUtils.minLength((List)charpatterns);
        this.trie = SetBackwardOracleMatching.computeTrie(this.normalized(mapping, charpatterns), this.minLength, mapping);
    }

    private List<char[]> normalized(CharMapping mapping, List<char[]> charpatterns) {
        ArrayList<char[]> normalized = new ArrayList<char[]>(charpatterns.size());
        for (char[] cs : charpatterns) {
            normalized.add(mapping.normalized(cs));
        }
        return normalized;
    }

    private static CharWordSet<List<char[]>> computeTrie(List<char[]> charpatterns, int length, CharMapping mapping) {
        CharWordSetBuilder builder = new CharWordSetBuilder((CharWordGraphCompiler)new LinkedCharDawgCompiler(), (JoinStrategy)new MergePatterns());
        for (char[] pattern : charpatterns) {
            char[] prefix = Arrays.copyOfRange(pattern, 0, length);
            char[] reversePrefix = CharUtils.revert((char[])prefix);
            char[] suffix = Arrays.copyOfRange(pattern, length, pattern.length);
            builder.extend(reversePrefix, Arrays.asList(prefix, suffix));
        }
        builder.work((CharTask)new BuildOracle());
        builder.work((CharTask)new UseCharClasses(mapping));
        return (CharWordSet)builder.build();
    }

    @Override
    public StringFinder createFinder(CharProvider chars, StringFinderOption ... options) {
        return new Finder(this.trie, this.minLength, this.mapping, chars, options);
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements MultiStringSearchAlgorithmFactory,
    SupportsCharClasses {
        private CharMapping mapping;

        @Override
        public void enableCharClasses(CharMapping mapping) {
            this.mapping = mapping;
        }

        @Override
        public StringSearchAlgorithm of(Collection<String> patterns) {
            if (this.mapping == null) {
                return new SetBackwardOracleMatching(patterns);
            }
            return new SetBackwardOracleMatching(patterns, this.mapping);
        }
    }

    private static class Finder
    extends AbstractStringFinder {
        private final int minLength;
        private final int lookahead;
        private final CharMapping mapping;
        private CharProvider chars;
        private CharAutomaton<List<char[]>> cursor;
        private Queue<StringMatch> buffer;

        public Finder(CharWordSet<List<char[]>> trie, int minLength, CharMapping mapping, CharProvider chars, StringFinderOption ... options) {
            super(options);
            this.minLength = minLength;
            this.lookahead = minLength - 1;
            this.mapping = mapping;
            this.chars = chars;
            this.cursor = trie.cursor();
            this.buffer = new LinkedList<StringMatch>();
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.chars.current()) {
                this.chars.move(pos);
            }
            this.buffer.clear();
        }

        @Override
        public StringMatch findNext() {
            if (!this.buffer.isEmpty()) {
                return this.buffer.remove();
            }
            while (!this.chars.finished(this.lookahead)) {
                List patterns;
                Iterator iPatterns;
                char[] prefix;
                int j;
                this.cursor.reset();
                boolean success = true;
                for (j = this.lookahead; j >= 0 && success; --j) {
                    success = this.cursor.accept(this.chars.lookahead(j));
                }
                long currentWindowStart = this.chars.current();
                long currentPos = currentWindowStart + (long)j + 1L;
                long currentWindowEnd = currentWindowStart + (long)this.minLength;
                char[] matchedPrefix = this.chars.between(currentPos, currentWindowEnd);
                if (success && j < 0 && Arrays.equals(prefix = (char[])(iPatterns = (patterns = (List)this.cursor.iterator().next()).iterator()).next(), this.mapping.normalized(matchedPrefix))) {
                    while (iPatterns.hasNext()) {
                        char[] matchedSuffix;
                        char[] suffix = (char[])iPatterns.next();
                        long currentWordEnd = currentWindowEnd + (long)suffix.length;
                        if (this.chars.finished((int)(currentWordEnd - currentWindowStart - 1L)) || !Arrays.equals(suffix, this.mapping.normalized(matchedSuffix = this.chars.between(currentWindowEnd, currentWordEnd)))) continue;
                        this.buffer.add(this.createMatch(currentWindowStart, currentWordEnd));
                    }
                    this.chars.next();
                    if (this.buffer.isEmpty()) continue;
                    return this.buffer.remove();
                }
                if (j <= 0) {
                    this.chars.next();
                    continue;
                }
                this.chars.forward(j + 2);
            }
            return null;
        }

        private StringMatch createMatch(long start, long end) {
            String s = this.chars.slice(start, end);
            return new StringMatch(start, end, s);
        }
    }

    public static class UseCharClasses
    implements CharTask<List<char[]>> {
        private CharMapping mapping;
        private Set<CharNode<List<char[]>>> done;

        public UseCharClasses(CharMapping mapping) {
            this.mapping = mapping;
            this.done = new HashSet<CharNode<List<char[]>>>();
        }

        public List<CharNode<List<char[]>>> init(CharNode<List<char[]>> root) {
            if (this.mapping == CharMapping.IDENTITY) {
                return Collections.emptyList();
            }
            return Arrays.asList(root);
        }

        public List<CharNode<List<char[]>>> process(CharNode<List<char[]>> node) {
            ArrayList<CharNode<List<char[]>>> nexts = new ArrayList<CharNode<List<char[]>>>();
            for (char c : node.getAlternatives()) {
                CharNode next = node.nextNode(c);
                for (char cc : this.mapping.map(c)) {
                    this.addNextNode(node, cc, (CharNode<List<char[]>>)next);
                }
                if (!this.done.add((CharNode<List<char[]>>)next)) continue;
                nexts.add((CharNode<List<char[]>>)next);
            }
            return nexts;
        }

        private void addNextNode(CharNode<List<char[]>> node, char c, CharNode<List<char[]>> next) {
            ((CharConnectionAdaptor)node).addNextNode(c, next);
        }
    }

    public static class BuildOracle
    implements CharTask<List<char[]>> {
        private Map<CharNode<List<char[]>>, CharNode<List<char[]>>> oracle = new IdentityHashMap<CharNode<List<char[]>>, CharNode<List<char[]>>>();
        private CharNode<List<char[]>> init;

        public List<CharNode<List<char[]>>> init(CharNode<List<char[]>> root) {
            this.init = root;
            return Arrays.asList(root);
        }

        public List<CharNode<List<char[]>>> process(CharNode<List<char[]>> node) {
            ArrayList<CharNode<List<char[]>>> nexts = new ArrayList<CharNode<List<char[]>>>();
            for (char c : node.getAlternatives()) {
                CharNode current = node.nextNode(c);
                CharNode<List<char[]>> down = this.oracle.get(node);
                while (down != null) {
                    CharNode next = down.nextNode(c);
                    if (next != null) {
                        this.oracle.put((CharNode<List<char[]>>)current, (CharNode<List<char[]>>)next);
                        break;
                    }
                    this.addNextNode(down, c, (CharNode<List<char[]>>)current);
                    down = this.oracle.get(down);
                }
                if (down == null) {
                    this.oracle.put((CharNode<List<char[]>>)current, this.init);
                }
                nexts.add((CharNode<List<char[]>>)current);
            }
            return nexts;
        }

        private void addNextNode(CharNode<List<char[]>> node, char c, CharNode<List<char[]>> next) {
            ((CharConnectionAdaptor)node).addNextNode(c, next);
        }
    }

    public static class MergePatterns
    implements JoinStrategy<List<char[]>> {
        public List<char[]> join(List<char[]> existing, List<char[]> next) {
            if (existing == null) {
                return new ArrayList<char[]>(next);
            }
            existing.add(next.get(1));
            return existing;
        }
    }
}

