/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.patternsearch.chars;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import net.amygdalum.regexparser.RegexNode;
import net.amygdalum.regexparser.RegexNodeVisitor;
import net.amygdalum.regexparser.RegexParser;
import net.amygdalum.regexparser.RegexParserOption;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.BestFactorAnalyzer;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.DualGlushkovAutomaton;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.FactorExtender;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.FactorExtenderFactory;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.GlushkovAnalyzer;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.GlushkovAnalyzerOption;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.GlushkovAutomaton;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.GlushkovNormalizer;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.MatchBuilder;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.MatchListener;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.util.bits.BitSet;
import net.amygdalum.util.io.CharProvider;
import net.amygdalum.util.io.ReverseCharProvider;
import net.amygdalum.util.io.StringCharProvider;

public class GlushkovFactorExtender
implements FactorExtender {
    private String pattern;
    private Set<String> bestFactors;
    private DualGlushkovAutomaton factors;
    private GlushkovAutomaton automaton;
    private int minLength;
    private int factorLength;
    private BitSet factorInitial;

    public GlushkovFactorExtender(String pattern, RegexParserOption ... options) {
        RegexNode root = GlushkovFactorExtender.parseAndNormalizeRegex(pattern, options);
        BestFactorAnalyzer bestFactorAnalyzer = new BestFactorAnalyzer(root).analyze();
        GlushkovAnalyzer analyzer = new GlushkovAnalyzer(root).analyze();
        this.pattern = pattern;
        this.bestFactors = bestFactorAnalyzer.getBestFactors(this.asStrings(analyzer.firstChars()), this.asStrings(analyzer.lastChars()));
        this.factors = analyzer.buildReverseAutomaton(GlushkovAnalyzerOption.FACTORS);
        this.automaton = analyzer.buildAutomaton(new GlushkovAnalyzerOption[0]);
        this.minLength = analyzer.minLength();
    }

    private GlushkovFactorExtender(String pattern, DualGlushkovAutomaton factors, GlushkovAutomaton automaton, int minLength, int factorLength, BitSet factorInitial) {
        this.pattern = pattern;
        this.factors = factors;
        this.automaton = automaton;
        this.minLength = minLength;
        this.factorLength = factorLength;
        this.factorInitial = factorInitial;
    }

    private static RegexNode parseAndNormalizeRegex(String pattern, RegexParserOption ... options) {
        RegexParser parser = new RegexParser(pattern, options);
        RegexNode root = parser.parse();
        return (RegexNode)root.accept((RegexNodeVisitor)new GlushkovNormalizer());
    }

    @Override
    public GlushkovFactorExtender forFactor(String factor) {
        BitSet factorInitial = this.backTrack(this.factors.getInitial(), factor);
        return new GlushkovFactorExtender(this.pattern, this.factors, this.automaton, this.minLength, factor.length(), factorInitial);
    }

    private Set<String> asStrings(Set<Character> chars) {
        LinkedHashSet<String> strings = new LinkedHashSet<String>();
        for (Character c : chars) {
            strings.add(c.toString());
        }
        return strings;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    @Override
    public List<String> getBestFactors(int max) {
        LinkedHashSet<String> bestFactorsMax = new LinkedHashSet<String>();
        for (String factor : this.bestFactors) {
            if (factor.length() <= max) {
                bestFactorsMax.add(factor);
                continue;
            }
            bestFactorsMax.add(factor.substring(0, max));
        }
        return new ArrayList<String>(bestFactorsMax);
    }

    @Override
    public boolean hasFactor(String factor) {
        BitSet factorInitial = this.backTrack(this.factors.getInitial(), factor);
        return !factorInitial.isEmpty();
    }

    @Override
    public SortedSet<StringMatch> extendFactor(CharProvider chars, boolean longest) {
        long pos = chars.current();
        List<Long> starts = this.findStarts(chars);
        MatchBuilder listener = new MatchBuilder(longest);
        this.match(starts, chars, listener);
        chars.move(pos);
        return listener.getMatches();
    }

    private BitSet backTrack(BitSet state, String factor) {
        ReverseCharProvider reverse = new ReverseCharProvider((CharProvider)new StringCharProvider(factor, factor.length()));
        while (!reverse.finished() && !state.isEmpty()) {
            char c = reverse.next();
            state = this.factors.next(state, c);
        }
        return state;
    }

    private List<Long> findStarts(CharProvider chars) {
        long factorStart = chars.current() - (long)this.factorLength;
        chars.move(factorStart);
        LinkedList<Long> starts = new LinkedList<Long>();
        BitSet state = this.factorInitial;
        ReverseCharProvider reverse = new ReverseCharProvider(chars);
        while (!reverse.finished() && !state.isEmpty()) {
            if (this.factors.isFinal(state)) {
                starts.add(0, chars.current());
            }
            char c = reverse.next();
            state = this.factors.next(state, c);
        }
        if (reverse.finished() && this.factors.isFinal(state)) {
            starts.add(0, chars.current());
        }
        return starts;
    }

    private void match(List<Long> starts, CharProvider chars, MatchListener ... listeners) {
        boolean notify = listeners != null && listeners.length > 0;
        for (long start : starts) {
            chars.move(start);
            BitSet state = this.automaton.getInitial();
            while (!chars.finished() && !state.isEmpty()) {
                if (notify && this.automaton.isFinal(state)) {
                    long end = chars.current();
                    for (MatchListener listener : listeners) {
                        listener.notify(start, end, chars);
                    }
                }
                char c = chars.next();
                state = this.automaton.next(state, c);
            }
            if (!notify || !chars.finished() || !this.automaton.isFinal(state)) continue;
            long end = chars.current();
            for (MatchListener listener : listeners) {
                listener.notify(start, end, chars);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements FactorExtenderFactory {
        private RegexParserOption[] options;

        public Factory(RegexParserOption ... options) {
            this.options = options;
        }

        @Override
        public FactorExtender of(String pattern) {
            return new GlushkovFactorExtender(pattern, this.options);
        }
    }
}

