/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.patternsearch.chars;

import java.util.HashSet;
import java.util.LinkedList;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.BitParallelAutomaton;
import net.amygdalum.util.bits.BitSet;
import net.amygdalum.util.map.BitSetObjectMap;
import net.amygdalum.util.map.CharObjectMap;

public class GlushkovAutomaton
implements BitParallelAutomaton {
    private BitSet initial;
    private BitSet finals;
    private CharObjectMap<BitSet> reachableByChar;
    private BitSetObjectMap<BitSet> reachableByState;

    public GlushkovAutomaton(BitSet initial, BitSet finals, CharObjectMap<BitSet> reachableByChar, BitSetObjectMap<BitSet> reachableByState) {
        this.initial = initial;
        this.finals = finals;
        this.reachableByChar = reachableByChar;
        this.reachableByState = reachableByState;
    }

    @Override
    public char[] supportedChars() {
        return this.reachableByChar.keys();
    }

    @Override
    public BitSet getInitial() {
        return this.initial;
    }

    @Override
    public boolean isInitial(BitSet state) {
        return this.initial.equals((Object)state);
    }

    @Override
    public BitSet next(BitSet state, char c) {
        BitSet result = (BitSet)this.reachableByState.get(state);
        BitSet byChar = (BitSet)this.reachableByChar.get(c);
        return result.and(byChar);
    }

    @Override
    public boolean isFinal(BitSet state) {
        return !this.finals.and(state).isEmpty();
    }

    @Override
    public int minLength() {
        int length = 0;
        HashSet<BitSet> done = new HashSet<BitSet>();
        LinkedList<BitSet> next = new LinkedList<BitSet>();
        next.add(this.getInitial());
        while (!next.isEmpty()) {
            LinkedList<BitSet> states = next;
            states.removeAll(done);
            next = new LinkedList();
            while (!states.isEmpty()) {
                BitSet current = (BitSet)states.remove();
                if (this.isFinal(current)) {
                    return length;
                }
                done.add(current);
                for (char c : this.reachableByChar.keys()) {
                    next.add(this.next(current, c));
                }
            }
            ++length;
        }
        return length;
    }
}

