/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.patternsearch.chars;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.amygdalum.regexparser.AlternativesNode;
import net.amygdalum.regexparser.AnyCharNode;
import net.amygdalum.regexparser.BoundedLoopNode;
import net.amygdalum.regexparser.CharClassNode;
import net.amygdalum.regexparser.CompClassNode;
import net.amygdalum.regexparser.ConcatNode;
import net.amygdalum.regexparser.DefinedCharNode;
import net.amygdalum.regexparser.EmptyNode;
import net.amygdalum.regexparser.GroupNode;
import net.amygdalum.regexparser.OptionalNode;
import net.amygdalum.regexparser.RangeCharNode;
import net.amygdalum.regexparser.RegexNode;
import net.amygdalum.regexparser.RegexNodeVisitor;
import net.amygdalum.regexparser.SingleCharNode;
import net.amygdalum.regexparser.SpecialCharClassNode;
import net.amygdalum.regexparser.StringNode;
import net.amygdalum.regexparser.UnboundedLoopNode;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.DualGlushkovAutomaton;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.GlushkovAnalyzerOption;
import net.amygdalum.stringsearchalgorithms.patternsearch.chars.GlushkovAutomaton;
import net.amygdalum.util.bits.BitSet;
import net.amygdalum.util.io.BitMaskCharClassMapper;
import net.amygdalum.util.io.CharClassMapper;
import net.amygdalum.util.io.LowByteCharClassMapper;
import net.amygdalum.util.io.SmallRangeCharClassMapper;
import net.amygdalum.util.map.BitSetObjectMap;
import net.amygdalum.util.map.CharObjectMap;
import net.amygdalum.util.text.CharRange;
import net.amygdalum.util.text.CharRangeAccumulator;
import net.amygdalum.util.worklist.WorkSet;

public class GlushkovAnalyzer
implements RegexNodeVisitor<Void> {
    private RegexNode root;
    private List<DefinedCharNode> charCollector;
    private Map<RegexNode, Set<Integer>> first;
    private Map<RegexNode, Set<Integer>> last;
    private Map<Integer, Set<Integer>> follow;
    private Map<Integer, Set<Integer>> precede;
    private Map<RegexNode, Integer> minLength;
    private DefinedCharNode[] chars;
    private int len;
    private CharClassMapper mapper;
    private char[] alphabet;

    public GlushkovAnalyzer(RegexNode root) {
        this.root = root;
        this.first = new LinkedHashMap<RegexNode, Set<Integer>>();
        this.last = new LinkedHashMap<RegexNode, Set<Integer>>();
        this.follow = new LinkedHashMap<Integer, Set<Integer>>();
        this.precede = new LinkedHashMap<Integer, Set<Integer>>();
        this.minLength = new LinkedHashMap<RegexNode, Integer>();
        this.charCollector = new ArrayList<DefinedCharNode>();
        this.charCollector.add(null);
    }

    public CharClassMapper mapper() {
        return this.mapper;
    }

    private DefinedCharNode[] characters() {
        return this.charCollector.toArray(new DefinedCharNode[0]);
    }

    public Set<Character> firstChars() {
        LinkedHashSet<Character> firstChars = new LinkedHashSet<Character>();
        for (int index : this.first(this.root)) {
            for (char c : this.chars[index].chars()) {
                firstChars.add(Character.valueOf(c));
            }
        }
        return firstChars;
    }

    public Set<Character> lastChars() {
        LinkedHashSet<Character> lastChars = new LinkedHashSet<Character>();
        for (int index : this.last(this.root)) {
            for (char c : this.chars[index].chars()) {
                lastChars.add(Character.valueOf(c));
            }
        }
        return lastChars;
    }

    private void first(RegexNode node, Integer ... value) {
        this.first(node, new LinkedHashSet<Integer>(Arrays.asList(value)));
    }

    private void first(RegexNode node, Set<Integer> value) {
        this.first.put(node, value);
    }

    private Set<Integer> first(RegexNode node) {
        return this.first.get(node);
    }

    private List<Set<Integer>> first(List<RegexNode> nodes) {
        ArrayList<Set<Integer>> result = new ArrayList<Set<Integer>>(nodes.size());
        for (RegexNode node : nodes) {
            result.add(this.first(node));
        }
        return result;
    }

    private void last(RegexNode node, Integer ... value) {
        this.last(node, new LinkedHashSet<Integer>(Arrays.asList(value)));
    }

    private void last(RegexNode node, Set<Integer> value) {
        this.last.put(node, value);
    }

    private Set<Integer> last(RegexNode node) {
        return this.last.get(node);
    }

    private List<Set<Integer>> last(List<RegexNode> nodes) {
        ArrayList<Set<Integer>> result = new ArrayList<Set<Integer>>(nodes.size());
        for (RegexNode node : nodes) {
            result.add(this.last(node));
        }
        return result;
    }

    private void appendFollow(int key, Collection<Integer> append) {
        Set<Integer> followSet = this.follow.get(key);
        if (followSet == null) {
            followSet = new LinkedHashSet<Integer>();
            this.follow.put(key, followSet);
        }
        followSet.addAll(append);
    }

    private Set<Integer> follow(Integer i) {
        Set<Integer> set = this.follow.get(i);
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    private void appendPrecede(int key, Collection<Integer> append) {
        Set<Integer> precedeSet = this.precede.get(key);
        if (precedeSet == null) {
            precedeSet = new LinkedHashSet<Integer>();
            this.precede.put(key, precedeSet);
        }
        precedeSet.addAll(append);
    }

    private void minLength(RegexNode node, Integer value) {
        this.minLength.put(node, value);
    }

    private List<Integer> minLength(List<RegexNode> nodes) {
        ArrayList<Integer> result = new ArrayList<Integer>(nodes.size());
        for (RegexNode node : nodes) {
            result.add(this.minLength(node));
        }
        return result;
    }

    private Integer minLength(RegexNode node) {
        return this.minLength.get(node);
    }

    public GlushkovAnalyzer analyze() {
        this.root.accept((RegexNodeVisitor)this);
        this.appendFollow(0, this.first(this.root));
        for (int f : this.first(this.root)) {
            this.appendPrecede(f, Arrays.asList(0));
        }
        this.chars = this.characters();
        this.len = this.chars.length;
        this.mapper = this.computeMapper(this.chars);
        this.alphabet = this.mapper.representatives();
        return this;
    }

    private CharClassMapper computeMapper(DefinedCharNode[] nodes) {
        boolean lowByte;
        CharRangeAccumulator acc = new CharRangeAccumulator();
        for (DefinedCharNode node : nodes) {
            if (node == null) continue;
            acc.split(node.getFrom(), node.getTo());
        }
        List liveRanges = acc.getRanges();
        boolean smallRange = this.computeSmallRange(liveRanges, lowByte = this.computeLowByte(liveRanges));
        if (smallRange) {
            return new SmallRangeCharClassMapper(liveRanges);
        }
        if (lowByte) {
            return new LowByteCharClassMapper(liveRanges);
        }
        return new BitMaskCharClassMapper(liveRanges);
    }

    public boolean computeLowByte(List<CharRange> liveRanges) {
        HashSet<Integer> highbytes = new HashSet<Integer>();
        for (CharRange range : liveRanges) {
            highbytes.add(range.from & 0xFF00);
            highbytes.add(range.to & 0xFF00);
        }
        return highbytes.size() <= 1;
    }

    public boolean computeSmallRange(List<CharRange> liveRanges, boolean lowByte) {
        if (liveRanges.isEmpty()) {
            return true;
        }
        char min = liveRanges.get((int)0).from;
        char max = liveRanges.get((int)(liveRanges.size() - 1)).to;
        if (lowByte) {
            return max - min <= 64;
        }
        return max - min <= 256;
    }

    public GlushkovAutomaton buildAutomaton(GlushkovAnalyzerOption ... options) {
        BitSet initial = GlushkovAnalyzerOption.FACTORS.in(options) ? this.all() : this.initial();
        BitSet finals = this.finals();
        CharObjectMap<BitSet> reachableByChar = this.reachableByChar(options);
        BitSetObjectMap<BitSet> reachableByState = this.reachableByState(reachableByChar, options);
        return new GlushkovAutomaton(initial, finals, reachableByChar, reachableByState);
    }

    public DualGlushkovAutomaton buildReverseAutomaton(GlushkovAnalyzerOption ... options) {
        BitSet initial = GlushkovAnalyzerOption.FACTORS.in(options) ? this.all() : this.finals();
        BitSet finals = this.initial();
        CharObjectMap<BitSet> reachableByChar = this.reachableByChar(options);
        BitSetObjectMap<BitSet> reachableByState = this.sourceableByState(reachableByChar, options);
        return new DualGlushkovAutomaton(initial, finals, reachableByChar, reachableByState);
    }

    public int minLength() {
        return this.minLength(this.root);
    }

    private BitSet initial() {
        return BitSet.bits((int)this.len, (int[])new int[]{0});
    }

    private CharObjectMap<BitSet> reachableByChar(GlushkovAnalyzerOption ... options) {
        BitSet defaultValue = GlushkovAnalyzerOption.SELF_LOOP.in(options) ? this.initial() : BitSet.empty((int)this.len);
        CharObjectMap reachable = new CharObjectMap((Object)defaultValue);
        for (int i = 1; i < this.len; ++i) {
            for (char c : this.chars[i].chars()) {
                BitSet b = (BitSet)reachable.get(c);
                if (b == defaultValue) {
                    b = defaultValue.clone();
                    reachable.put(c, (Object)b);
                }
                b.set(i);
            }
        }
        return reachable;
    }

    private BitSetObjectMap<BitSet> reachableByState(CharObjectMap<BitSet> reachableByChar, GlushkovAnalyzerOption ... options) {
        BitSet defaultValue = GlushkovAnalyzerOption.SELF_LOOP.in(options) ? this.initial() : BitSet.empty((int)this.len);
        BitSet start = GlushkovAnalyzerOption.FACTORS.in(options) ? this.all() : this.initial();
        return new Collector(this.len, this.alphabet, this.follow, reachableByChar, defaultValue).collect(start);
    }

    private BitSetObjectMap<BitSet> sourceableByState(CharObjectMap<BitSet> reachableByChar, GlushkovAnalyzerOption ... options) {
        BitSet defaultValue = GlushkovAnalyzerOption.SELF_LOOP.in(options) ? this.finals() : BitSet.empty((int)this.len);
        BitSet start = GlushkovAnalyzerOption.FACTORS.in(options) ? this.all() : this.finals();
        return new Collector(this.len, this.alphabet, this.precede, reachableByChar, defaultValue).collect(this.allFinals(start, reachableByChar, options));
    }

    private List<BitSet> allFinals(BitSet initial, CharObjectMap<BitSet> reachableByChar, GlushkovAnalyzerOption ... options) {
        BitSet start = GlushkovAnalyzerOption.FACTORS.in(options) ? this.all() : this.initial();
        BitSet defaultValue = GlushkovAnalyzerOption.SELF_LOOP.in(options) ? this.initial() : BitSet.empty((int)this.len);
        Collection<BitSet> possible = this.possibleStartsByState(start, reachableByChar, defaultValue);
        return this.filterPossiblesStartsByChar(initial, reachableByChar, possible);
    }

    private Collection<BitSet> possibleStartsByState(BitSet next, CharObjectMap<BitSet> reachableByChar, BitSet defaultValue) {
        LinkedHashMap<BitSet, BitSet> possible = new LinkedHashMap<BitSet, BitSet>();
        this.possibleStartsByState(possible, next, reachableByChar, defaultValue);
        return possible.values();
    }

    private void possibleStartsByState(Map<BitSet, BitSet> possible, BitSet start, CharObjectMap<BitSet> reachableByChar, BitSet defaultValue) {
        WorkSet nexts = new WorkSet();
        nexts.add(start);
        nexts.add(start.or(this.initial()));
        while (!nexts.isEmpty()) {
            BitSet next = (BitSet)nexts.remove();
            BitSet td = possible.get(next);
            if (td != null) continue;
            td = defaultValue.clone();
            for (int i = 0; i < this.len; ++i) {
                if (!next.get(i)) continue;
                td = td.or(GlushkovAnalyzer.bits(this.len, this.follow(i)));
            }
            possible.put(next, td);
            BitSet n = td.clone();
            for (char c : this.alphabet) {
                BitSet cand = n.and((BitSet)reachableByChar.get(c));
                if (!nexts.contains(cand)) {
                    nexts.add(cand);
                }
                if (nexts.contains(cand = cand.or(this.initial()))) continue;
                nexts.add(cand);
            }
        }
    }

    private List<BitSet> filterPossiblesStartsByChar(BitSet initial, CharObjectMap<BitSet> reachableByChar, Collection<BitSet> possible) {
        LinkedHashSet<BitSet> filteredPossible = new LinkedHashSet<BitSet>();
        for (BitSet value : possible) {
            BitSet finalValue = initial.and(value);
            for (char c : this.alphabet) {
                BitSet charFilter = (BitSet)reachableByChar.get(c);
                BitSet state = finalValue.and(charFilter);
                if (state.isEmpty()) continue;
                filteredPossible.add(state);
            }
        }
        return new ArrayList<BitSet>(filteredPossible);
    }

    private static BitSet bits(int len, Set<Integer> ints) {
        BitSet bits = BitSet.empty((int)len);
        for (int i : ints) {
            bits.set(i);
        }
        return bits;
    }

    private BitSet finals() {
        BitSet finals = BitSet.empty((int)this.len);
        for (int x : this.last(this.root)) {
            finals.set(x);
        }
        if (this.minLength.get(this.root) == 0) {
            finals.set(0);
        }
        return finals;
    }

    private BitSet all() {
        return BitSet.all((int)this.len);
    }

    public Void visitAlternatives(AlternativesNode node) {
        List subNodes = node.getSubNodes();
        for (RegexNode subNode : subNodes) {
            subNode.accept((RegexNodeVisitor)this);
        }
        this.first((RegexNode)node, this.union(this.first(subNodes)));
        this.last((RegexNode)node, this.union(this.last(subNodes)));
        this.minLength((RegexNode)node, this.minimum(this.minLength(subNodes)));
        return null;
    }

    public Void visitAnyChar(AnyCharNode node) {
        throw new UnsupportedOperationException("decomposed normal from does not contain char classes");
    }

    public Void visitCharClass(CharClassNode node) {
        throw new UnsupportedOperationException("decomposed normal from does not contain char classes");
    }

    public Void visitCompClass(CompClassNode node) {
        throw new UnsupportedOperationException("decomposed normal from does not contain char classes");
    }

    public Void visitConcat(ConcatNode node) {
        int j;
        RegexNode current;
        int i;
        List subNodes = node.getSubNodes();
        for (RegexNode subNode : subNodes) {
            subNode.accept((RegexNodeVisitor)this);
        }
        this.first((RegexNode)node, this.union(this.concatFirst(subNodes)));
        this.last((RegexNode)node, this.union(this.concatLast(subNodes)));
        this.minLength((RegexNode)node, this.sum(this.minLength(subNodes)));
        block1: for (i = 0; i < subNodes.size() - 1; ++i) {
            current = (RegexNode)subNodes.get(i);
            for (j = i + 1; j < subNodes.size(); ++j) {
                RegexNode next = (RegexNode)subNodes.get(j);
                for (int x : this.last(current)) {
                    this.appendFollow(x, this.first(next));
                }
                if (this.minLength(next) > 0) continue block1;
            }
        }
        block4: for (i = subNodes.size() - 1; i >= 1; --i) {
            current = (RegexNode)subNodes.get(i);
            for (j = i - 1; j >= 0; --j) {
                RegexNode prev = (RegexNode)subNodes.get(j);
                for (int y : this.first(current)) {
                    this.appendPrecede(y, this.last(prev));
                }
                if (this.minLength(prev) > 0) continue block4;
            }
        }
        return null;
    }

    private List<Set<Integer>> concatFirst(List<RegexNode> subNodes) {
        ArrayList<Set<Integer>> result = new ArrayList<Set<Integer>>();
        int minLength = 0;
        for (RegexNode subNode : subNodes) {
            if (minLength > 0) break;
            result.add(this.first(subNode));
            minLength += this.minLength(subNode).intValue();
        }
        return result;
    }

    private List<Set<Integer>> concatLast(List<RegexNode> subNodes) {
        ArrayList<RegexNode> reverseSubNodes = new ArrayList<RegexNode>(subNodes);
        Collections.reverse(reverseSubNodes);
        ArrayList<Set<Integer>> result = new ArrayList<Set<Integer>>();
        int minLength = 0;
        for (RegexNode subNode : reverseSubNodes) {
            if (minLength > 0) break;
            result.add(this.last(subNode));
            minLength += this.minLength(subNode).intValue();
        }
        return result;
    }

    public Void visitEmpty(EmptyNode node) {
        this.first((RegexNode)node, new HashSet<Integer>());
        this.last((RegexNode)node, new HashSet<Integer>());
        this.minLength((RegexNode)node, 0);
        return null;
    }

    public Void visitGroup(GroupNode node) {
        RegexNode subNode = node.getSubNode();
        subNode.accept((RegexNodeVisitor)this);
        this.first((RegexNode)node, this.first(subNode));
        this.last((RegexNode)node, this.last(subNode));
        this.minLength((RegexNode)node, this.minLength(subNode));
        return null;
    }

    public Void visitBoundedLoop(BoundedLoopNode node) {
        throw new UnsupportedOperationException("decomposed normal from does not contain bounded loops");
    }

    public Void visitUnboundedLoop(UnboundedLoopNode node) {
        if (node.getFrom() > 0) {
            throw new UnsupportedOperationException("decomposed normal from does not contain plus loops");
        }
        RegexNode subNode = node.getSubNode();
        subNode.accept((RegexNodeVisitor)this);
        this.first((RegexNode)node, this.first(subNode));
        this.last((RegexNode)node, this.last(subNode));
        this.minLength((RegexNode)node, 0);
        RegexNode current = subNode;
        RegexNode next = subNode;
        for (int x : this.last(current)) {
            this.appendFollow(x, this.first(next));
        }
        for (int y : this.first(next)) {
            this.appendPrecede(y, this.last(current));
        }
        return null;
    }

    public Void visitOptional(OptionalNode node) {
        RegexNode subNode = node.getSubNode();
        subNode.accept((RegexNodeVisitor)this);
        this.first((RegexNode)node, this.first(subNode));
        this.last((RegexNode)node, this.last(subNode));
        this.minLength((RegexNode)node, 0);
        return null;
    }

    public Void visitRangeChar(RangeCharNode node) {
        int pos = this.charCollector.size();
        this.charCollector.add((DefinedCharNode)node);
        this.first((RegexNode)node, pos);
        this.last((RegexNode)node, pos);
        this.minLength((RegexNode)node, 1);
        return null;
    }

    public Void visitSingleChar(SingleCharNode node) {
        int pos = this.charCollector.size();
        this.charCollector.add((DefinedCharNode)node);
        this.first((RegexNode)node, pos);
        this.last((RegexNode)node, pos);
        this.minLength((RegexNode)node, 1);
        return null;
    }

    public Void visitSpecialCharClass(SpecialCharClassNode node) {
        throw new UnsupportedOperationException("decomposed normal from does not contain char classes");
    }

    public Void visitString(StringNode node) {
        throw new UnsupportedOperationException("decomposed normal from does not contain strings");
    }

    private Set<Integer> union(List<Set<Integer>> values) {
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (Set<Integer> value : values) {
            result.addAll(value);
        }
        return result;
    }

    private Integer minimum(List<Integer> values) {
        int min = Integer.MAX_VALUE;
        for (Integer value : values) {
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    private Integer sum(List<Integer> values) {
        int sum = 0;
        for (Integer value : values) {
            sum += value.intValue();
        }
        return sum;
    }

    private static class Collector {
        private int len;
        private char[] alphabet;
        private Map<Integer, Set<Integer>> next;
        private BitSetObjectMap<BitSet> accumulator;
        private CharObjectMap<BitSet> reachableByChar;
        private BitSet defaultValue;
        private WorkSet<BitSet> todo;

        public Collector(int len, char[] alphabet, Map<Integer, Set<Integer>> next, CharObjectMap<BitSet> reachableByChar, BitSet defaultValue) {
            this.len = len;
            this.alphabet = alphabet;
            this.next = next;
            this.accumulator = new BitSetObjectMap((Object)defaultValue);
            this.reachableByChar = reachableByChar;
            this.defaultValue = defaultValue;
            this.todo = new WorkSet();
        }

        public BitSetObjectMap<BitSet> collect(BitSet ... start) {
            return this.collect(Arrays.asList(start));
        }

        public BitSetObjectMap<BitSet> collect(Collection<BitSet> start) {
            this.todo.addAll(start);
            while (!this.todo.isEmpty()) {
                BitSet current = (BitSet)this.todo.remove();
                this.computeReachables(current);
            }
            return this.accumulator;
        }

        private void computeReachables(BitSet d) {
            BitSet td = (BitSet)this.accumulator.get(d);
            if (td == this.defaultValue) {
                td = this.defaultValue.clone();
            }
            for (int i = 0; i < this.len; ++i) {
                if (!d.get(i)) continue;
                td = td.or(GlushkovAnalyzer.bits(this.len, this.next(i)));
            }
            this.accumulator.put(d, (Object)td);
            BitSet n = td.clone();
            for (char c : this.alphabet) {
                BitSet next = n.and((BitSet)this.reachableByChar.get(c));
                if (this.accumulator.get(next) != this.defaultValue) continue;
                this.todo.add((Object)next);
            }
        }

        private Set<Integer> next(Integer i) {
            Set<Integer> set = this.next.get(i);
            if (set == null) {
                return Collections.emptySet();
            }
            return set;
        }
    }
}

