/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.util.map;

import java.util.BitSet;
import net.amygdalum.util.map.TuneableMap;

public class BitSetObjectMap<T>
extends TuneableMap {
    private static final BitSet NULL_KEY = null;
    private float loadFactor;
    private int mask;
    private int expandAt;
    private int size;
    private BitSet[] keys;
    private T[] values;
    private T defaultValue;
    private T nullValue;

    public BitSetObjectMap(T defaultValue) {
        this(16, 0.7f, defaultValue);
    }

    public BitSetObjectMap(int initialSize, float loadFactor, T defaultValue) {
        this.loadFactor = loadFactor;
        this.mask = BitSetObjectMap.mask(initialSize, loadFactor);
        this.expandAt = initialSize;
        this.size = 0;
        this.keys = new BitSet[this.mask + 1];
        this.values = new Object[this.mask + 1];
        this.defaultValue = defaultValue;
        this.nullValue = defaultValue;
    }

    public BitSet[] keys() {
        int size = this.size;
        if (this.nullValue != this.defaultValue) {
            ++size;
        }
        BitSet[] keys = new BitSet[size];
        int pos = 0;
        for (BitSet c : this.keys) {
            if (c == NULL_KEY || c == null) continue;
            keys[pos] = c;
            ++pos;
        }
        if (this.nullValue != this.defaultValue && pos < keys.length) {
            keys[pos] = NULL_KEY;
        }
        return keys;
    }

    public BitSetObjectMap<T> add(BitSet key, T value) {
        this.put(key, value);
        return this;
    }

    public void put(BitSet key, T value) {
        if (key == NULL_KEY) {
            this.nullValue = value;
            return;
        }
        int slot = BitSetObjectMap.hash(key.hashCode()) & this.mask;
        while (this.keys[slot] != NULL_KEY && this.keys[slot] != null && !this.keys[slot].equals(key)) {
            slot = slot + 1 & this.mask;
        }
        if (this.keys[slot] == NULL_KEY) {
            ++this.size;
        }
        this.keys[slot] = key;
        this.values[slot] = value;
        if (this.size > this.expandAt) {
            this.expand(this.size * 2);
        }
    }

    public T get(BitSet key) {
        if (key == NULL_KEY) {
            return this.nullValue;
        }
        int slot = BitSetObjectMap.hash(key.hashCode()) & this.mask;
        while (this.keys[slot] != NULL_KEY && this.keys[slot] != null && !this.keys[slot].equals(key)) {
            slot = slot + 1 & this.mask;
        }
        if (this.keys[slot] == NULL_KEY) {
            return this.defaultValue;
        }
        return this.values[slot];
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    private void expand(int size) {
        int i;
        int mask = BitSetObjectMap.mask(size, this.loadFactor);
        BitSet[] oldkeys = this.keys;
        T[] oldvalues = this.values;
        BitSet[] keys = new BitSet[mask + 1];
        Object[] values = new Object[mask + 1];
        int[] delayed = new int[this.size];
        int pos = 0;
        for (i = 0; i < oldkeys.length; ++i) {
            BitSet key = oldkeys[i];
            if (key == NULL_KEY || key == null) continue;
            T value = oldvalues[i];
            int slot = BitSetObjectMap.hash(key.hashCode()) & mask;
            if (keys[slot] == NULL_KEY || keys[slot] == null) {
                keys[slot] = key;
                values[slot] = value;
                continue;
            }
            delayed[pos] = i;
            ++pos;
        }
        for (i = 0; i < pos; ++i) {
            int j = delayed[i];
            BitSet key = oldkeys[j];
            T value = oldvalues[j];
            int slot = BitSetObjectMap.hash(key.hashCode()) & mask;
            while (keys[slot] != key && keys[slot] != NULL_KEY) {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
            values[slot] = value;
        }
        this.expandAt = size;
        this.mask = mask;
        this.keys = keys;
        this.values = values;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{\n");
        if (this.keys.length > 0) {
            BitSet key = this.keys[0];
            T value = this.values[0];
            buffer.append(this.toString(key)).append(": ").append(value);
        }
        for (int i = 1; i < this.keys.length; ++i) {
            BitSet key = this.keys[i];
            T value = this.values[0];
            buffer.append(",\n").append(this.toString(key)).append(": ").append(value);
        }
        buffer.append("\n}");
        return buffer.toString();
    }

    private String toString(BitSet bits) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < bits.size(); ++i) {
            if (i / 4 > 0 && i % 4 == 0) {
                buffer.append(' ');
            }
            if (bits.get(i)) {
                buffer.append(1);
                continue;
            }
            buffer.append(0);
        }
        return buffer.toString();
    }
}

