/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.chars;

import java.util.Arrays;
import net.amygdalum.stringsearchalgorithms.io.CharProvider;
import net.amygdalum.stringsearchalgorithms.search.AbstractStringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.chars.SupportsCharClasses;
import net.amygdalum.util.map.CharLongMap;
import net.amygdalum.util.map.CharObjectMap;
import net.amygdalum.util.text.CharAlphabet;
import net.amygdalum.util.text.CharMapping;

public class ShiftOr
implements StringSearchAlgorithm {
    private int patternLength;
    private BitMapStates states;

    public ShiftOr(String pattern) {
        this(pattern, CharMapping.IDENTITY);
    }

    public ShiftOr(String pattern, CharMapping mapping) {
        this.patternLength = pattern.length();
        this.states = ShiftOr.computeStates(pattern.toCharArray(), mapping);
    }

    private static BitMapStates computeStates(char[] pattern, CharMapping mapping) {
        CharAlphabet alphabet = CharAlphabet.ranged(pattern, mapping);
        int compactSize = Math.max(256, pattern.length * 2);
        if (alphabet.getRange() < compactSize) {
            if (pattern.length > 64) {
                return new QuickMultiLongStates(pattern, alphabet, mapping);
            }
            return new QuickSingleLongStates(pattern, alphabet, mapping);
        }
        if (pattern.length > 64) {
            return new SmartMultiLongStates(pattern, mapping);
        }
        return new SmartSingleLongStates(pattern, mapping);
    }

    @Override
    public int getPatternLength() {
        return this.patternLength;
    }

    @Override
    public StringFinder createFinder(CharProvider chars, StringFinderOption ... options) {
        if (this.states.supportsSingle()) {
            return new LongFinder(chars, options);
        }
        return new MultiLongFinder(chars, options);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static class SmartMultiLongStates
    extends MultiLongBitMapStates {
        private CharObjectMap<long[]> states;

        public SmartMultiLongStates(char[] pattern, CharMapping mapping) {
            this.states = SmartMultiLongStates.computeStates(pattern, mapping);
        }

        private static CharObjectMap<long[]> computeStates(char[] pattern, CharMapping mapping) {
            long[] zero = SmartMultiLongStates.computeZero(pattern.length);
            CharObjectMap<long[]> map = new CharObjectMap<long[]>(zero);
            for (int i = 0; i < pattern.length; ++i) {
                int slot = (pattern.length - 1) / 64 - i / 64;
                int offset = i % 64;
                for (char c : mapping.map(pattern[i])) {
                    long[] newState = map.get(c);
                    if (newState == zero) {
                        newState = SmartMultiLongStates.computeZero(pattern.length);
                    }
                    int n = slot;
                    newState[n] = newState[n] & (1L << offset ^ 0xFFFFFFFFFFFFFFFFL);
                    map.put(c, newState);
                }
            }
            return map;
        }

        @Override
        public long[] all(char c) {
            return this.states.get(c);
        }
    }

    private static class QuickMultiLongStates
    extends MultiLongBitMapStates {
        private char minChar;
        private char maxChar;
        private long[][] characters;
        private long[] zero;

        public QuickMultiLongStates(char[] pattern, CharAlphabet alphabet, CharMapping mapping) {
            this.minChar = alphabet.minChar();
            this.maxChar = alphabet.maxChar();
            this.characters = QuickMultiLongStates.computeStates(pattern, mapping, this.minChar, this.maxChar);
            this.zero = QuickMultiLongStates.computeZero(pattern.length);
        }

        private static long[][] computeStates(char[] pattern, CharMapping mapping, char min, char max) {
            long[][] characters = new long[max - min + 1][];
            for (int c = min; c <= max; ++c) {
                characters[c - min] = QuickMultiLongStates.computeZero(pattern.length);
            }
            for (int i = 0; i < pattern.length; ++i) {
                int slot = (pattern.length - 1) / 64 - i / 64;
                int offset = i % 64;
                for (char c : mapping.map(pattern[i])) {
                    long[] lArray = characters[c - min];
                    int n = slot;
                    lArray[n] = lArray[n] & (1L << offset ^ 0xFFFFFFFFFFFFFFFFL);
                }
            }
            return characters;
        }

        @Override
        public long[] all(char c) {
            if (c < this.minChar || c > this.maxChar) {
                return this.zero;
            }
            return this.characters[c - this.minChar];
        }
    }

    private static abstract class MultiLongBitMapStates
    implements BitMapStates {
        private MultiLongBitMapStates() {
        }

        public static long[] computeZero(int length) {
            long[] zero = new long[(length - 1) / 64 + 1];
            Arrays.fill(zero, -1L);
            return zero;
        }

        @Override
        public boolean supportsSingle() {
            return false;
        }

        @Override
        public long single(char c) {
            throw new UnsupportedOperationException();
        }
    }

    private static class SmartSingleLongStates
    extends SingleLongBitMapStates {
        private CharLongMap states;

        public SmartSingleLongStates(char[] pattern, CharMapping mapping) {
            this.states = SmartSingleLongStates.computeStates(pattern, mapping);
        }

        private static CharLongMap computeStates(char[] pattern, CharMapping mapping) {
            CharLongMap map = new CharLongMap(-1L);
            for (int i = 0; i < pattern.length; ++i) {
                for (char c : mapping.map(pattern[i])) {
                    long newState = map.get(c) & (1L << i ^ 0xFFFFFFFFFFFFFFFFL);
                    map.put(c, newState);
                }
            }
            return map;
        }

        @Override
        public long single(char c) {
            return this.states.get(c);
        }
    }

    private static class QuickSingleLongStates
    extends SingleLongBitMapStates {
        private char minChar;
        private char maxChar;
        private long[] characters;

        public QuickSingleLongStates(char[] pattern, CharAlphabet alphabet, CharMapping mapping) {
            this.minChar = alphabet.minChar();
            this.maxChar = alphabet.maxChar();
            this.characters = QuickSingleLongStates.computeStates(pattern, mapping, this.minChar, this.maxChar);
        }

        private static long[] computeStates(char[] pattern, CharMapping mapping, char min, char max) {
            long[] characters = new long[max - min + 1];
            Arrays.fill(characters, -1L);
            for (int i = 0; i < pattern.length; ++i) {
                for (char c : mapping.map(pattern[i])) {
                    int n = c - min;
                    characters[n] = characters[n] & (1L << i ^ 0xFFFFFFFFFFFFFFFFL);
                }
            }
            return characters;
        }

        @Override
        public long single(char c) {
            if (c < this.minChar || c > this.maxChar) {
                return -1L;
            }
            return this.characters[c - this.minChar];
        }
    }

    private static abstract class SingleLongBitMapStates
    implements BitMapStates {
        private SingleLongBitMapStates() {
        }

        @Override
        public boolean supportsSingle() {
            return true;
        }

        @Override
        public long[] all(char c) {
            return new long[]{this.single(c)};
        }
    }

    public static interface BitMapStates {
        public static final long ALLBITS = -1L;

        public boolean supportsSingle();

        public long single(char var1);

        public long[] all(char var1);
    }

    public static class Factory
    implements StringSearchAlgorithmFactory,
    SupportsCharClasses {
        private CharMapping mapping;

        @Override
        public void enableCharClasses(CharMapping mapping) {
            this.mapping = mapping;
        }

        @Override
        public StringSearchAlgorithm of(String pattern) {
            if (this.mapping == null) {
                return new ShiftOr(pattern);
            }
            return new ShiftOr(pattern, this.mapping);
        }
    }

    private class MultiLongFinder
    extends Finder {
        private long[] state;

        public MultiLongFinder(CharProvider chars, StringFinderOption ... options) {
            super(chars, options);
            this.state = new long[(ShiftOr.this.patternLength - 1) / 64 + 1];
            Arrays.fill(this.state, -1L);
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.chars.current()) {
                this.chars.move(pos);
            }
            Arrays.fill(this.state, -1L);
        }

        @Override
        public StringMatch findNext() {
            while (!this.chars.finished()) {
                char nextChar = this.chars.next();
                long[] bits = ShiftOr.this.states.all(nextChar);
                this.state = this.next(this.state, bits);
                if ((this.state[0] | this.finalstate) == -1L) continue;
                return this.createMatch();
            }
            return null;
        }

        private long[] next(long[] state, long[] bits) {
            for (int i = 0; i < state.length; ++i) {
                int j = i + 1;
                long leastBit = j < state.length ? state[j] >>> 63 : 0L;
                state[i] = state[i] << 1 | leastBit | bits[i];
            }
            return state;
        }
    }

    private class LongFinder
    extends Finder {
        private long state;

        public LongFinder(CharProvider chars, StringFinderOption ... options) {
            super(chars, options);
            this.state = -1L;
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.chars.current()) {
                this.chars.move(pos);
            }
            this.state = -1L;
        }

        @Override
        public StringMatch findNext() {
            while (!this.chars.finished()) {
                char nextChar = this.chars.next();
                long bits = ShiftOr.this.states.single(nextChar);
                this.state = this.state << 1 | bits;
                if ((this.state | this.finalstate) == -1L) continue;
                return this.createMatch();
            }
            return null;
        }
    }

    private abstract class Finder
    extends AbstractStringFinder {
        protected final long finalstate;
        protected CharProvider chars;

        public Finder(CharProvider chars, StringFinderOption ... options) {
            super(options);
            this.finalstate = 1L << (ShiftOr.this.patternLength - 1) % 64 ^ 0xFFFFFFFFFFFFFFFFL;
            this.chars = chars;
        }

        protected StringMatch createMatch() {
            long end = this.chars.current();
            long start = end - (long)ShiftOr.this.patternLength;
            String s = this.chars.slice(start, end);
            return new StringMatch(start, end, s);
        }
    }
}

