/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.chars;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.amygdalum.stringsearchalgorithms.io.CharProvider;
import net.amygdalum.stringsearchalgorithms.search.BufferedStringFinder;
import net.amygdalum.stringsearchalgorithms.search.MatchOption;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.chars.MultiStringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.chars.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.chars.TrieNode;
import net.amygdalum.util.map.CharObjectMap;
import net.amygdalum.util.text.CharUtils;
import net.amygdalum.util.text.StringUtils;

public class AhoCorasick
implements StringSearchAlgorithm {
    private TrieNode<String> trie;
    private int minLength;

    public AhoCorasick(Collection<String> patterns) {
        List<char[]> charpatterns = StringUtils.toCharArray(patterns);
        this.trie = AhoCorasick.computeTrie(charpatterns);
        this.minLength = CharUtils.minLength(charpatterns);
    }

    private static TrieNode<String> computeTrie(List<char[]> charpatterns) {
        TrieNode<String> trie = new TrieNode<String>();
        for (char[] pattern : charpatterns) {
            trie.extend(pattern, new String(pattern));
        }
        return AhoCorasick.computeSupportTransition(trie);
    }

    @Override
    public StringFinder createFinder(CharProvider chars, StringFinderOption ... options) {
        if (MatchOption.LONGEST_MATCH.in(options)) {
            return new LongestMatchFinder(chars, options);
        }
        return new NextMatchFinder(chars, options);
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    private static TrieNode<String> computeSupportTransition(TrieNode<String> trie) {
        LinkedList<TrieNode> worklist = new LinkedList<TrieNode>();
        worklist.add(trie);
        while (!worklist.isEmpty()) {
            TrieNode current = (TrieNode)worklist.remove();
            for (CharObjectMap.Entry next : current.getNexts().cursor()) {
                TrieNode nextTrie = (TrieNode)next.value;
                AhoCorasick.computeSupport(current, next.key, nextTrie, trie);
                worklist.add(nextTrie);
            }
        }
        return trie;
    }

    private static void computeSupport(TrieNode<String> parent, char c, TrieNode<String> trie, TrieNode<String> init) {
        if (parent != null && trie instanceof TrieNode) {
            TrieNode<String> down;
            for (down = parent.getFallback(); down != null && down.nextNode(c) == null; down = down.getFallback()) {
            }
            if (down != null) {
                TrieNode<String> next = down.nextNode(c);
                trie.addFallback(next);
                String nextMatch = next.getAttached();
                if (nextMatch != null && trie.getAttached() == null) {
                    trie.setAttached(nextMatch);
                }
            } else {
                trie.addFallback(init);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements MultiStringSearchAlgorithmFactory {
        @Override
        public StringSearchAlgorithm of(Collection<String> patterns) {
            return new AhoCorasick(patterns);
        }
    }

    private class LongestMatchFinder
    extends Finder {
        public LongestMatchFinder(CharProvider chars, StringFinderOption ... options) {
            super(chars, options);
        }

        @Override
        public StringMatch findNext() {
            while (!this.chars.finished()) {
                TrieNode nextcurrent;
                char c = this.chars.next();
                TrieNode next = this.current.nextNode(c);
                if (next == null && !this.isBufferEmpty()) {
                    this.chars.prev();
                    break;
                }
                while (next == null && (nextcurrent = this.current.getFallback()) != null) {
                    this.current = nextcurrent;
                    next = this.current.nextNode(c);
                }
                this.current = next != null ? next : AhoCorasick.this.trie;
                if (this.current.getAttached() == null) continue;
                this.push(this.createMatches(this.current, this.chars.current()));
            }
            return this.longestLeftMost();
        }
    }

    private class NextMatchFinder
    extends Finder {
        public NextMatchFinder(CharProvider chars, StringFinderOption ... options) {
            super(chars, options);
        }

        @Override
        public StringMatch findNext() {
            if (!this.isBufferEmpty()) {
                return this.leftMost();
            }
            while (!this.chars.finished()) {
                TrieNode nextcurrent;
                char c = this.chars.next();
                TrieNode next = this.current.nextNode(c);
                while (next == null && (nextcurrent = this.current.getFallback()) != null) {
                    this.current = nextcurrent;
                    next = this.current.nextNode(c);
                }
                this.current = next != null ? next : AhoCorasick.this.trie;
                if (this.current.getAttached() == null) continue;
                this.push(this.createMatches(this.current, this.chars.current()));
                return this.leftMost();
            }
            return null;
        }
    }

    private abstract class Finder
    extends BufferedStringFinder {
        protected CharProvider chars;
        protected TrieNode<String> current;

        public Finder(CharProvider chars, StringFinderOption ... options) {
            super(options);
            this.chars = chars;
            this.current = AhoCorasick.this.trie;
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.chars.current()) {
                this.chars.move(pos);
            }
            this.current = AhoCorasick.this.trie;
            this.clear();
        }

        protected List<StringMatch> createMatches(TrieNode<String> current, long end) {
            ArrayList<StringMatch> matches = new ArrayList<StringMatch>();
            while (current != null) {
                long start;
                StringMatch nextMatch;
                String currentMatch = current.getAttached();
                if (currentMatch != null && !matches.contains(nextMatch = this.createMatch(start = end - (long)currentMatch.length(), end))) {
                    matches.add(nextMatch);
                }
                current = current.getFallback();
            }
            return matches;
        }

        private StringMatch createMatch(long start, long end) {
            String s = this.chars.slice(start, end);
            return new StringMatch(start, end, s);
        }
    }
}

