/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.bytes;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.amygdalum.stringsearchalgorithms.io.ByteProvider;
import net.amygdalum.stringsearchalgorithms.search.BufferedStringFinder;
import net.amygdalum.stringsearchalgorithms.search.MatchOption;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.bytes.MultiStringSearchAlgorithmFactory;
import net.amygdalum.stringsearchalgorithms.search.bytes.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.bytes.TrieNode;
import net.amygdalum.util.text.ByteString;
import net.amygdalum.util.text.ByteUtils;
import net.amygdalum.util.text.StringUtils;

public class WuManber
implements StringSearchAlgorithm {
    private static final int SHIFT_SEED = 17;
    private static final int HASH_SEED = 23;
    private static final int SHIFT_SIZE = 255;
    private static final int HASH_SIZE = 127;
    private int minLength;
    private int maxLength;
    private int block;
    private int[] shift;
    private TrieNode<ByteString>[] hash;

    public WuManber(Collection<String> patterns, Charset charset) {
        List<byte[]> bytepatterns = StringUtils.toByteArray(patterns, charset);
        this.minLength = ByteUtils.minLength(bytepatterns);
        this.maxLength = ByteUtils.maxLength(bytepatterns);
        this.block = WuManber.blockSize(this.minLength, bytepatterns.size());
        this.shift = WuManber.computeShift(bytepatterns, this.block, this.minLength);
        this.hash = WuManber.computeHash(bytepatterns, this.block, charset);
    }

    private static int blockSize(int minLength, int patterns) {
        int optSize = (int)Math.ceil(Math.log(2 * minLength * patterns) / Math.log(256.0));
        if (optSize <= 0) {
            return 1;
        }
        if (optSize > minLength) {
            return minLength;
        }
        return optSize;
    }

    private static int[] computeShift(List<byte[]> patterns, int block, int minLength) {
        int[] shift = new int[255];
        for (int i = 0; i < shift.length; ++i) {
            shift[i] = minLength - block + 1;
        }
        ArrayList<byte[]> patternStrings = new ArrayList<byte[]>();
        HashSet<byte[]> blocks = new HashSet<byte[]>();
        for (byte[] pattern : patterns) {
            patternStrings.add(pattern);
            for (int i = 0; i < pattern.length + 1 - block; ++i) {
                blocks.add(Arrays.copyOfRange(pattern, i, i + block));
            }
        }
        for (byte[] currentBlock : blocks) {
            int shiftKey = WuManber.shiftHash(currentBlock);
            int shiftBy = shift[shiftKey];
            for (byte[] pattern : patternStrings) {
                int rightMost = pattern.length - ByteUtils.lastIndexOf(pattern, currentBlock) - block;
                if (rightMost < 0 || rightMost >= shiftBy) continue;
                shiftBy = rightMost;
            }
            shift[shiftKey] = shiftBy;
        }
        return shift;
    }

    public static int shiftHash(byte[] block) {
        int result = 1;
        for (byte b : block) {
            result = 17 * result + b;
        }
        int hash = result % 255;
        if (hash < 0) {
            hash += 255;
        }
        return hash;
    }

    private static TrieNode<ByteString>[] computeHash(List<byte[]> bytepatterns, int block, Charset charset) {
        TrieNode[] hash = new TrieNode[127];
        for (byte[] pattern : bytepatterns) {
            byte[] lastBlock = Arrays.copyOfRange(pattern, pattern.length - block, pattern.length);
            int hashKey = WuManber.hashHash(lastBlock);
            TrieNode trie = hash[hashKey];
            if (trie == null) {
                hash[hashKey] = trie = new TrieNode();
            }
            TrieNode<ByteString> node = trie.extend(ByteUtils.revert(pattern), 0);
            node.setAttached(new ByteString(pattern, charset));
        }
        return hash;
    }

    public static int hashHash(byte[] block) {
        int result = 1;
        for (byte b : block) {
            result = 23 * result + b;
        }
        int hash = result % 127;
        if (hash < 0) {
            hash += 127;
        }
        return hash;
    }

    @Override
    public StringFinder createFinder(ByteProvider bytes, StringFinderOption ... options) {
        if (MatchOption.LONGEST_MATCH.in(options)) {
            return new LongestMatchFinder(bytes, options);
        }
        return new NextMatchFinder(bytes, options);
    }

    @Override
    public int getPatternLength() {
        return this.minLength;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Factory
    implements MultiStringSearchAlgorithmFactory {
        private Charset charset;

        public Factory() {
            this(StandardCharsets.UTF_16LE);
        }

        public Factory(Charset charset) {
            this.charset = charset;
        }

        @Override
        public StringSearchAlgorithm of(Collection<String> patterns) {
            return new WuManber(patterns, this.charset);
        }
    }

    private class LongestMatchFinder
    extends Finder {
        public LongestMatchFinder(ByteProvider bytes, StringFinderOption ... options) {
            super(bytes, options);
        }

        @Override
        public StringMatch findNext() {
            long lastStart = this.lastStartFromBuffer();
            int lookahead = WuManber.this.minLength - 1;
            while (!this.bytes.finished(lookahead)) {
                long pos = this.bytes.current();
                byte[] lastBlock = this.bytes.between(pos + (long)WuManber.this.minLength - (long)WuManber.this.block, pos + (long)WuManber.this.minLength);
                int shiftKey = WuManber.shiftHash(lastBlock);
                int shiftBy = WuManber.this.shift[shiftKey];
                if (shiftBy == 0) {
                    int hashkey = WuManber.hashHash(lastBlock);
                    TrieNode node = WuManber.this.hash[hashkey];
                    if (node != null) {
                        int patternPointer = lookahead;
                        for (node = node.nextNode(this.bytes.lookahead(patternPointer)); node != null; node = node.nextNode(this.bytes.lookahead(patternPointer))) {
                            ByteString match = (ByteString)node.getAttached();
                            if (match != null) {
                                long start = this.bytes.current() + (long)patternPointer;
                                long end = this.bytes.current() + (long)patternPointer + (long)match.length();
                                StringMatch stringMatch = this.createMatch(start, end);
                                if (lastStart < 0L) {
                                    lastStart = start;
                                }
                                this.push(stringMatch);
                            }
                            if (pos + (long)(--patternPointer) < 0L) break;
                        }
                    }
                    this.bytes.next();
                    if (!this.bufferContainsLongestMatch(lastStart)) continue;
                    break;
                }
                this.bytes.forward(shiftBy);
            }
            return this.longestLeftMost();
        }

        public boolean bufferContainsLongestMatch(long lastStart) {
            return !this.isBufferEmpty() && this.bytes.current() - lastStart - 1L > (long)(WuManber.this.maxLength - WuManber.this.minLength);
        }
    }

    private class NextMatchFinder
    extends Finder {
        public NextMatchFinder(ByteProvider bytes, StringFinderOption ... options) {
            super(bytes, options);
        }

        @Override
        public StringMatch findNext() {
            if (!this.isBufferEmpty()) {
                return this.leftMost();
            }
            int lookahead = WuManber.this.minLength - 1;
            while (!this.bytes.finished(lookahead)) {
                long pos = this.bytes.current();
                byte[] lastBlock = this.bytes.between(pos + (long)WuManber.this.minLength - (long)WuManber.this.block, pos + (long)WuManber.this.minLength);
                int shiftKey = WuManber.shiftHash(lastBlock);
                int shiftBy = WuManber.this.shift[shiftKey];
                if (shiftBy == 0) {
                    int hashkey = WuManber.hashHash(lastBlock);
                    TrieNode node = WuManber.this.hash[hashkey];
                    if (node != null) {
                        int patternPointer = lookahead;
                        for (node = node.nextNode(this.bytes.lookahead(patternPointer)); node != null; node = node.nextNode(this.bytes.lookahead(patternPointer))) {
                            ByteString match = (ByteString)node.getAttached();
                            if (match != null) {
                                long start = this.bytes.current() + (long)patternPointer;
                                long end = this.bytes.current() + (long)patternPointer + (long)match.length();
                                this.push(this.createMatch(start, end));
                            }
                            if (pos + (long)(--patternPointer) < 0L) break;
                        }
                    }
                    this.bytes.next();
                    if (this.isBufferEmpty()) continue;
                    return this.leftMost();
                }
                this.bytes.forward(shiftBy);
            }
            return null;
        }
    }

    private abstract class Finder
    extends BufferedStringFinder {
        protected ByteProvider bytes;

        public Finder(ByteProvider bytes, StringFinderOption ... options) {
            super(options);
            this.bytes = bytes;
        }

        @Override
        public void skipTo(long pos) {
            long last = this.removeMatchesBefore(pos);
            if (last > this.bytes.current()) {
                this.bytes.move(last);
            }
        }

        protected StringMatch createMatch(long start, long end) {
            ByteString slice = this.bytes.slice(start, end);
            return new StringMatch(start, end, slice.getString());
        }
    }
}

