/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.bytes;

import java.util.LinkedHashSet;
import java.util.Set;
import net.amygdalum.util.map.ByteObjectMap;

public class TrieNode<T> {
    private int min = 0;
    private int max = 3;
    private TrieNode<T>[] nexts = TrieNode.trieNodes(4);
    private ByteObjectMap<TrieNode<T>> nextMap;
    private TrieNode<T> fallback;
    private T attached;

    public void reset() {
        this.nexts = TrieNode.trieNodes(4);
        this.min = 0;
        this.max = 3;
    }

    private static <T> TrieNode<T>[] trieNodes(int len) {
        return new TrieNode[len];
    }

    public void addNext(byte b, TrieNode<T> node) {
        if (this.nexts != null) {
            int newMin;
            if (b >= this.min && b <= this.max) {
                this.nexts[b - this.min] = node;
                return;
            }
            int newMax = b > this.max ? b : this.max;
            int newLen = newMax - (newMin = b < this.min ? b : this.min) + 1;
            if (newLen <= 256) {
                TrieNode<T>[] newNexts = TrieNode.trieNodes(newLen);
                int newOffset = this.min - newMin;
                for (int i = 0; i < this.nexts.length; ++i) {
                    newNexts[i + newOffset] = this.nexts[i];
                }
                newNexts[b - newMin] = node;
                this.min = newMin;
                this.max = newMax;
                this.nexts = newNexts;
                return;
            }
        }
        if (this.nextMap == null) {
            this.nextMap = new ByteObjectMap<Object>(null);
            for (int i = 0; i < this.nexts.length; ++i) {
                TrieNode<T> nodeToMap = this.nexts[i];
                byte byteToMap = (byte)(this.min + i);
                if (nodeToMap == null) continue;
                this.nextMap.put(byteToMap, nodeToMap);
            }
            this.nexts = null;
        }
        this.nextMap.put((byte)b, node);
    }

    public ByteObjectMap<TrieNode<T>> getNexts() {
        if (this.nextMap != null) {
            return this.nextMap;
        }
        ByteObjectMap<Object> map = new ByteObjectMap<Object>(null);
        for (int i = 0; i < this.nexts.length; ++i) {
            TrieNode<T> nodeToMap = this.nexts[i];
            byte byteToMap = (byte)(this.min + i);
            if (nodeToMap == null) continue;
            map.put(byteToMap, nodeToMap);
        }
        return map;
    }

    public void addFallback(TrieNode<T> fallback) {
        this.fallback = fallback;
    }

    public TrieNode<T> getFallback() {
        return this.fallback;
    }

    public T getAttached() {
        return this.attached;
    }

    public void setAttached(T attached) {
        this.attached = attached;
    }

    public TrieNode<T> extend(byte[] bytes, T attach) {
        TrieNode<T> node = this.extend(bytes, 0);
        node.setAttached(attach);
        return node;
    }

    public TrieNode<T> extend(byte[] bytes, int i) {
        if (i >= bytes.length) {
            return this;
        }
        TrieNode<T> toExtend = this.findNodeToExtend(bytes[i]);
        return toExtend.extend(bytes, i + 1);
    }

    private TrieNode<T> findNodeToExtend(byte current) {
        TrieNode<T> node = this.nextNode(current);
        if (node == null) {
            node = new TrieNode<T>();
            this.addNext(current, node);
        }
        return node;
    }

    public TrieNode<T> nextNode(byte b) {
        if (this.nextMap != null) {
            return this.nextMap.get(b);
        }
        int index = b - this.min;
        if (index >= this.nexts.length || index < 0) {
            return null;
        }
        return this.nexts[index];
    }

    public TrieNode<T> nextNode(byte[] bytes) {
        TrieNode<T> current = this;
        for (byte b : bytes) {
            if ((current = current.nextNode(b)) != null) continue;
            return null;
        }
        return current;
    }

    public Set<TrieNode<T>> nodes() {
        LinkedHashSet<TrieNode<T>> nodes = new LinkedHashSet<TrieNode<T>>();
        this.colllectNodes(nodes);
        return nodes;
    }

    private void colllectNodes(Set<TrieNode<T>> nodes) {
        if (nodes.contains(this)) {
            return;
        }
        nodes.add(this);
        for (ByteObjectMap.Entry entry : this.getNexts().cursor()) {
            TrieNode node = (TrieNode)entry.value;
            node.colllectNodes(nodes);
        }
    }

    public String toString() {
        if (this.attached != null) {
            return '[' + this.attached.toString() + ']';
        }
        return "[]";
    }
}

