/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.stringsearchalgorithms.search.bytes;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import net.amygdalum.stringsearchalgorithms.io.ByteProvider;
import net.amygdalum.stringsearchalgorithms.search.AbstractStringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinder;
import net.amygdalum.stringsearchalgorithms.search.StringFinderOption;
import net.amygdalum.stringsearchalgorithms.search.StringMatch;
import net.amygdalum.stringsearchalgorithms.search.bytes.Encoding;
import net.amygdalum.stringsearchalgorithms.search.bytes.StringSearchAlgorithm;
import net.amygdalum.stringsearchalgorithms.search.bytes.StringSearchAlgorithmFactory;
import net.amygdalum.util.text.ByteString;

public class ShiftOr
implements StringSearchAlgorithm {
    private int patternLength;
    private BitMapStates states;

    public ShiftOr(String pattern, Charset charset) {
        byte[] encoded = Encoding.encode(pattern, charset);
        this.patternLength = encoded.length;
        this.states = ShiftOr.computeStates(encoded);
    }

    private static BitMapStates computeStates(byte[] pattern) {
        if (pattern.length > 64) {
            return new QuickMultiLongStates(pattern);
        }
        return new QuickSingleLongStates(pattern);
    }

    @Override
    public int getPatternLength() {
        return this.patternLength;
    }

    @Override
    public StringFinder createFinder(ByteProvider bytes, StringFinderOption ... options) {
        if (this.states.supportsSingle()) {
            return new LongFinder(bytes, options);
        }
        return new MultiLongFinder(bytes, options);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static class QuickMultiLongStates
    extends MultiLongBitMapStates {
        private long[][] bytes;

        public QuickMultiLongStates(byte[] pattern) {
            this.bytes = QuickMultiLongStates.computeStates(pattern);
        }

        private static long[][] computeStates(byte[] pattern) {
            int i;
            long[][] bytes = new long[256][];
            for (i = 0; i < bytes.length; ++i) {
                bytes[i] = QuickMultiLongStates.computeZero(pattern.length);
            }
            for (i = 0; i < pattern.length; ++i) {
                byte b = pattern[i];
                int slot = (pattern.length - 1) / 64 - i / 64;
                int offset = i % 64;
                long[] lArray = bytes[b & 0xFF];
                int n = slot;
                lArray[n] = lArray[n] & (1L << offset ^ 0xFFFFFFFFFFFFFFFFL);
            }
            return bytes;
        }

        @Override
        public long[] all(byte b) {
            return this.bytes[b & 0xFF];
        }
    }

    private static abstract class MultiLongBitMapStates
    implements BitMapStates {
        private MultiLongBitMapStates() {
        }

        public static long[] computeZero(int length) {
            long[] zero = new long[(length - 1) / 64 + 1];
            Arrays.fill(zero, -1L);
            return zero;
        }

        @Override
        public boolean supportsSingle() {
            return false;
        }

        @Override
        public long single(byte b) {
            throw new UnsupportedOperationException();
        }
    }

    private static class QuickSingleLongStates
    extends SingleLongBitMapStates {
        private long[] bytes;

        public QuickSingleLongStates(byte[] pattern) {
            this.bytes = QuickSingleLongStates.computeStates(pattern);
        }

        private static long[] computeStates(byte[] pattern) {
            long[] bytes = new long[256];
            Arrays.fill(bytes, -1L);
            for (int i = 0; i < pattern.length; ++i) {
                byte b = pattern[i];
                int n = b & 0xFF;
                bytes[n] = bytes[n] & (1L << i ^ 0xFFFFFFFFFFFFFFFFL);
            }
            return bytes;
        }

        @Override
        public long single(byte b) {
            return this.bytes[b & 0xFF];
        }
    }

    private static abstract class SingleLongBitMapStates
    implements BitMapStates {
        private SingleLongBitMapStates() {
        }

        @Override
        public boolean supportsSingle() {
            return true;
        }

        @Override
        public long[] all(byte b) {
            return new long[]{this.single(b)};
        }
    }

    public static interface BitMapStates {
        public static final long ALLBITS = -1L;

        public boolean supportsSingle();

        public long single(byte var1);

        public long[] all(byte var1);
    }

    public static class Factory
    implements StringSearchAlgorithmFactory {
        private Charset charset;

        public Factory() {
            this(StandardCharsets.UTF_16LE);
        }

        public Factory(Charset charset) {
            this.charset = charset;
        }

        @Override
        public StringSearchAlgorithm of(String pattern) {
            return new ShiftOr(pattern, this.charset);
        }
    }

    private class MultiLongFinder
    extends Finder {
        private long[] state;

        public MultiLongFinder(ByteProvider bytes, StringFinderOption ... options) {
            super(bytes, options);
            this.state = new long[(ShiftOr.this.patternLength - 1) / 64 + 1];
            Arrays.fill(this.state, -1L);
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.bytes.current()) {
                this.bytes.move(pos);
            }
            Arrays.fill(this.state, -1L);
        }

        @Override
        public StringMatch findNext() {
            while (!this.bytes.finished()) {
                byte nextByte = this.bytes.next();
                long[] bits = ShiftOr.this.states.all(nextByte);
                this.state = this.next(this.state, bits);
                if ((this.state[0] | this.finalstate) == -1L) continue;
                return this.createMatch();
            }
            return null;
        }

        private long[] next(long[] state, long[] bits) {
            for (int i = 0; i < state.length; ++i) {
                int j = i + 1;
                long leastBit = j < state.length ? state[j] >>> 63 : 0L;
                state[i] = state[i] << 1 | leastBit | bits[i];
            }
            return state;
        }
    }

    private class LongFinder
    extends Finder {
        private long state;

        public LongFinder(ByteProvider bytes, StringFinderOption ... options) {
            super(bytes, options);
            this.state = 0L;
        }

        @Override
        public void skipTo(long pos) {
            if (pos > this.bytes.current()) {
                this.bytes.move(pos);
            }
            this.state = -1L;
        }

        @Override
        public StringMatch findNext() {
            while (!this.bytes.finished()) {
                byte nextByte = this.bytes.next();
                long bits = ShiftOr.this.states.single(nextByte);
                this.state = this.state << 1 | bits;
                if ((this.state | this.finalstate) == -1L) continue;
                return this.createMatch();
            }
            return null;
        }
    }

    private abstract class Finder
    extends AbstractStringFinder {
        protected final long finalstate;
        protected ByteProvider bytes;

        public Finder(ByteProvider bytes, StringFinderOption ... options) {
            super(options);
            this.finalstate = 1L << (ShiftOr.this.patternLength - 1) % 64 ^ 0xFFFFFFFFFFFFFFFFL;
            this.bytes = bytes;
        }

        protected StringMatch createMatch() {
            long end = this.bytes.current();
            long start = end - (long)ShiftOr.this.patternLength;
            ByteString s = this.bytes.slice(start, end);
            return new StringMatch(start, end, s.getString());
        }
    }
}

